<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Illuminate\Http\Request;
use DB;
use Mail;

class WorkFlowCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'work:flow';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $date = date("H:i");
        $sendSmstime = "11:55";
        $sendSmstimeBefore = "12:05";

        $sid    = 'AC15298329064d30e708bdc83adb95dc54';
        $token  = '5b99af1b1a553786d497d3072c1e29ac'; 
        $client = new Client( $sid, $token );

        if($date > $sendSmstime && $date < $sendSmstimeBefore){

            $flow = DB::table('leads_work_flow')->where('start_flow','yes')->get();
     
            foreach($flow as $flow)
            {
                $adminEmail = DB::table('users')->where('id',$flow->user_id)->first();
                $companyInfo = DB::table('company_info')->where('user_id',$flow->user_id)->where('work_flow','yes')->first();
                
                if($companyInfo != null)
                {
                    $date = date('Y-m-d', strtotime("-".$flow->days_old." days"));
                    
                    if($flow->source == 'all')
                    {
                        $leads = DB::table('leads')->whereDate('created_at',$date)
                                                    ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                                    ->where('admin_email',$adminEmail->email)
                                                    ->get();
                        
                        if($leads->count() > 0){
                            
                            foreach($leads as $leads)
                            {
                                $message_body = "Hey ".$leads->sender_first_name.",\n\n".$flow->message;
                                
                                if($flow->type == 'text')
                                {
                                    if($leads->contact != null)
                                    {
                                        try{
                                            $client->messages->create(
                                                $leads->contact,
                                                array(
                                                    'from' => $companyInfo->phone_number,
                                                    'body' => $message_body
                                                )
                                            );
                                            
                                            $check_number = DB::table('lead_chat')->where('admin_id', $flow->user_id)->where('from',$leads->contact)->orwhere('to',$leads->contact)->first();
                                            
                                            $countChat = null;
                                            
                                            if($check_number != null)
                                            {
                                                $countChat = $check_number->chat_id;
                                            }
                                            else
                                            {
                                                $get_max_value = DB::table('lead_chat')->max('chat_id');
                                                $countChat = $get_max_value + 1;
                                            }
                                                                
                                            $send = [
                                            'admin_id' => $flow->user_id,
                                            'lead_id' => $leads->id,
                                            'from' => $companyInfo->phone_number,
                                            'to' => $leads->contact,
                                            'message' => $message_body,
                                            'internal' => 0,
                                            'chat_id' => $countChat,
                                            'seen' => 'workflow'
                                            ];
                                            
                                            $message_insert = DB::table('lead_chat')->insert($send);
                                        }
                                        catch (\Twilio\Exceptions\RestException $e) {
                                            DB::table('leads')->where('id',$leads->id)->update(['lead_status' => 'Wrong Number']);
                                        }
                                    }
                                    else
                                    {
                                        DB::table('leads')->where('id',$leads->id)->update(['lead_status' => 'Invalid Cell Number']);
                                    }
                                }
                                
                                if($flow->type == 'email')
                                {
                                    $data = [
                                        'first_name'=> $leads->sender_first_name,
                                        'company' => $companyInfo->name,
                                        'msg' => $message_body,
                                    ];
                                    
                                    Mail::send('email.workflow',$data, function($message) use ($leads,$companyInfo,$flow){
                                        $message->to($leads->email, $leads->sender_first_name." ".$leads->sender_last_name)
                                            ->subject($flow->subject);
                                        $message->from($companyInfo->suite,$companyInfo->name);
                                    });
                                    
                                    $get_max_value_email = DB::table('contact_email')->max('email_chat_id');
                                    $countEmailChat = $get_max_value_email + 1;
                                                        
                                    $sendEmail = [
                                    'from' => $companyInfo->suite,
                                    'to' => $leads->email,
                                    'subject' => $flow->type,
                                    'message' => $message_body,
                                    'type' => 'sent',
                                    'sender_id' => $flow->user_id,
                                    'email_chat_id' => $countEmailChat,
                                    'robo_text' => 'workflow'
                                    ];
                                    
                                    $message_insert = DB::table('contact_email')->insert($sendEmail);
                                }
                            }
                        }
                    }
                    else
                    {
                        $source = explode("|",$flow->source);
                        
                        foreach($source as $source)
                        {
                            $leads = DB::table('leads')->whereDate('created_at',$date)
                                                        ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                                        ->where('admin_email',$adminEmail->email)
                                                        ->where('lead_provider',$source)
                                                        ->get();
                     
                            if($leads->count() > 0){
                                foreach($leads as $leads)
                                {
                                    $message_body = "Hey ".$leads->sender_first_name.",\n\n".$flow->message;
                                    
                                    if($flow->type == 'text')
                                    {
                                        if($leads->contact != null)
                                        {
                                            try{
                                                $client->messages->create(
                                                    $leads->contact,
                                                    array(
                                                        'from' => $companyInfo->phone_number,
                                                        'body' => $message_body
                                                    )
                                                );
                                                
                                                $check_number = DB::table('lead_chat')->where('admin_id', $flow->user_id)->where('from',$leads->contact)->orwhere('to',$leads->contact)->first();
                                                
                                                $countChat = null;
                                                
                                                if($check_number != null)
                                                {
                                                    $countChat = $check_number->chat_id;
                                                }else{
                                                    $get_max_value = DB::table('lead_chat')->max('chat_id');
                                                    $countChat = $get_max_value + 1;
                                                }
                                                                    
                                                $send = [
                                                'admin_id' => $flow->user_id,
                                                'lead_id' => $leads->id,
                                                'from' => $companyInfo->phone_number,
                                                'to' => $leads->contact,
                                                'message' => $message_body,
                                                'internal' => 0,
                                                'chat_id' => $countChat,
                                                'seen' => 'workflow'
                                                ];
                                                
                                                $message_insert = DB::table('lead_chat')->insert($send);
                                            }
                                            catch (\Twilio\Exceptions\RestException $e) 
                                            {
                                                DB::table('leads')->where('id',$leads->id)->update(['lead_status' => 'Wrong Number']);
                                            }
                                        }
                                        else
                                        {
                                            DB::table('leads')->where('id',$leads->id)->update(['lead_status' => 'Invalid Cell Number']);
                                        }
                                    }
                                    
                                    if($flow->type == 'email')
                                    {
                                        $data = [
                                            'first_name'=> $leads->sender_first_name,
                                            'msg' => $message_body,
                                        ];
                                        
                                        Mail::send('email.workflow',$data, function($message) use ($leads,$companyInfo,$flow){
                                            $message->to($leads->email, $leads->sender_first_name." ".$leads->sender_last_name)
                                                ->subject($flow->subject);
                                            $message->from($companyInfo->suite,$companyInfo->name);
                                        });
                                        
                                        $get_max_value_email = DB::table('contact_email')->max('email_chat_id');
                                        $countEmailChat = $get_max_value_email + 1;
                                                            
                                        $sendEmail = [
                                        'from' => $companyInfo->suite,
                                        'to' => $leads->email,
                                        'subject' => $flow->subject,
                                        'message' => $message_body,
                                        'type' => 'sent',
                                        'sender_id' => $flow->user_id,
                                        'email_chat_id' => $countEmailChat,
                                        'robo_text' => 'workflow'
                                        ];
                                        
                                        $message_insert = DB::table('contact_email')->insert($sendEmail);
                                        
                                    }
                                }
                            }
                        }
                    }
                }
            }

        }

    }

    
}
