<?php

namespace App\Console;

use App\Http\Controllers\Backend\Blasts\EmailController;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        'App\Console\Commands\LeadBlastCron',
        'App\Console\Commands\MmsBlastCron',
        'App\Console\Commands\VoiceMailBlastCron',
        'App\Console\Commands\EmailBlastCron',
        'App\Console\Commands\LeadXmlCron',
        'App\Console\Commands\ReminderBlastCron',
        'App\Console\Commands\LeadBulkCron',
        'App\Console\Commands\TodayReportCron',
        'App\Console\Commands\WorkFlowCron',
        'App\Console\Commands\MaxBlastCron',
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
         $schedule->command('lead:blast')
                 ->everyFiveMinutes();
                 
         $schedule->command('mms:blast')
                 ->everyFiveMinutes();
                 
         $schedule->command('voicemail:blast')
                 ->everyFiveMinutes();
                 
         $schedule->command('email:blast')
                 ->everyFiveMinutes();
                 
         $schedule->command('lead:xml')
                 ->everyFiveMinutes();
                 
         $schedule->command('reminder:blast')
                 ->everyTenMinutes();
                 
         $schedule->command('lead:bulk')
                 ->everyFiveMinutes();
    
         $schedule->command('today:report')
                 ->hourly();
                 
         $schedule->command('work:flow')
                 ->hourly();
                 
         $schedule->command('max:blast')
                 ->everyTenMinutes();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
