<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\Companyinfo;
use App\User;
use App\Leadchat;
use App\Quickanswer;
use App\Leadpause;
use App\Leadcontact;
use App\Leadgeneralinfo;
use App\Leadinventoryinfo;
use App\LeadAppointment;
use App\Permissionallowed;
use App\Creditapplication;
use App\Leademail;
use App\Leadblast;
use App\Emailblast;
use App\Mmsblast;
use App\Voicemailblast;
use App\Blastpercentage;
use Illuminate\Support\Facades\Cache;


class KpisController extends BaseController{

    public function kpistodayview(){
    $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

    if($user->usertype_id == 2){

            // Today Start
        $today_total_sent = Leadchat::where('type','sent')->whereDate('created_at', date('Y-m-d'))->where('sender_id',$user->id)->count('*');

        $today_leads = Lead::whereDate('created_at', date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $today_leads_data = Lead::whereDate('created_at', date('Y-m-d'))->where('admin_email',$user->email)->get();

        $today_credit_applications = 0;
        if(count($today_leads_data) > 0){
            foreach($today_leads_data as $row){
                $lead_today_credit_applications = Creditapplication::whereDate('created_at', date('Y-m-d'))->where('lead_id',$row->id)->count('*');
                if(!empty($lead_today_credit_applications)){
                    $today_credit_applications =  $today_credit_applications + $lead_today_credit_applications;
                }
            }
        }


        $today_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('created_at', date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $today_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('created_at', date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $today_text_blast = Leadblast::where('type','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$user->id)->count('*');
        $today_email_blast = Emailblast::where('email_status','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$user->id)->count('*');
        $today_mms_blast = Mmsblast::where('type','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$user->id)->count('*');
        $today_voicemail_blast =  Voicemailblast::where('type','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$user->id)->count('*');

        // Today End
        $today_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_active_fresh =  Lead::where('admin_email',$user->email)->where('lead_status','Active-Fresh')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_blocked_harassment =  Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_blocked_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_wrong_number = Lead::where('admin_email',$user->email)->where('lead_status','Wrong Number')->whereDate('created_at', date('Y-m-d'))->count('*');

// Percentage of todays overview value and dealer status level 1

        $today_appointement_showed_p = "0";
        $today_appointment_set_p = "0";
        $today_active_fresh_p = "0";
        $today_active_co_byuer_p = "0";
        $today_active_contacted_p = "0";
        $today_block_harasment_p = "0";
        $today_block_inappropirate_p = "0";
        $today_wrong_number_p = "0";

        if($today_leads != 0) {
            $today_appointement_showed_p = number_format(($today_appointment_showed / $today_leads) * 100, 2);
            $today_appointment_set_p = number_format(($today_appointment_set / $today_leads) * 100, 2);
            $today_active_fresh_p = number_format( ($today_active_fresh/$today_leads) * 100, 2 );
            $today_active_contacted_p = number_format(($today_active_contacted / $today_leads) * 100, 2);
            $today_block_harasment_p = number_format( ($today_blocked_harassment/$today_leads) * 100, 2 );
            $today_block_inappropirate_p = number_format( ($today_blocked_inappropirate/$today_leads) * 100, 2 );
            $today_wrong_number_p =   number_format( ($today_wrong_number/$today_leads) * 100, 2 );

        }

        $percentageSMS = array();
        $percentageMMS = array();
        $percentageRM = array();
        $percentageEMAIL = array();
        $adminId = $user->id;

        $blast_percentage = Blastpercentage::whereNotNull('value')->where('value','!=','0')->where('user_id', $adminId)->whereDate('created_at','>=',date('Y-m-d'))->get(['blast_id','value','blast_type']);

        if($blast_percentage && $blast_percentage->count() > 0)
        {
            foreach($blast_percentage as $blast_percentage)
            {
                if($blast_percentage->blast_type == 'sms')
                {
                    $check_blast = Leadblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'mms')
                {
                    $check_blast = Mmsblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'email')
                {
                    $check_blast = Emailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'call')
                {
                    $check_blast = Voicemailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
                }
            }
        }


        $today_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
        $today_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
        $today_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
        $today_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';


// end of percenteage

        // today level 2 for usertype 2

        $today2_leads = Lead::whereDate('updated_at', date('Y-m-d'))->where('admin_email',$user->email)->count('*');

        $today2_active_co_buyer = Lead::where('admin_email',$user->email)->where('lead_status','Active-Co-Buyer')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_service = Lead::where('admin_email',$user->email)->where('lead_status','Active-Service')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_employement = Lead::where('admin_email',$user->email)->where('lead_status','Active-Employement')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_reminder_set = Lead::where('admin_email',$user->email)->where('lead_status','Active-Reminder-Set')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_sale = Lead::where('admin_email',$user->email)->where('lead_status','Active-Sale')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_appointment_cancel = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Cancel')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('updated_at', date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $today2_appointment_missed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Missed')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('updated_at', date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $today2_appoinment_state = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-State')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_blocked_harassment =  Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_blocked_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_dms_offer_replied = Lead::where('admin_email',$user->email)->where('lead_status','DMS-Offer-Replied')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_not_interested = Lead::where('admin_email',$user->email)->where('lead_status','Not Interested')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_sold_unknown = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Unknown')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_sold_used = Lead::where('admin_email',$user->email)->where('lead_status','sold-used')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_sold_new = Lead::where('admin_email',$user->email)->where('lead_status','Sold-New')->whereDate('updated_at', date('Y-m-d'))->count('*');


        // today level 2 end

        // today end



        $today_providers = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as c, lead_provider')
//            ->whereDate('created_at', date('Y-m-d'))
            ->where("admin_email",$user->email)
            ->groupBy('lead_provider')
            ->having('c','>=','1')
            ->orderby('c','desc')
            ->get();

        $today_custom_sources = array();

        foreach($today_providers as $week_providers)
        { //$startdate $enddate
            $week_provider_leads = Lead::where('admin_email',$user->email)
                ->where('lead_provider',$week_providers->lead_provider)
                ->whereDate('created_at',date('Y-m-d'))
                ->get();

            $week1 = $week_provider_leads;
            $week2 = $week_provider_leads;
            $week3 = $week_provider_leads;
            $week4 = $week_provider_leads;
            $week5 = $week_provider_leads;
            $week6 = $week_provider_leads;
            $week7 = $week_provider_leads;
            $week8 = $week_provider_leads;

            $today_custom_sources[] = ['week_provider' => $week_providers->lead_provider,
                'total-provider' => number_format($week1->count()),
                'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
                'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
                'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
                'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
                'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
                'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
                'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
            ];
        }


        $today2_appointement_showed_p = "0";
        $today2_appointment_set_p = "0";
        $today2_appointment_cancel_p = "0";
        $today2_appointment_missed_p = "0";
        $today2_active_co_byuer_p = "0";
        $today2_active_contacted_p = "0";
        $today2_active_service_p = "0";
        $today2_active_employement_p = "0";
        $today2_active_reminder_set_p = "0";
        $today2_active_sale_p = "0";
        $today2_dms_offer_replied_p = "0";
        $today2_sold_unknown_p = "0";
        $today2_sold_used_p = "0";
        $today2_sold_new_p = "0";
        $today2_appoinment_state_p = "0";
        $today2_blocked_harassment_p = "0";
        $today2_blocked_inappropirate_p = "0";
        $today2_not_interested_p = "0";


        if($today2_leads != 0)
        {
            $today2_appointement_showed_p = number_format( ($today2_appointment_showed/$today2_leads) * 100, 2 );
            $today2_appointment_set_p = number_format( ($today2_appointment_set/$today2_leads) * 100, 2 );
            $today2_appointment_cancel_p = number_format( ($today2_appointment_cancel/$today2_leads) * 100, 2 );
            $today2_appointment_missed_p = number_format( ($today2_appointment_missed/$today2_leads) * 100, 2 );
            $today2_active_co_byuer_p = number_format( ($today2_active_co_buyer/$today2_leads) * 100, 2 );
            $today2_active_contacted_p = number_format( ($today2_active_contacted/$today2_leads) * 100, 2 );
            $today2_active_service_p = number_format( ($today2_active_service/$today2_leads) * 100, 2 );
            $today2_active_employement_p = number_format( ($today2_active_employement/$today2_leads) * 100, 2 );
            $today2_active_reminder_set_p = number_format( ($today2_active_reminder_set/$today2_leads) * 100, 2 );
            $today2_active_sale_p = number_format( ($today2_active_sale/$today2_leads) * 100, 2 );
            $today2_dms_offer_replied_p = number_format( ($today2_dms_offer_replied/$today2_leads) * 100, 2 );
            $today2_sold_unknown_p = number_format( ($today2_sold_unknown/$today2_leads) * 100, 2 );
            $today2_sold_used_p = number_format( ($today2_sold_used/$today2_leads) * 100, 2 );
            $today2_sold_new_p = number_format( ($today2_sold_new/$today2_leads) * 100, 2 );
            $today2_appoinment_state_p = number_format( ($today2_appoinment_state/$today2_leads) * 100, 2 );
            $today2_blocked_harassment_p = number_format( ($today2_blocked_harassment/$today2_leads) * 100, 2 );
            $today2_blocked_inappropirate_p = number_format( ($today2_blocked_inappropirate/$today2_leads) * 100, 2 );
            $today2_not_interested_p = number_format( ($today2_not_interested/$today2_leads) * 100, 2 );


        }


//        week start

        $week_total_sent = Leadchat::where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('sender_id',$user->id)->count('*');

        $week_leads = Lead:: whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $week_leads_data = Lead::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->get();
        $week_credit_applications = 0;
        //  dd($week_leads_data,$week_leads);

        if(count($week_leads_data) > 0){
            foreach($week_leads_data as $row){

                $lead_week_credit_applications = Creditapplication::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('lead_id',$row->id)->count('*');

                if(!empty($lead_week_credit_applications)){

                    $week_credit_applications =  $week_credit_applications + $lead_week_credit_applications;
                }
            }
        }

        $week_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $week_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $week_text_blast = Leadblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
        $week_email_blast = Emailblast::where('email_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
        $week_mms_blast = Mmsblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
        $week_voicemail_blast =  Voicemailblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');

        // Weekly End
        $week_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_active_fresh = Lead::where('admin_email',$user->email)->where('lead_status','Active-Fresh')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_blocked_harassment = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_blocked_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_wrong_number = Lead::where('admin_email',$user->email)->where('lead_status','Wrong Number')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');


        $week_appointement_showed_p = "0";
        $week_appointment_set_p = "0";
        $week_active_fresh_p = "0";
        $week_active_contacted_p = "0";
        $week_block_harasment_p = "0";
        $week_block_inappropirate_p = "0";
        $week_wrong_number_p = "0";

        if($week_leads != 0) {
            $week_appointement_showed_p = number_format(($week_appointment_showed / $week_leads) * 100, 2);
            $week_appointment_set_p = number_format(($week_appointment_set / $week_leads) * 100, 2);
            $week_active_fresh_p = number_format( ($week_active_fresh/$week_leads) * 100, 2 );
            $week_active_contacted_p = number_format(($week_active_contacted / $week_leads) * 100, 2);
            $week_block_harasment_p = number_format( ($week_blocked_harassment/$week_leads) * 100, 2 );
            $week_block_inappropirate_p = number_format( ($week_blocked_inappropirate/$week_leads) * 100, 2 );
            $week_wrong_number_p =   number_format( ($week_wrong_number/$week_leads) * 100, 2 );

        }

        $percentageSMS = array();
        $percentageMMS = array();
        $percentageRM = array();
        $percentageEMAIL = array();
        $adminId = $user->id;

        $blast_percentage = Blastpercentage::whereNotNull('value')->where('value','!=','0')->where('user_id', $adminId)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->get(['blast_id','value','blast_type']);

        if($blast_percentage && $blast_percentage->count() > 0)
        {
            foreach($blast_percentage as $blast_percentage)
            {
                if($blast_percentage->blast_type == 'sms')
                {
                    $check_blast = Leadblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'mms')
                {
                    $check_blast = Mmsblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'email')
                {
                    $check_blast = Emailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'call')
                {
                    $check_blast = Voicemailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
                }
            }
        }


        $week_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
        $week_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
        $week_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
        $week_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';




        // week level 2 for usertype
        $week2_leads = Lead::whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');

        $week2_active_co_buyer = Lead::where('admin_email',$user->email)->where('lead_status','Active-Co-Buyer')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_service = Lead::where('admin_email',$user->email)->where('lead_status','Active-Service')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_employement = Lead::where('admin_email',$user->email)->where('lead_status','Active-Employement')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_reminder_set = Lead::where('admin_email',$user->email)->where('lead_status','Active-Reminder-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_sale = Lead::where('admin_email',$user->email)->where('lead_status','Active-Sale')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_appointment_cancel = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Cancel')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $week2_appointment_missed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Missed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $week2_appointment_state = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-State')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_blocked_harassment = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_blocked_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_dms_offer_replied = Lead::where('admin_email',$user->email)->where('lead_status','DMS-Offer-Replied')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_not_interested = Lead::where('admin_email',$user->email)->where('lead_status','Not Interested')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_sold_unknown = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Unknown')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_sold_used = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Used')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_sold_new = Lead::where('admin_email',$user->email)->where('lead_status','Sold-New')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        // week End

        $week_providers = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as c, lead_provider')
//            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
//            ->whereDate('created_at','<=',date('Y-m-d'))
            ->where("admin_email",$user->email)
            ->groupBy('lead_provider')
            ->having('c','>=','1')
            ->orderby('c','desc')
            ->get();


        $week_custom_sources = array();

        foreach($week_providers as $week_providers)
        { //$startdate $enddate
            $week_provider_leads = Lead::where('admin_email',$user->email)
                ->where('lead_provider',$week_providers->lead_provider)
                ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                ->whereDate('created_at','<=',date('Y-m-d'))->get();

            $week1 = $week_provider_leads;
            $week2 = $week_provider_leads;
            $week3 = $week_provider_leads;
            $week4 = $week_provider_leads;
            $week5 = $week_provider_leads;
            $week6 = $week_provider_leads;
            $week7 = $week_provider_leads;
            $week8 = $week_provider_leads;

            $week_custom_sources[] = ['week_provider' => $week_providers->lead_provider,
                'total-provider' => number_format($week1->count()),
                'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
                'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
                'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
                'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
                'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
                'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
                'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
            ];
        }
        $week2_appointement_showed_p = "0";
        $week2_appointment_set_p = "0";
        $week2_appointment_cancel_p = "0";
        $week2_appointment_missed_p = "0";
        $week2_active_co_byuer_p = "0";
        $week2_active_contacted_p = "0";
        $week2_active_service_p = "0";
        $week2_active_employement_p = "0";
        $week2_active_reminder_set_p = "0";
        $week2_active_sale_p = "0";
        $week2_dms_offer_replied_p = "0";
        $week2_blocked_harassment_p = "0";
        $week2_blocked_inappropirate_p = "0";
        $week2_sold_unknown_p = "0";
        $week2_sold_used_p = "0";
        $week2_sold_new_p = "0";
        $week2_appointment_state_p = "0";
        $week2_not_interested_p = "0";


        if($week2_leads != 0)
        {
            $week2_appointement_showed_p = number_format( ($week2_appointment_showed/$week2_leads) * 100, 2 );
            $week2_appointment_set_p = number_format( ($week2_appointment_set/$week2_leads) * 100, 2 );
            $week2_appointment_cancel_p = number_format( ($week2_appointment_cancel/$week2_leads) * 100, 2 );
            $week2_appointment_missed_p = number_format( ($week2_appointment_missed/$week2_leads) * 100, 2 );
            $week2_active_co_byuer_p = number_format( ($week2_active_co_buyer/$week2_leads) * 100, 2 );
            $week2_active_contacted_p = number_format( ($week2_active_contacted/$week2_leads) * 100, 2 );
            $week2_active_service_p = number_format( ($week2_active_service/$week2_leads) * 100, 2 );
            $week2_active_employement_p = number_format( ($week2_active_employement/$week2_leads) * 100, 2 );
            $week2_active_reminder_set_p = number_format( ($week2_active_reminder_set/$week2_leads) * 100, 2 );
            $week2_active_sale_p = number_format( ($week2_active_sale/$week2_leads) * 100, 2 );
            $week2_blocked_harassment_p = number_format( ($week2_blocked_harassment/$week2_leads) * 100, 2 );
            $week2_blocked_inappropirate_p = number_format( ($week2_blocked_inappropirate/$week2_leads) * 100, 2 );
            $week2_dms_offer_replied_p = number_format( ($week2_dms_offer_replied/$week2_leads) * 100, 2 );
            $week2_sold_unknown_p = number_format( ($week2_sold_unknown/$week2_leads) * 100, 2 );
            $week2_sold_used_p = number_format( ($week2_sold_used/$week2_leads) * 100, 2 );
            $week2_sold_new_p = number_format( ($week2_sold_new/$week2_leads) * 100, 2 );
            $week2_appointment_state_p = number_format( ($week2_appointment_state/$week2_leads) * 100, 2 );
            $week2_not_interested_p =  number_format( ($week2_not_interested/$week2_leads) * 100, 2 );

        }

    }

    elseif($user->usertype_id == 4){

        
        $getUser =  User::where('id',$user->id)->first(['parent_user_id']);
        $getAdmin =  User::where('id',$getUser->parent_user_id)->first(['id','email']);

        $assigned_column = "admin_email";

        $check_permission = Permissionallowed::where('user_id', $getAdmin->id)->first(['lead_structure']);

        if($check_permission != null)
        {
            if($check_permission->lead_structure == 'assigned')
            {
                $assigned_column = "assigned_user_id";
                $assigned_agents = $user->id;
                $assigned_sender_agent = $user->id;
            }
            else
            {
                $assigned_column = "admin_email";
                $assigned_agents =  $getAdmin->email;
                $assigned_sender_agent = $getAdmin->id;
            }
        }
        else{
            $assigned_column = "admin_email";
            $assigned_agents =  $getAdmin->email;
            $assigned_sender_agent = $getAdmin->id;
        }

        // Today Start
        $today_total_sent = Leadchat::where('type','sent')->whereDate('created_at', date('Y-m-d'))->where('sender_id',$assigned_sender_agent)->count('*');

        $today_leads = Lead::whereDate('created_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $today_leads_data = Lead::whereDate('created_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->get();
        $today_credit_applications = 0;
        if(count($today_leads_data) > 0){
            foreach($today_leads_data as $row){
                $lead_today_credit_applications = Creditapplication::whereDate('created_at', date('Y-m-d'))->where('lead_id',$row->id)->count('*');
                if(!empty($lead_today_credit_applications)){
                    $today_credit_applications =  $today_credit_applications + $lead_today_credit_applications;
                }
            }
        }


        $today_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('created_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $today_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('created_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $today_text_blast = Leadblast::where('message_status','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
        $today_email_blast = Emailblast::where('email_status','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
        $today_mms_blast = Mmsblast::where('message_status','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
        $today_voicemail_blast =  Voicemailblast::where('message_status','Sent')->whereDate('created_at', date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');

        // Today End
        $today_active_contacted = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Contacted')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_active_fresh =  Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Fresh')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_blocked_harassment =  Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Harassment')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_blocked_inappropirate = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Inappropirate')->whereDate('created_at', date('Y-m-d'))->count('*');
        $today_wrong_number = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Wrong Number')->whereDate('created_at', date('Y-m-d'))->count('*');

        // today level 2 for usertype 2


        // Percentage of todays overview value and dealer status level 1

        $today_appointement_showed_p = "0";
        $today_appointment_set_p = "0";
        $today_active_fresh_p = "0";
        $today_active_co_byuer_p = "0";
        $today_active_contacted_p = "0";
        $today_block_harasment_p = "0";
        $today_block_inappropirate_p = "0";
        $today_wrong_number_p = "0";

        if($today_leads != 0) {
            $today_appointement_showed_p = number_format(($today_appointment_showed / $today_leads) * 100, 2);
            $today_appointment_set_p = number_format(($today_appointment_set / $today_leads) * 100, 2);
            $today_active_fresh_p = number_format( ($today_active_fresh/$today_leads) * 100, 2 );
            $today_active_contacted_p = number_format(($today_active_contacted / $today_leads) * 100, 2);
            $today_block_harasment_p = number_format( ($today_blocked_harassment/$today_leads) * 100, 2 );
            $today_block_inappropirate_p = number_format( ($today_blocked_inappropirate/$today_leads) * 100, 2 );
            $today_wrong_number_p =   number_format( ($today_wrong_number/$today_leads) * 100, 2 );

        }

        $percentageSMS = array();
        $percentageMMS = array();
        $percentageRM = array();
        $percentageEMAIL = array();
        $adminId = $user->id;

        $blast_percentage = Blastpercentage::whereNotNull('value')->where('value','!=','0')->where('user_id', $adminId)->whereDate('created_at','>=',date('Y-m-d'))->get(['blast_id','value','blast_type']);

        if($blast_percentage && $blast_percentage->count() > 0)
        {
            foreach($blast_percentage as $blast_percentage)
            {
                if($blast_percentage->blast_type == 'sms')
                {
                    $check_blast = Leadblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'mms')
                {
                    $check_blast = Mmsblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'email')
                {
                    $check_blast = Emailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'call')
                {
                    $check_blast = Voicemailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
                }
            }
        }


        $today_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
        $today_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
        $today_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
        $today_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';


// end of percenteage





        $today2_leads = Lead::whereDate('updated_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');

        $today2_active_co_buyer = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Co-Buyer')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_contacted = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Contacted')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_service = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Service')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_employement = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Employement')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_reminder_set = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Reminder-Set')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_active_sale = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Sale')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_appointment_cancel = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-Cancel')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('updated_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $today2_appointment_missed = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-Missed')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('updated_at', date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $today2_appoinment_state = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-State')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_blocked_harassment =  Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Harassment')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_blocked_inappropirate = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Inappropirate')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_dms_offer_replied = Lead::where($assigned_column,$assigned_agents)->where('lead_status','DMS-Offer-Replied')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_not_interested = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Not Interested')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_sold_unknown = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-Unknown')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_sold_used = Lead::where($assigned_column,$assigned_agents)->where('lead_status','sold-used')->whereDate('updated_at', date('Y-m-d'))->count('*');
        $today2_sold_new = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-New')->whereDate('updated_at', date('Y-m-d'))->count('*');



        $today_providers =Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as c, lead_provider')
            ->whereDate('created_at', date('Y-m-d'))
            ->where("admin_email",$getAdmin->email)
            ->groupBy('lead_provider')
            ->having('c','>=','1')
            ->orderby('c','desc')
            ->get();


        $today_custom_sources = array();

        foreach($today_providers as $week_providers)
        { //$startdate $enddate
            $week_provider_leads = Lead::where('admin_email',$getAdmin->email)
                ->where('lead_provider',$week_providers->lead_provider)
                ->whereDate('created_at',date('Y-m-d'))
                ->get();

            $week1 = $week_provider_leads;
            $week2 = $week_provider_leads;
            $week3 = $week_provider_leads;
            $week4 = $week_provider_leads;
            $week5 = $week_provider_leads;
            $week6 = $week_provider_leads;
            $week7 = $week_provider_leads;
            $week8 = $week_provider_leads;

            $today_custom_sources[] = ['week_provider' => $week_providers->lead_provider,
                'total-provider' => number_format($week1->count()),
                'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
                'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
                'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
                'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
                'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
                'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
                'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
            ];
        }


        $today2_appointement_showed_p = "0";
        $today2_appointment_set_p = "0";
        $today2_appointment_cancel_p = "0";
        $today2_appointment_missed_p = "0";
        $today2_appoinment_state_p = "0";
        $today2_active_co_byuer_p = "0";
        $today2_active_contacted_p = "0";
        $today2_active_service_p = "0";
        $today2_active_employement_p = "0";
        $today2_active_reminder_set_p = "0";
        $today2_active_sale_p = "0";
        $today2_dms_offer_replied_p = "0";
        $today2_sold_unknown_p = "0";
        $today2_sold_used_p = "0";
        $today2_sold_new_p = "0";
        $today2_blocked_harassment_p = "0";
        $today2_blocked_inappropirate_p = "0";
        $today2_not_interested_p = "0";


        if($today2_leads != 0)
        {
            $today2_appointement_showed_p = number_format( ($today2_appointment_showed/$today2_leads) * 100, 2 );
            $today2_appointment_set_p = number_format( ($today2_appointment_set/$today2_leads) * 100, 2 );
            $today2_appointment_cancel_p = number_format( ($today2_appointment_cancel/$today2_leads) * 100, 2 );
            $today2_appointment_missed_p = number_format( ($today2_appointment_missed/$today2_leads) * 100, 2 );
            $today2_active_co_byuer_p = number_format( ($today2_active_co_buyer/$today2_leads) * 100, 2 );
            $today2_active_contacted_p = number_format( ($today2_active_contacted/$today2_leads) * 100, 2 );
            $today2_active_service_p = number_format( ($today2_active_service/$today2_leads) * 100, 2 );
            $today2_active_employement_p = number_format( ($today2_active_employement/$today2_leads) * 100, 2 );
            $today2_active_reminder_set_p = number_format( ($today2_active_reminder_set/$today2_leads) * 100, 2 );
            $today2_active_sale_p = number_format( ($today2_active_sale/$today2_leads) * 100, 2 );
            $today2_dms_offer_replied_p = number_format( ($today2_dms_offer_replied/$today2_leads) * 100, 2 );
            $today2_sold_unknown_p = number_format( ($today2_sold_unknown/$today2_leads) * 100, 2 );
            $today2_sold_used_p = number_format( ($today2_sold_used/$today2_leads) * 100, 2 );
            $today2_sold_new_p = number_format( ($today2_sold_new/$today2_leads) * 100, 2 );
            $today2_blocked_harassment_p = number_format( ($today_blocked_harassment/$today2_leads) * 100, 2 );
            $today2_appoinment_state_p = number_format( ($today2_appoinment_state_p/$today2_leads) * 100, 2 );
            $today2_blocked_inappropirate_p = number_format( ($today2_blocked_inappropirate/$today2_leads) * 100, 2 );
            $today2_not_interested_p = number_format( ($today2_not_interested/$today2_leads) * 100, 2 );

//            dd(gettype($today2_active_co_byuer_p));

        }
//        dd(gettype($today2_active_co_byuer_p));
        // today level 2 end

        // today end

        $week_total_sent = Leadchat::where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('sender_id',$assigned_sender_agent)->count('*');

        $week_leads = Lead::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $week_leads_data = Lead::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->get();
        $week_credit_applications = 0;
        //  dd($week_leads_data,$week_leads);

        if(count($week_leads_data) > 0){
            foreach($week_leads_data as $row){

                $lead_week_credit_applications = Creditapplication::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('lead_id',$row->id)->count('*');

                if(!empty($lead_week_credit_applications)){

                    $week_credit_applications =  $week_credit_applications + $lead_week_credit_applications;
                }
            }
        }

        $week_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $week_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $week_text_blast = Leadblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
        $week_email_blast = Emailblast::where('email_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
        $week_mms_blast = Mmsblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
        $week_voicemail_blast =  Voicemailblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');

        // Weekly End
        $week_active_contacted = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Contacted')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_active_fresh = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Fresh')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_blocked_harassment = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Harassment')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_blocked_inappropirate = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Inappropirate')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
        $week_wrong_number = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Wrong Number')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');


        $week_appointement_showed_p = "0";
        $week_appointment_set_p = "0";
        $week_active_fresh_p = "0";
        $week_active_contacted_p = "0";
        $week_block_harasment_p = "0";
        $week_block_inappropirate_p = "0";
        $week_wrong_number_p = "0";

        if($week_leads != 0) {
            $week_appointement_showed_p = number_format(($week_appointment_showed / $week_leads) * 100, 2);
            $week_appointment_set_p = number_format(($week_appointment_set / $week_leads) * 100, 2);
            $week_active_fresh_p = number_format( ($week_active_fresh/$week_leads) * 100, 2 );
            $week_active_contacted_p = number_format(($week_active_contacted / $week_leads) * 100, 2);
            $week_block_harasment_p = number_format( ($week_blocked_harassment/$week_leads) * 100, 2 );
            $week_block_inappropirate_p = number_format( ($week_blocked_inappropirate/$week_leads) * 100, 2 );
            $week_wrong_number_p =   number_format( ($week_wrong_number/$week_leads) * 100, 2 );

        }

        $percentageSMS = array();
        $percentageMMS = array();
        $percentageRM = array();
        $percentageEMAIL = array();
        $adminId = $user->id;

        $blast_percentage = Blastpercentage::whereNotNull('value')->where('value','!=','0')->where('user_id', $adminId)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->get(['blast_id','value','blast_type']);

        if($blast_percentage && $blast_percentage->count() > 0)
        {
            foreach($blast_percentage as $blast_percentage)
            {
                if($blast_percentage->blast_type == 'sms')
                {
                    $check_blast = Leadblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'mms')
                {
                    $check_blast = Mmsblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'email')
                {
                    $check_blast = Emailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'call')
                {
                    $check_blast = Voicemailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
                }
            }
        }


        $week_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
        $week_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
        $week_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
        $week_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';



        // week level 2 for usertype
        $week2_leads = Lead::whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');

        $week2_active_co_buyer = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Co-Buyer')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_contacted = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Contacted')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_service = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Service')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_employement = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Employement')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_reminder_set = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Reminder-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_active_sale = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Sale')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_appointment_cancel = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-Cancel')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
        $week2_appointment_missed = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-Missed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
        $week2_appointment_state = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-State')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_blocked_harassment = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Harassment')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_blocked_inappropirate = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Inappropirate')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_dms_offer_replied = Lead::where($assigned_column,$assigned_agents)->where('lead_status','DMS-Offer-Replied')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_not_interested = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Not Interested')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_sold_unknown = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-Unknown')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_sold_used = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-Used')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        $week2_sold_new = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-New')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
        // week End




        $week_providers = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as c, lead_provider')
            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
            ->whereDate('created_at','<=',date('Y-m-d'))
            ->where("admin_email",$getAdmin->email)
            ->groupBy('lead_provider')
            ->having('c','>=','1')
            ->orderby('c','desc')
            ->get();

        $week_custom_sources = array();

        foreach($week_providers as $week_providers)
        { //$startdate $enddate
            $week_provider_leads = Lead::where('admin_email',$getAdmin->email)
                ->where('lead_provider',$week_providers->lead_provider)
                ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                ->whereDate('created_at','<=',date('Y-m-d'))->get();

            $week1 = $week_provider_leads;
            $week2 = $week_provider_leads;
            $week3 = $week_provider_leads;
            $week4 = $week_provider_leads;
            $week5 = $week_provider_leads;
            $week6 = $week_provider_leads;
            $week7 = $week_provider_leads;
            $week8 = $week_provider_leads;

            $week_custom_sources[] = ['week_provider' => $week_providers->lead_provider,
                'total-provider' => number_format($week1->count()),
                'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
                'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
                'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
                'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
                'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
                'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
                'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
            ];
        }

        $week2_appointement_showed_p = "0";
        $week2_appointment_set_p = "0";
        $week2_appointment_cancel_p = "0";
        $week2_appointment_missed_p = "0";
        $week2_active_co_byuer_p = "0";
        $week2_active_contacted_p = "0";
        $week2_active_service_p = "0";
        $week2_active_employement_p = "0";
        $week2_active_reminder_set_p = "0";
        $week2_active_sale_p = "0";
        $week2_dms_offer_replied_p = "0";
        $week2_blocked_harassment_p = "0";
        $week2_blocked_inappropirate_p = "0";
        $week2_sold_unknown_p = "0";
        $week2_sold_used_p = "0";
        $week2_sold_new_p = "0";
        $week2_appointment_state_p = "0";
        $week2_not_interested_p = "0";


        if($week2_leads != 0)
        {
            $week2_appointement_showed_p = number_format( ($week2_appointment_showed/$week2_leads) * 100, 2 );
            $week2_appointment_set_p = number_format( ($week2_appointment_set/$week2_leads) * 100, 2 );
            $week2_appointment_cancel_p = number_format( ($week2_appointment_cancel/$week2_leads) * 100, 2 );
            $week2_appointment_missed_p = number_format( ($week2_appointment_missed/$week2_leads) * 100, 2 );
            $week2_active_co_byuer_p = number_format( ($week2_active_co_buyer/$week2_leads) * 100, 2 );
            $week2_active_contacted_p = number_format( ($week2_active_contacted/$week2_leads) * 100, 2 );
            $week2_active_service_p = number_format( ($week2_active_service/$week2_leads) * 100, 2 );
            $week2_active_employement_p = number_format( ($week2_active_employement/$week2_leads) * 100, 2 );
            $week2_active_reminder_set_p = number_format( ($week2_active_reminder_set/$week2_leads) * 100, 2 );
            $week2_active_sale_p = number_format( ($week2_active_sale/$week2_leads) * 100, 2 );
            $week2_blocked_harassment_p = number_format( ($week2_blocked_harassment/$week2_leads) * 100, 2 );
            $week2_blocked_inappropirate_p = number_format( ($week2_blocked_inappropirate/$week2_leads) * 100, 2 );
            $week2_dms_offer_replied_p = number_format( ($week2_dms_offer_replied/$week2_leads) * 100, 2 );
            $week2_sold_unknown_p = number_format( ($week2_sold_unknown/$week2_leads) * 100, 2 );
            $week2_sold_used_p = number_format( ($week2_sold_used/$week2_leads) * 100, 2 );
            $week2_sold_new_p = number_format( ($week2_sold_new/$week2_leads) * 100, 2 );
            $week2_appointment_state_p = number_format( ($week2_appointment_state/$week2_leads) * 100, 2 );
            $week2_not_interested_p = number_format( ($week2_not_interested/$week2_leads) * 100, 2 );

        }



    }
        $todaydata = [
            // Today Start
            'today_leads' => $today_leads,
            'today_credit_applications' => $today_credit_applications,
            'today_appointment_set' => $today_appointment_set,
            'today_appointment_set_p' => $today_appointment_set_p,
            'today_appointment_showed' => $today_appointment_showed,
            'today_appointement_showed_p' => $today_appointement_showed_p,
            'today_text_blast' => $today_text_blast,
            'today_text_blast_p' => $today_text_blast_p,
            'today_email_blast' => $today_email_blast,
            'today_email_blast_p' => $today_email_blast_p,
            'today_mms_blast' => $today_mms_blast,
            'today_mms_blast_p' => $today_mms_blast_p,
            'today_voicemail_blast' => $today_voicemail_blast,
            'today_voicemail_blast_p' => $today_voicemail_blast_p,
            // dealer_status_box
            'today_active_contacted' => $today_active_contacted,
            'today_active_contacted_p' => $today_active_contacted_p,
            'today_active_fresh' => $today_active_fresh,
            'today_active_fresh_p' => $today_active_fresh_p,
            'today_blocked_harassment' => $today_blocked_harassment,
            'today_block_harasment_p' => $today_block_harasment_p,
            'today_blocked_inappropirate' => $today_blocked_inappropirate,
            'today_block_inappropirate_p' => $today_block_inappropirate_p,
            'today_wrong_number' => $today_wrong_number,
            'today_wrong_number_p' => $today_wrong_number_p,

            // level 2
            'today2_leads' => $today2_leads,
            'today2_active_co_buyer' => $today2_active_co_buyer,
            'today2_active_co_byuer_p' => $today2_active_co_byuer_p,
            'today2_active_contacted' => $today2_active_contacted,
            'today2_active_contacted_p' => $today2_active_contacted_p,
            'today2_active_service' => $today2_active_service,
            'today2_active_service_p' => $today2_active_service_p,
            'today2_active_employement' => $today2_active_employement,
            'today2_active_employement_p' => $today2_active_employement_p,
            'today2_active_reminder_set' => $today2_active_reminder_set,
            'today2_active_reminder_set_p' => $today2_active_reminder_set_p,
            'today2_active_sale' => $today2_active_sale,
            'today2_active_sale_p' => $today2_active_sale_p,
            'today2_appointment_cancel' => $today2_appointment_cancel,
            'today2_appointment_cancel_p' => $today2_appointment_cancel_p,
            'today2_appointment_missed' => $today2_appointment_missed,
            'today2_appointment_missed_p' => $today2_appointment_missed_p,
            'today2_appoinment_state' => $today2_appoinment_state,
            'today2_appoinment_state_p' => $today2_appoinment_state_p,
            'today2_blocked_harassment' => $today2_blocked_harassment,
            'today2_blocked_harassment_p' => $today2_blocked_harassment_p,
            'today2_blocked_inappropirate' => $today2_blocked_inappropirate,
            'today2_blocked_inappropirate_p' => $today2_blocked_inappropirate_p,
            'today2_dms_offer_replied' => $today2_dms_offer_replied,
            'today2_dms_offer_replied_p' => $today2_dms_offer_replied_p,
            'today2_not_interested' => $today2_not_interested,
            'today2_not_interested_p' => $today2_not_interested_p,
            'today2_sold_unknown' => $today2_sold_unknown,
            'today2_sold_unknown_p' => $today2_sold_unknown_p,
            'today2_sold_used' => $today2_sold_used,
            'today2_sold_used_p' => $today2_sold_used_p,
            'today2_sold_new' => $today2_sold_new,
            'today2_sold_new_p' => $today2_sold_new_p,
            'today2_appointment_set' => $today2_appointment_set,
            'today2_appointment_set_p' => $today2_appointment_set_p,
            'today2_appointment_showed' => $today2_appointment_showed,
            'today2_appointement_showed_p' => $today2_appointement_showed_p,
        ];
        $weekdata = [
            'week_leads' => $week_leads,
            'week_credit_applications' => $week_credit_applications,
            'week_appointment_set' => $week_appointment_set,
            'week_appointment_set_p' => $week_appointment_set_p,
            'week_appointment_showed' => $week_appointment_showed,
            'week_appointement_showed_p' => $week_appointement_showed_p,
            'week_text_blast' => $week_text_blast,
            'week_text_blast_p' => $week_text_blast_p,
            'week_email_blast' => $week_email_blast,
            'week_email_blast_p' => $week_email_blast_p,
            'week_mms_blast' => $week_mms_blast,
            'week_mms_blast_p' => $week_mms_blast_p,
            'week_voicemail_blast' => $week_voicemail_blast,
            'week_voicemail_blast_p' => $week_voicemail_blast_p,
            // dealer_status_box
            'week_active_contacted' => $week_active_contacted,
            'week_active_contacted_p' => $week_active_contacted_p,
            'week_active_fresh' => $week_active_fresh,
            'week_active_fresh_p' => $week_active_fresh_p,
            'week_blocked_harassment'  => $week_blocked_harassment,
            'week_block_harasment_p' => $week_block_harasment_p,
            'week_blocked_inappropirate' => $week_blocked_inappropirate,
            'week_block_inappropirate_p' => $week_block_inappropirate_p,
            'week_wrong_number' => $week_wrong_number,
            'week_wrong_number_p' => $week_wrong_number_p,

            // level 2
            'week2_leads' => $week2_leads,
            'week2_active_co_buyer' => $week2_active_co_buyer,
            'week2_active_co_byuer_p ' => $week2_active_co_byuer_p,
            'week2_active_contacted' => $week2_active_contacted,
            'week2_active_contacted_p' => $week2_active_contacted_p,
            'week2_active_service' => $week2_active_service,
            'week2_active_service_p' => $week2_active_service_p,
            'week2_active_employement' => $week2_active_employement,
            'week2_active_employement_p' => $week2_active_employement_p,
            'week2_active_reminder_set' => $week2_active_reminder_set,
            'week2_active_reminder_set_p' => $week2_active_reminder_set_p,
            'week2_active_sale' => $week2_active_sale,
            'week2_active_sale_p' => $week2_active_sale_p,
            'week2_appointment_cancel' => $week2_appointment_cancel,
            'week2_appointment_cancel_p' => $week2_appointment_cancel_p,
            'week2_appointment_missed' => $week2_appointment_missed,
            'week2_appointment_missed_p' => $week2_appointment_missed_p,
            'week2_appointment_state'  => $week2_appointment_state,
            'week2_appointment_state_P' => $week2_appointment_state_p,
            'week2_blocked_harassment' => $week2_blocked_harassment,
            'week2_blocked_harassment_p' => $week2_blocked_harassment_p,
            'week2_blocked_inappropirate' => $week2_blocked_inappropirate,
            'week2_blocked_inappropirate_p' => $week2_blocked_inappropirate_p,
            'week2_dms_offer_replied' => $week2_dms_offer_replied,
            'week2_dms_offer_replied_p' => $week2_dms_offer_replied_p,
            'week2_not_interested' => $week2_not_interested,
            'week2_not_interested_P' => $week2_not_interested_p,
            'week2_sold_unknown'  => $week2_sold_unknown,
            'week2_sold_unknown_p' => $week2_sold_unknown_p,
            'week2_sold_used' => $week2_sold_used,
            'week2_sold_used_p' => $week2_sold_used_p,
            'week2_sold_new' => $week2_sold_new,
            'week2_sold_new_p' => $week2_sold_new_p,
            'week2_appointment_set' => $week2_appointment_set,
            'week2_appointment_set_p' => $week2_appointment_set_p,
            'week2_appointment_showed' => $week2_appointment_showed,
            'week2_appointement_showed_p' => $week2_appointement_showed_p,
            // Week End
        ];
        return $this->sendResponse([
            'today_report' => $todaydata,
            'today_providers' => $today_custom_sources,
            'week_report' => $weekdata,
            'week_provider' => $week_custom_sources,
        ],'kpi_report');
    }

//    public function kpisweekview() {
//        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
//        if($user->usertype_id == 2){
//
//        $week_total_sent = Leadchat::where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('sender_id',$user->id)->count('*');
//
//        $week_leads = Lead:: whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//        $week_leads_data = Lead::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->get();
//        $week_credit_applications = 0;
//        //  dd($week_leads_data,$week_leads);
//
//        if(count($week_leads_data) > 0){
//            foreach($week_leads_data as $row){
//
//                $lead_week_credit_applications = Creditapplication::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('lead_id',$row->id)->count('*');
//
//                if(!empty($lead_week_credit_applications)){
//
//                    $week_credit_applications =  $week_credit_applications + $lead_week_credit_applications;
//                }
//            }
//        }
//
//        $week_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//        $week_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//        $week_text_blast = Leadblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
//        $week_email_blast = Emailblast::where('email_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
//        $week_mms_blast = Mmsblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
//        $week_voicemail_blast =  Voicemailblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$user->id)->count('*');
//
//        // Weekly End
//        $week_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//        $week_active_fresh = Lead::where('admin_email',$user->email)->where('lead_status','Active-Fresh')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//        $week_blocked_harassment = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//        $week_blocked_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//        $week_wrong_number = Lead::where('admin_email',$user->email)->where('lead_status','Wrong Number')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//
//
//        $week_appointement_showed_p = 0;
//        $week_appointment_set_p = 0;
//        $week_active_fresh_p = 0;
//        $week_active_contacted_p = 0;
//        $week_block_harasment_p = 0;
//        $week_block_inappropirate_p = 0;
//        $week_wrong_number_p = 0;
//
//        if($week_leads != 0) {
//            $week_appointement_showed_p = number_format(($week_appointment_showed / $week_leads) * 100, 2);
//            $week_appointment_set_p = number_format(($week_appointment_set / $week_leads) * 100, 2);
//            $week_active_fresh_p = number_format( ($week_active_fresh/$week_leads) * 100, 2 );
//            $week_active_contacted_p = number_format(($week_active_contacted / $week_leads) * 100, 2);
//            $week_block_harasment_p = number_format( ($week_blocked_harassment/$week_leads) * 100, 2 );
//            $week_block_inappropirate_p = number_format( ($week_blocked_inappropirate/$week_leads) * 100, 2 );
//            $week_wrong_number_p =   number_format( ($week_wrong_number/$week_leads) * 100, 2 );
//
//        }
//
//            $percentageSMS = array();
//            $percentageMMS = array();
//            $percentageRM = array();
//            $percentageEMAIL = array();
//            $adminId = $user->id;
//
//            $blast_percentage = Blastpercentage::whereNotNull('value')->where('value','!=','0')->where('user_id', $adminId)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->get(['blast_id','value','blast_type']);
//
//            if($blast_percentage && $blast_percentage->count() > 0)
//            {
//                foreach($blast_percentage as $blast_percentage)
//                {
//                    if($blast_percentage->blast_type == 'sms')
//                    {
//                        $check_blast = Leadblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//
//                    if($blast_percentage->blast_type == 'mms')
//                    {
//                        $check_blast = Mmsblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//
//                    if($blast_percentage->blast_type == 'email')
//                    {
//                        $check_blast = Emailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//
//                    if($blast_percentage->blast_type == 'call')
//                    {
//                        $check_blast = Voicemailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//                }
//            }
//
//
//            $week_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
//            $week_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
//            $week_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
//            $week_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';
//
//
//
//
//            // week level 2 for usertype
//        $week2_leads = Lead::whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//
//        $week2_active_co_buyer = Lead::where('admin_email',$user->email)->where('lead_status','Active-Co-Buyer')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_active_service = Lead::where('admin_email',$user->email)->where('lead_status','Active-Service')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_active_employement = Lead::where('admin_email',$user->email)->where('lead_status','Active-Employement')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_active_reminder_set = Lead::where('admin_email',$user->email)->where('lead_status','Active-Reminder-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_active_sale = Lead::where('admin_email',$user->email)->where('lead_status','Active-Sale')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_appointment_cancel = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Cancel')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//        $week2_appointment_missed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Missed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//        $week2_appointment_state = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-State')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_blocked_harassment = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_blocked_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_dms_offer_replied = Lead::where('admin_email',$user->email)->where('lead_status','DMS-Offer-Replied')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_not_interested = Lead::where('admin_email',$user->email)->where('lead_status','Not Interested')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_sold_unknown = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Unknown')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_sold_used = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Used')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        $week2_sold_new = Lead::where('admin_email',$user->email)->where('lead_status','Sold-New')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//        // week End
//
//        $week_providers = Lead::select('leads.lead_provider')
//            ->selectRaw('count(*) as c, lead_provider')
//            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
//            ->whereDate('created_at','<=',date('Y-m-d'))
//            ->where("admin_email",$user->email)
//            ->groupBy('lead_provider')
//            ->having('c','>=','1')
//            ->orderby('c','desc')
//            ->get();
//
//
//            $custom_sources = array();
//
//            foreach($week_providers as $week_providers)
//            { //$startdate $enddate
//                $week_provider_leads = Lead::where('admin_email',$user->email)
//                    ->where('lead_provider',$week_providers->lead_provider)
//                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
//                    ->whereDate('created_at','<=',date('Y-m-d'))->get();
//
//                $week1 = $week_provider_leads;
//                $week2 = $week_provider_leads;
//                $week3 = $week_provider_leads;
//                $week4 = $week_provider_leads;
//                $week5 = $week_provider_leads;
//                $week6 = $week_provider_leads;
//                $week7 = $week_provider_leads;
//                $week8 = $week_provider_leads;
//
//                $custom_sources[] = ['week_provider' => $week_providers->lead_provider,
//                    'total-provider' => number_format($week1->count()),
//                    'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
//                    'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
//                    'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
//                    'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
//                    'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
//                    'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
//                    'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
//                ];
//            }
//            $week2_appointement_showed_p = 0;
//            $week2_appointment_set_p = 0;
//            $week2_appointment_cancel_p = 0;
//            $week2_appointment_missed_p = 0;
//            $week2_active_co_byuer_p = 0;
//            $week2_active_contacted_p = 0;
//            $week2_active_service_p = 0;
//            $week2_active_employement_p = 0;
//            $week2_active_reminder_set_p = 0;
//            $week2_active_sale_p = 0;
//            $week2_dms_offer_replied_p = 0;
//            $week2_blocked_harassment_p = 0;
//            $week2_blocked_inappropirate_p = 0;
//            $week2_sold_unknown_p = 0;
//            $week2_sold_used_p = 0;
//            $week2_sold_new_p = 0;
//
//
//            if($week2_leads != 0)
//            {
//                $week2_appointement_showed_p = number_format( ($week2_appointment_showed/$week2_leads) * 100, 2 );
//                $week2_appointment_set_p = number_format( ($week2_appointment_set/$week2_leads) * 100, 2 );
//                $week2_appointment_cancel_p = number_format( ($week2_appointment_cancel/$week2_leads) * 100, 2 );
//                $week2_appointment_missed_p = number_format( ($week2_appointment_missed/$week2_leads) * 100, 2 );
//                $week2_active_co_byuer_p = number_format( ($week2_active_co_buyer/$week2_leads) * 100, 2 );
//                $week2_active_contacted_p = number_format( ($week2_active_contacted/$week2_leads) * 100, 2 );
//                $week2_active_service_p = number_format( ($week2_active_service/$week2_leads) * 100, 2 );
//                $week2_active_employement_p = number_format( ($week2_active_employement/$week2_leads) * 100, 2 );
//                $week2_active_reminder_set_p = number_format( ($week2_active_reminder_set/$week2_leads) * 100, 2 );
//                $week2_active_sale_p = number_format( ($week2_active_sale/$week2_leads) * 100, 2 );
//                $week2_blocked_harassment_p = number_format( ($week2_blocked_harassment/$week2_leads) * 100, 2 );
//                $week2_blocked_inappropirate_p = number_format( ($week2_blocked_inappropirate/$week2_leads) * 100, 2 );
//                $week2_dms_offer_replied_p = number_format( ($week2_dms_offer_replied/$week2_leads) * 100, 2 );
//                $week2_sold_unknown_p = number_format( ($week2_sold_unknown/$week2_leads) * 100, 2 );
//                $week2_sold_used_p = number_format( ($week2_sold_used/$week2_leads) * 100, 2 );
//                $week2_sold_new_p = number_format( ($week2_sold_new/$week2_leads) * 100, 2 );
//
//            }
//
//        }
//
//        elseif($user->usertype_id == 4){
//
//            $getUser =  User::where('id',$user->id)->first(['parent_user_id']);
//            $getAdmin =  User::where('id',$getUser->parent_user_id)->first(['id','email']);
//
//            $assigned_column = "admin_email";
//
//            $check_permission = Permissionallowed::where('user_id', $getAdmin->id)->first(['lead_structure']);
//
//            if($check_permission != null)
//            {
//                if($check_permission->lead_structure == 'assigned')
//                {
//                    $assigned_column = "assigned_user_id";
//                    $assigned_agents = $user->id;
//                    $assigned_sender_agent = $user->id;
//                }
//                else
//                {
//                    $assigned_column = "admin_email";
//                    $assigned_agents =  $getAdmin->email;
//                    $assigned_sender_agent = $getAdmin->id;
//                }
//            }
//
//
//            $week_total_sent = Leadchat::where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('sender_id',$assigned_sender_agent)->count('*');
//
//            $week_leads = Lead::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
//            $week_leads_data = Lead::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->get();
//            $week_credit_applications = 0;
//            //  dd($week_leads_data,$week_leads);
//
//            if(count($week_leads_data) > 0){
//                foreach($week_leads_data as $row){
//
//                    $lead_week_credit_applications = Creditapplication::whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('lead_id',$row->id)->count('*');
//
//                    if(!empty($lead_week_credit_applications)){
//
//                        $week_credit_applications =  $week_credit_applications + $lead_week_credit_applications;
//                    }
//                }
//            }
//
//            $week_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
//            $week_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
//            $week_text_blast = Leadblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
//            $week_email_blast = Emailblast::where('email_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
//            $week_mms_blast = Mmsblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
//            $week_voicemail_blast =  Voicemailblast::where('message_status','Sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->where('send_id',$assigned_sender_agent)->count('*');
//
//            // Weekly End
//            $week_active_contacted = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Contacted')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//            $week_active_fresh = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Fresh')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//            $week_blocked_harassment = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Harassment')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//            $week_blocked_inappropirate = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Inappropirate')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//            $week_wrong_number = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Wrong Number')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
//
//
//            $week_appointement_showed_p = 0;
//            $week_appointment_set_p = 0;
//            $week_active_fresh_p = 0;
//            $week_active_contacted_p = 0;
//            $week_block_harasment_p = 0;
//            $week_block_inappropirate_p = 0;
//            $week_wrong_number_p = 0;
//
//            if($week_leads != 0) {
//                $week_appointement_showed_p = number_format(($week_appointment_showed / $week_leads) * 100, 2);
//                $week_appointment_set_p = number_format(($week_appointment_set / $week_leads) * 100, 2);
//                $week_active_fresh_p = number_format( ($week_active_fresh/$week_leads) * 100, 2 );
//                $week_active_contacted_p = number_format(($week_active_contacted / $week_leads) * 100, 2);
//                $week_block_harasment_p = number_format( ($week_blocked_harassment/$week_leads) * 100, 2 );
//                $week_block_inappropirate_p = number_format( ($week_blocked_inappropirate/$week_leads) * 100, 2 );
//                $week_wrong_number_p =   number_format( ($week_wrong_number/$week_leads) * 100, 2 );
//
//            }
//
//            $percentageSMS = array();
//            $percentageMMS = array();
//            $percentageRM = array();
//            $percentageEMAIL = array();
//            $adminId = $user->id;
//
//            $blast_percentage = Blastpercentage::whereNotNull('value')->where('value','!=','0')->where('user_id', $adminId)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->get(['blast_id','value','blast_type']);
//
//            if($blast_percentage && $blast_percentage->count() > 0)
//            {
//                foreach($blast_percentage as $blast_percentage)
//                {
//                    if($blast_percentage->blast_type == 'sms')
//                    {
//                        $check_blast = Leadblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//
//                    if($blast_percentage->blast_type == 'mms')
//                    {
//                        $check_blast = Mmsblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//
//                    if($blast_percentage->blast_type == 'email')
//                    {
//                        $check_blast = Emailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//
//                    if($blast_percentage->blast_type == 'call')
//                    {
//                        $check_blast = Voicemailblast::whereNotNull('send_limit')->where('send_limit','!=','0')->where('id', $blast_percentage->blast_id)->first(['send_limit']);
//
//                        $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
//                    }
//                }
//            }
//
//
//            $week_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
//            $week_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
//            $week_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
//            $week_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';
//
//
//
//            // week level 2 for usertype
//            $week2_leads = Lead::whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
//
//            $week2_active_co_buyer = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Co-Buyer')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_active_contacted = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Contacted')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_active_service = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Service')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_active_employement = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Employement')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_active_reminder_set = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Reminder-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_active_sale = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Active-Sale')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_appointment_cancel = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-Cancel')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_appointment_set = Lead::where('lead_status','Appointment-Set')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where($assigned_column,$assigned_agents)->count('*');
//            $week2_appointment_missed = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-Missed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_appointment_showed = Lead::where('lead_status','Appointment-Showed')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->where('admin_email',$user->email)->count('*');
//            $week2_appointment_state = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Appointment-State')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_blocked_harassment = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Harassment')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_blocked_inappropirate = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Blocked-Inappropirate')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_dms_offer_replied = Lead::where($assigned_column,$assigned_agents)->where('lead_status','DMS-Offer-Replied')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_not_interested = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Not Interested')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_sold_unknown = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-Unknown')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_sold_used = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-Used')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            $week2_sold_new = Lead::where($assigned_column,$assigned_agents)->where('lead_status','Sold-New')->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))->count('*');
//            // week End
//
//
//
//
//            $week_providers = Lead::select('leads.lead_provider')
//                ->selectRaw('count(*) as c, lead_provider')
//                ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
//                ->whereDate('created_at','<=',date('Y-m-d'))
//                ->where("admin_email",$getAdmin->email)
//                ->groupBy('lead_provider')
//                ->having('c','>=','1')
//                ->orderby('c','desc')
//                ->get();
//
//            $custom_sources = array();
//
//            foreach($week_providers as $week_providers)
//            { //$startdate $enddate
//                $week_provider_leads = Lead::where('admin_email',$getAdmin->email)
//                    ->where('lead_provider',$week_providers->lead_provider)
//                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
//                    ->whereDate('created_at','<=',date('Y-m-d'))->get();
//
//                $week1 = $week_provider_leads;
//                $week2 = $week_provider_leads;
//                $week3 = $week_provider_leads;
//                $week4 = $week_provider_leads;
//                $week5 = $week_provider_leads;
//                $week6 = $week_provider_leads;
//                $week7 = $week_provider_leads;
//                $week8 = $week_provider_leads;
//
//                $custom_sources[] = ['week_provider' => $week_providers->lead_provider,
//                    'total-provider' => number_format($week1->count()),
//                    'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
//                    'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
//                    'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
//                    'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
//                    'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
//                    'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
//                    'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
//                ];
//            }
//
//            $week2_appointement_showed_p = 0;
//            $week2_appointment_set_p = 0;
//            $week2_appointment_cancel_p = 0;
//            $week2_appointment_missed_p = 0;
//            $week2_active_co_byuer_p = 0;
//            $week2_active_contacted_p = 0;
//            $week2_active_service_p = 0;
//            $week2_active_employement_p = 0;
//            $week2_active_reminder_set_p = 0;
//            $week2_active_sale_p = 0;
//            $week2_dms_offer_replied_p = 0;
//            $week2_blocked_harassment_p = 0;
//            $week2_blocked_inappropirate_p = 0;
//            $week2_sold_unknown_p = 0;
//            $week2_sold_used_p = 0;
//            $week2_sold_new_p = 0;
//
//
//            if($week2_leads != 0)
//            {
//                $week2_appointement_showed_p = number_format( ($week2_appointment_showed/$week2_leads) * 100, 2 );
//                $week2_appointment_set_p = number_format( ($week2_appointment_set/$week2_leads) * 100, 2 );
//                $week2_appointment_cancel_p = number_format( ($week2_appointment_cancel/$week2_leads) * 100, 2 );
//                $week2_appointment_missed_p = number_format( ($week2_appointment_missed/$week2_leads) * 100, 2 );
//                $week2_active_co_byuer_p = number_format( ($week2_active_co_buyer/$week2_leads) * 100, 2 );
//                $week2_active_contacted_p = number_format( ($week2_active_contacted/$week2_leads) * 100, 2 );
//                $week2_active_service_p = number_format( ($week2_active_service/$week2_leads) * 100, 2 );
//                $week2_active_employement_p = number_format( ($week2_active_employement/$week2_leads) * 100, 2 );
//                $week2_active_reminder_set_p = number_format( ($week2_active_reminder_set/$week2_leads) * 100, 2 );
//                $week2_active_sale_p = number_format( ($week2_active_sale/$week2_leads) * 100, 2 );
//                $week2_blocked_harassment_p = number_format( ($week2_blocked_harassment/$week2_leads) * 100, 2 );
//                $week2_blocked_inappropirate_p = number_format( ($week2_blocked_inappropirate/$week2_leads) * 100, 2 );
//                $week2_dms_offer_replied_p = number_format( ($week2_dms_offer_replied/$week2_leads) * 100, 2 );
//                $week2_sold_unknown_p = number_format( ($week2_sold_unknown/$week2_leads) * 100, 2 );
//                $week2_sold_used_p = number_format( ($week2_sold_used/$week2_leads) * 100, 2 );
//                $week2_sold_new_p = number_format( ($week2_sold_new/$week2_leads) * 100, 2 );
//
//            }
//
//        }
//
//
//
//
//
//        $data = [
//            'week_leads' => $week_leads,
//            'week_credit_applications' => $week_credit_applications,
//            'week_appointment_set' => $week_appointment_set,
//            'week_appointment_set_p' => $week_appointment_set_p,
//            'week_appointment_showed' => $week_appointment_showed,
//            'week_appointement_showed_p' => $week_appointement_showed_p,
//            'week_text_blast' => $week_text_blast,
//            'week_text_blast_p' => $week_text_blast_p,
//            'week_email_blast' => $week_email_blast,
//            'week_email_blast_p' => $week_email_blast_p,
//            'week_mms_blast' => $week_mms_blast,
//            'week_mms_blast_p' => $week_mms_blast_p,
//            'week_voicemail_blast' => $week_voicemail_blast,
//            'week_voicemail_blast_p' => $week_voicemail_blast_p,
//            // dealer_status_box
//            'week_active_contacted' => $week_active_contacted,
//            'week_active_contacted_p' => $week_active_contacted_p,
//            'week_active_fresh' => $week_active_fresh,
//            'week_active_fresh_p' => $week_active_fresh_p,
//            'week_blocked_harassment'  => $week_blocked_harassment,
//            'week_block_harasment_p' => $week_block_harasment_p,
//            'week_blocked_inappropirate' => $week_blocked_inappropirate,
//            'week_block_inappropirate_p' => $week_block_inappropirate_p,
//            'week_wrong_number' => $week_wrong_number,
//            'week_wrong_number_p' => $week_wrong_number_p,
//
//            // level 2
//            'week2_leads' => $week2_leads,
//            'week2_active_co_buyer' => $week2_active_co_buyer,
//            'week2_active_co_byuer_p ' => $week2_active_co_byuer_p,
//            'week2_active_contacted' => $week2_active_contacted,
//            'week2_active_contacted_p' => $week2_active_contacted_p,
//            'week2_active_service' => $week2_active_service,
//            'week2_active_service_p' => $week2_active_service_p,
//            'week2_active_employement' => $week2_active_employement,
//            'week2_active_employement_p' => $week2_active_employement_p,
//            'week2_active_reminder_set' => $week2_active_reminder_set,
//            'week2_active_reminder_set_p' => $week2_active_reminder_set_p,
//            'week2_active_sale' => $week2_active_sale,
//            'week2_active_sale_p' => $week2_active_sale_p,
//            'week2_appointment_cancel' => $week2_appointment_cancel,
//            'week2_appointment_cancel_p' => $week2_appointment_cancel_p,
//            'week2_appointment_missed' => $week2_appointment_missed,
//            'week2_appointment_missed_p' => $week2_appointment_missed_p,
//            'week2_appointment_state'  => $week2_appointment_state,
//            'week2_blocked_harassment' => $week2_blocked_harassment,
//            'week2_blocked_harassment_p' => $week2_blocked_harassment_p,
//            'week2_blocked_inappropirate' => $week2_blocked_inappropirate,
//            'week2_blocked_inappropirate_p' => $week2_blocked_inappropirate_p,
//            'week2_dms_offer_replied' => $week2_dms_offer_replied,
//            'week2_dms_offer_replied_p' => $week2_dms_offer_replied_p,
//            'week2_not_interested' => $week2_not_interested,
//            'week2_sold_unknown'  => $week2_sold_unknown,
//            'week2_sold_unknown_p' => $week2_sold_unknown_p,
//            'week2_sold_used' => $week2_sold_used,
//            'week2_sold_used_p' => $week2_sold_used_p,
//            'week2_sold_new' => $week2_sold_new,
//            'week2_sold_new_p' => $week2_sold_new_p,
//            'week2_appointment_set' => $week2_appointment_set,
//            'week2_appointment_set_p' => $week2_appointment_set_p,
//            'week2_appointment_showed' => $week2_appointment_showed,
//            'week2_appointement_showed_p' => $week2_appointement_showed_p,
//            // Week End
//        ];
//
//        return $this->sendResponse([
//            'week_report' => $data,
//            'providers' => $custom_sources,
//        ],'today_report');
//    }

    public function kpicustomesearch(Request $request){
    $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        
    if($user->usertype_id == 2)
        {


        $startdate = date("Y-m-d", strtotime($request->date_from));
        $enddate = date("Y-m-d", strtotime($request->date_to));

        $custom_total_sent = Leadchat::where('type','sent')->where('lead_chat.created_at','>=' ,$startdate)->where('lead_chat.created_at','<=' ,$enddate)->where('sender_id',$user->id)->count('*');
        $custom_total_ninja = Leadchat::where('internal',1)->where('type','sent')->where('lead_chat.created_at','>=' ,$startdate)->where('lead_chat.created_at','<=' ,$enddate)->where('sender_id',$user->id)->count('*');
        $custom_total_dealer = Leadchat::where('internal',0)->where('type','sent')->where('lead_chat.created_at','>=' ,$startdate)->where('lead_chat.created_at','<=' ,$enddate)->where('sender_id',$user->id)->count('*');

        if($custom_total_ninja == 0 && $custom_total_dealer == 0){
            $dec_custom_ninja  = 0;
            $dec_custom_dealer = 0;
        }
        else
            {
            $dec_custom_ninja = $custom_total_ninja / $custom_total_sent * 100;
            $dec_custom_dealer = $custom_total_dealer / $custom_total_sent * 100;
        }

        $custom_ninja = number_format($dec_custom_ninja);
        $custom_dealer = number_format($dec_custom_dealer);

        $dealers_custom = '<h2 class="mt-3" style="color: #7F8687;">'.$custom_dealer.'%</h2>';


        $admin = Companyinfo::where('user_id',$user->id)->first();
        $total_leads = Lead::where('admin_email',$user->email)->whereBetween('created_at',[$startdate,$enddate])->count('*');
        $total_credit_application = Creditapplication::where('email',$user->email)->whereDate('credit_application.created_at','>=',$startdate)->whereDate('credit_application.created_at','<=',$enddate)->count('*');
        $total_appointment_set = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Set')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointement_showed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Showed')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_co_byuer = Lead::where('admin_email',$user->email)->where('lead_status','Active-Co-Buyer')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_no_tickle = Lead::where('admin_email',$user->email)->where('lead_status','Active-NoTickle')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_fresh = Lead::where('admin_email',$user->email)->where('lead_status','Active-Fresh')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_service = Lead::where('admin_email',$user->email)->where('lead_status','Active-Service')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_employement = Lead::where('admin_email',$user->email)->where('lead_status','Active-Employement')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_reminder_set = Lead::where('admin_email',$user->email)->where('lead_status','Active-Reminder-Set')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_sale = Lead::where('admin_email',$user->email)->where('lead_status','Active-Sale')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointment_cancel = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Cancel')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointment_missed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Missed')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointment_state = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-State')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_block_harasment = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_block_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_dms_offer_replied = Lead::where('admin_email',$user->email)->where('lead_status','DMS Offer-Replied')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_sold_unknown = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Unknown')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_sold_used = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Used')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_sold_new = Lead::where('admin_email',$user->email)->where('lead_status','Sold-New')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_wrong_number = Lead::where('admin_email',$user->email)->where('lead_status','Wrong Number')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_text_blast = Leadblast::where('send_id',$user->id)->where('message_status','Sent')->whereDate('lead_blast.created_at','>=',$startdate)->whereDate('lead_blast.created_at','<=',$enddate)->count('*');
        $total_email_blast = Emailblast::where('send_id',$user->id)->where('email_status','Sent')->whereDate('email_blast.created_at','>=',$startdate)->whereDate('email_blast.created_at','<=',$enddate)->count('*');
        $total_mms_blast = Mmsblast::where('send_id',$user->id)->where('message_status','Sent')->whereDate('mms_blast.created_at','>=',$startdate)->whereDate('mms_blast.created_at','<=',$enddate)->count('*');
        $total_voicemail_blast = Voicemailblast::where('send_id',$user->id)->where('message_status','Sent')->whereDate('voicemail_blast.created_at','>=',$startdate)->whereDate('voicemail_blast.created_at','<=',$enddate)->count('*');

        $total_appointement_showed_p = 0;
        $total_appointment_set_p = 0;
        $total_appointment_cancel_p = 0;
        $total_appointment_missed_p = 0;
        $total_appointment_state_p = 0;
        $total_active_co_byuer_p = 0;
        $total_active_contacted_p = 0;
        $total_active_no_tickle_p = 0;
        $total_active_fresh_p = 0;
        $total_active_service_p = 0;
        $total_active_employement_p = 0;
        $total_active_reminder_set_p = 0;
        $total_active_sale_p = 0;
        $total_block_harasment_p = 0;
        $total_block_inappropirate_p = 0;
        $total_dms_offer_replied_p = 0;
        $total_sold_unknown_p = 0;
        $total_sold_used_p = 0;
        $total_sold_new_p = 0;
        $total_wrong_number_p = 0;

        if($total_leads != 0)
        {
            $total_appointement_showed_p = number_format( ($total_appointement_showed/$total_leads) * 100, 2 );
            $total_appointment_set_p = number_format( ($total_appointment_set/$total_leads) * 100, 2 );
            $total_active_contacted_p = number_format( ($total_active_contacted/$total_leads) * 100, 2 );
            $total_active_fresh_p = number_format( ($total_active_fresh/$total_leads) * 100, 2 );
            $total_block_harasment_p = number_format( ($total_block_harasment/$total_leads) * 100, 2 );
            $total_block_inappropirate_p = number_format( ($total_block_inappropirate/$total_leads) * 100, 2 );
            $total_wrong_number_p =   number_format( ($total_wrong_number/$total_leads) * 100, 2 );
        }


        // level 2 start


        $total2_leads = Lead::where('admin_email',$user->email)->whereBetween('updated_at',[$startdate,$enddate])->count('*');
        $total2_appointment_set = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Set')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointement_showed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Showed')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_co_byuer = Lead::where('admin_email',$user->email)->where('lead_status','Active-Co-Buyer')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_contacted = Lead::where('admin_email',$user->email)->where('lead_status','Active-Contacted')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_no_tickle = Lead::where('admin_email',$user->email)->where('lead_status','Active-NoTickle')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_fresh = Lead::where('admin_email',$user->email)->where('lead_status','Active-Fresh')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_service = Lead::where('admin_email',$user->email)->where('lead_status','Active-Service')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_employement = Lead::where('admin_email',$user->email)->where('lead_status','Active-Employement')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_reminder_set = Lead::where('admin_email',$user->email)->where('lead_status','Active-Reminder-Set')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_sale = Lead::where('admin_email',$user->email)->where('lead_status','Active-Sale')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointment_cancel = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Cancel')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointment_missed = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Missed')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointment_state = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-State')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_block_harasment = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Harassment')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_block_inappropirate = Lead::where('admin_email',$user->email)->where('lead_status','Blocked-Inappropirate')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_dms_offer_replied = Lead::where('admin_email',$user->email)->where('lead_status','DMS Offer-Replied')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_not_interested = Lead::where('admin_email',$user->email)->where('lead_status','Not Interested')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_sold_unknown = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Unknown')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_sold_used = Lead::where('admin_email',$user->email)->where('lead_status','Sold-Used')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_sold_new = Lead::where('admin_email',$user->email)->where('lead_status','Sold-New')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');



        $total2_appointement_showed_p = 0;
        $total2_appointment_set_p = 0;
        $total2_appointment_cancel_p = 0;
        $total2_appointment_missed_p = 0;
        $total2_active_co_byuer_p = 0;
        $total2_active_contacted_p = 0;
        $total2_active_service_p = 0;
        $total2_active_employement_p = 0;
        $total2_active_reminder_set_p = 0;
        $total2_active_sale_p = 0;
        $total2_block_harasment_p = 0;
        $total2_block_inappropirate_p = 0;
        $total2_dms_offer_replied_p = 0;
        $total2_sold_unknown_p = 0;
        $total2_sold_used_p = 0;
        $total2_sold_new_p = 0;



        if($total2_leads != 0)
        {
            $total2_appointement_showed_p = number_format( ($total2_appointement_showed/$total2_leads) * 100, 2 );
            $total2_appointment_set_p = number_format( ($total2_appointment_set/$total2_leads) * 100, 2 );
            $total2_appointment_cancel_p = number_format( ($total2_appointment_cancel/$total2_leads) * 100, 2 );
            $total2_appointment_missed_p = number_format( ($total2_appointment_missed/$total2_leads) * 100, 2 );
            $total2_active_co_byuer_p = number_format( ($total2_active_co_byuer/$total2_leads) * 100, 2 );
            $total2_active_contacted_p = number_format( ($total2_active_contacted/$total2_leads) * 100, 2 );
            $total2_active_service_p = number_format( ($total2_active_service/$total2_leads) * 100, 2 );
            $total2_active_employement_p = number_format( ($total2_active_employement/$total2_leads) * 100, 2 );
            $total2_active_reminder_set_p = number_format( ($total2_active_reminder_set/$total2_leads) * 100, 2 );
            $total2_active_sale_p = number_format( ($total2_active_sale/$total2_leads) * 100, 2 );
            $total2_block_harasment_p = number_format( ($total2_block_harasment/$total2_leads) * 100, 2 );
            $total2_block_inappropirate_p = number_format( ($total2_block_inappropirate/$total2_leads) * 100, 2 );
            $total2_dms_offer_replied_p = number_format( ($total2_dms_offer_replied/$total2_leads) * 100, 2 );
            $total2_sold_unknown_p = number_format( ($total2_sold_unknown/$total2_leads) * 100, 2 );
            $total2_sold_used_p = number_format( ($total2_sold_used/$total2_leads) * 100, 2 );
            $total2_sold_new_p = number_format( ($total2_sold_new/$total2_leads) * 100, 2 );

        }

        // level 2 end

        // level 2 end
        $percentageSMS = array();
        $percentageMMS = array();
        $percentageRM = array();
        $percentageEMAIL = array();
        $adminId = $user->id;

        $blast_percentage = Blastpercentage::where('user_id', $adminId)->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)->get(['blast_id','value','blast_type']);

        if($blast_percentage && $blast_percentage->count() > 0)
        {
            foreach($blast_percentage as $blast_percentage)
            {
//                dd($blast_percentage->blast_type);
                if($blast_percentage->blast_type == 'sms')
                {
                    $check_blast = Leadblast::where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageSMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'mms')
                {
                    $check_blast = Leadblast::where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageMMS[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'email')
                {

                    $check_blast = Leadblast::where('id', $blast_percentage->blast_id)->first(['send_limit']);
                    $percentageEMAIL[] .= ($blast_percentage->value / $check_blast->send_limit);
                }

                if($blast_percentage->blast_type == 'call')
                {
                    $check_blast = Leadblast::where('id', $blast_percentage->blast_id)->first(['send_limit']);

                    $percentageRM[] .= ($blast_percentage->value / $check_blast->send_limit);
                }
            }
        }

            $total_text_blast_p = number_format( array_sum($percentageSMS) * 100, 2 ).'%';
            $total_email_blast_p = number_format( array_sum($percentageEMAIL) * 100, 2 ).'%';
            $total_mms_blast_p = number_format( array_sum($percentageMMS) * 100, 2 ).'%';
            $total_voicemail_blast_p = number_format( array_sum($percentageRM) * 100, 2 ).'%';


        $week_providers = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as c, lead_provider')
            ->where("admin_email",$user->email)
            ->whereDate('created_at','>=',$startdate)
            ->whereDate('created_at','<=',$enddate)
            ->groupBy('lead_provider')
            ->having('c','>=','1')
            ->orderby('c','desc')
            ->get();
        $custom_sources = array();

        foreach($week_providers as $week_providers)
        { //$startdate $enddate
            $week_provider_leads = Lead::where('admin_email',$user->email)
                ->where('lead_provider',$week_providers->lead_provider)
                ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                ->whereDate('created_at','<=',date('Y-m-d'))->get();

            $week1 = $week_provider_leads;
            $week2 = $week_provider_leads;
            $week3 = $week_provider_leads;
            $week4 = $week_provider_leads;
            $week5 = $week_provider_leads;
            $week6 = $week_provider_leads;
            $week7 = $week_provider_leads;
            $week8 = $week_provider_leads;

            $custom_sources[] = ['week_provider' => $week_providers->lead_provider,
                'total-provider' => number_format($week1->count()),
                'Active-Contacted' => number_format($week2->where("lead_status","Active-Contacted")->count()),
                'Appointment-Set' => number_format($week3->where("lead_status","Appointment-Set")->count()),
                'Appointment-Showed' => number_format($week4->where("lead_status","Appointment-Showed")->count()),
                'Sold-Used' => number_format($week5->where("lead_status","Sold-Used")->count()),
                'Sold-New' => number_format($week6->where("lead_status","Sold-New")->count()),
                'Wrong Number' => number_format($week7->where("lead_status","Wrong Number")->count()),
                'Not Interested' => number_format($week8->where("lead_status","Not Interested")->count())
            ];
        }


//        $data = array('leads_transfer' => $leads_transfer,'engagement_box' => $engagement_box,'engagement_box2' => $engagement_box2 , 'dealers_custom' => $dealers_custom, 'custom_ninja' => $custom_ninja,'custom_dealer' => $custom_dealer, 'custom_sources' => $custom_sources);

        $data = [
            'total_leads' => $total_leads,
            'total_credit_application' => $total_credit_application,
            'total_appointment_set' => $total_appointment_set,
            'total_appointment_set_p' => $total_appointment_set_p,
            'total_appointment_showed' => $total_appointement_showed,
            'total_appointement_showed_p' => $total_appointement_showed_p,
            'total_text_blast' => $total_text_blast,
            'total_text_blast_p' => $total_text_blast_p,
            'total_email_blast' => $total_email_blast,
            'total_email_blast_p' => $total_email_blast_p,
            'total_mms_blast' => $total_mms_blast,
            'total_mms_blast_p' => $total_mms_blast_p,
            'total_voicemail_blast' => $total_voicemail_blast,
            'total_voicemail_blast_p' => $total_voicemail_blast_p,
            // dealer_status_box
            'total_active_contacted' => $total_active_contacted,
            'total_active_contacted_p' => $total_active_contacted_p,
            'total_active_fresh' => $total_active_fresh,
            'total_active_fresh_p' => $total_active_fresh_p,
            'total_blocked_harassment'  => $total_block_harasment,
            'total_block_harasment_p' => $total_block_harasment_p,
            'total_blocked_inappropirate' => $total_block_inappropirate,
            'total_block_inappropirate_p' => $total_block_inappropirate_p,
            'total_wrong_number' => $total_wrong_number,
            'total_wrong_number_p' => $total_wrong_number_p,

            // level 2
            'total2_leads' => $total2_leads,
            'total2_active_co_buyer' => $total2_active_co_byuer,
            'total2_active_co_byuer_p ' => $total2_active_co_byuer_p,
            'total2_active_contacted' => $total2_active_contacted,
            'total2_active_contacted_p' => $total2_active_contacted_p,
            'total2_active_service' => $total2_active_service,
            'total2_active_service_p' => $total2_active_service_p,
            'total2_active_employement' => $total2_active_employement,
            'total2_active_employement_p' => $total2_active_employement_p,
            'total2_active_reminder_set' => $total2_active_reminder_set,
            'total2_active_reminder_set_p' => $total2_active_reminder_set_p,
            'total2_active_sale' => $total2_active_sale,
            'total2_active_sale_p' => $total2_active_sale_p,
            'total2_appointment_cancel' => $total2_appointment_cancel,
            'total2_appointment_cancel_p' => $total2_appointment_cancel_p,
            'total2_appointment_missed' => $total2_appointment_missed,
            'total2_appointment_missed_p' => $total2_appointment_missed_p,
            'total2_appointment_state'  => $total2_appointment_state,
            'total2_blocked_harassment' => $total2_block_harasment,
            'total2_blocked_harassment_p' => $total2_block_harasment_p,
            'total2_blocked_inappropirate' => $total2_block_inappropirate,
            'total2_blocked_inappropirate_p' => $total2_block_inappropirate_p,
            'total2_dms_offer_replied' => $total2_dms_offer_replied,
            'total2_dms_offer_replied_p' => $total2_dms_offer_replied_p,
            'total2_not_interested' => $total2_not_interested,
            'total2_sold_unknown'  => $total2_sold_unknown,
            'total2_sold_unknown_p' => $total2_sold_unknown_p,
            'total2_sold_used' => $total2_sold_used,
            'total2_sold_used_p' => $total2_sold_used_p,
            'total2_sold_new' => $total2_sold_new,
            'total2_sold_new_p' => $total2_sold_new_p,
            'total2_appointment_set' => $total2_appointment_set,
            'total2_appointment_set_p' => $total2_appointment_set_p,
            'total2_appointment_showed' => $total2_appointement_showed,
            'total2_appointement_showed_p' => $total2_appointement_showed_p,
            // total End

//            'total_providers' => $total_providers
        ];

        return $this->sendResponse([
            'today_report' => $data,
            'providers' => $custom_sources,
        ],'today_report');

    }
    elseif($user->usertype_id == 4)
        {

        $users = User::where('id',$user->id)->first();
        $getAdmin = User::where('id',$users->parent_user_id)->first();
        $admin = Companyinfo::where('user_id',$users->parent_user_id)->first();

        $startdate = date("Y-m-d", strtotime($request->date_from));
        $enddate = date("Y-m-d", strtotime($request->date_to));

        $custom_total_sent = Leadchat::where('type','sent')->where('lead_chat.created_at','>=' ,$startdate)->where('lead_chat.created_at','<=' ,$enddate)->where('sender_id',$getAdmin->id)->count('*');
        $custom_total_ninja = Leadchat::where('internal',1)->where('type','sent')->where('lead_chat.created_at','>=' ,$startdate)->where('lead_chat.created_at','<=' ,$enddate)->where('sender_id',$getAdmin->id)->count('*');
        $custom_total_dealer = Leadchat::where('internal',0)->where('type','sent')->where('lead_chat.created_at','>=' ,$startdate)->where('lead_chat.created_at','<=' ,$enddate)->where('sender_id',$getAdmin->id)->count('*');

        if($custom_total_ninja == 0 && $custom_total_dealer == 0){
            $dec_custom_ninja  = 0;
            $dec_custom_dealer = 0;
        }
        else{
            $dec_custom_ninja = $custom_total_ninja / $custom_total_sent * 100;
            $dec_custom_dealer = $custom_total_dealer / $custom_total_sent * 100;
        }

        $custom_ninja = number_format($dec_custom_ninja);
        $custom_dealer = number_format($dec_custom_dealer);

        $dealers_custom = '<h2 class="mt-3" style="color: #7F8687;">'.$custom_dealer.'%</h2>';


        $admin = Companyinfo::where('user_id',$getAdmin->id)->first();
        $total_leads = Lead::where('admin_email',$getAdmin->email)->whereBetween('created_at',[$startdate,$enddate])->count('*');
        $total_credit_application = Creditapplication::where('email',$getAdmin->email)->whereDate('credit_application.created_at','>=',$startdate)->whereDate('credit_application.created_at','<=',$enddate)->count('*');
        $total_appointment_set = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Set')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointement_showed = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Showed')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_co_byuer = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Co-Buyer')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_contacted = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Contacted')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_no_tickle = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-NoTickle')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_fresh = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Fresh')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_service = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Service')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_employement = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Employement')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_reminder_set = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Reminder-Set')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_active_sale = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Sale')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointment_cancel = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Cancel')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointment_missed = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Missed')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_appointment_state = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-State')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_block_harasment = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Blocked-Harassment')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_block_inappropirate = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Blocked-Inappropirate')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_dms_offer_replied = Lead::where('admin_email',$getAdmin->email)->where('lead_status','DMS Offer-Replied')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_sold_unknown = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Sold-Unknown')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_sold_used = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Sold-Used')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_sold_new = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Sold-New')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_wrong_number = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Wrong Number')->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
        $total_text_blast = Leadblast::where('send_id',$getAdmin->id)->where('message_status','Sent')->whereDate('lead_blast.created_at','>=',$startdate)->whereDate('lead_blast.created_at','<=',$enddate)->count('*');
        $total_email_blast = Emailblast::where('send_id',$getAdmin->id)->where('email_status','Sent')->whereDate('email_blast.created_at','>=',$startdate)->whereDate('email_blast.created_at','<=',$enddate)->count('*');
        $total_mms_blast = Mmsblast::where('send_id',$getAdmin->id)->where('message_status','Sent')->whereDate('mms_blast.created_at','>=',$startdate)->whereDate('mms_blast.created_at','<=',$enddate)->count('*');
        $total_voicemail_blast = Voicemailblast::where('send_id',$getAdmin->id)->where('message_status','Sent')->whereDate('voicemail_blast.created_at','>=',$startdate)->whereDate('voicemail_blast.created_at','<=',$enddate)->count('*');

        $total_appointement_showed_p = 0;
        $total_appointment_set_p = 0;
        $total_appointment_cancel_p = 0;
        $total_appointment_missed_p = 0;
        $total_appointment_state_p = 0;
        $total_active_co_byuer_p = 0;
        $total_active_contacted_p = 0;
        $total_active_no_tickle_p = 0;
        $total_active_fresh_p = 0;
        $total_active_service_p = 0;
        $total_active_employement_p = 0;
        $total_active_reminder_set_p = 0;
        $total_active_sale_p = 0;
        $total_block_harasment_p = 0;
        $total_block_inappropirate_p = 0;
        $total_dms_offer_replied_p = 0;
        $total_sold_unknown_p = 0;
        $total_sold_used_p = 0;
        $total_sold_new_p = 0;
        $total_wrong_number_p = 0;

        if($total_leads != 0)
        {
            $total_appointement_showed_p = number_format( ($total_appointement_showed/$total_leads) * 100, 2 );
            $total_appointment_set_p = number_format( ($total_appointment_set/$total_leads) * 100, 2 );
            $total_appointment_cancel_p = number_format( ($total_appointment_cancel/$total_leads) * 100, 2 );
            $total_appointment_missed_p = number_format( ($total_appointment_missed/$total_leads) * 100, 2 );
            $total_appointment_state_p = number_format( ($total_appointment_state/$total_leads) * 100, 2 );
            $total_active_co_byuer_p = number_format( ($total_active_co_byuer/$total_leads) * 100, 2 );
            $total_active_contacted_p = number_format( ($total_active_contacted/$total_leads) * 100, 2 );
            $total_active_no_tickle_p = number_format( ($total_active_no_tickle/$total_leads) * 100, 2 );
            $total_active_fresh_p = number_format( ($total_active_fresh/$total_leads) * 100, 2 );
            $total_active_service_p = number_format( ($total_active_service/$total_leads) * 100, 2 );
            $total_active_employement_p = number_format( ($total_active_employement/$total_leads) * 100, 2 );
            $total_active_reminder_set_p = number_format( ($total_active_reminder_set/$total_leads) * 100, 2 );
            $total_active_sale_p = number_format( ($total_active_sale/$total_leads) * 100, 2 );
            $total_block_harasment_p = number_format( ($total_block_harasment/$total_leads) * 100, 2 );
            $total_block_inappropirate_p = number_format( ($total_block_inappropirate/$total_leads) * 100, 2 );
            $total_dms_offer_replied_p = number_format( ($total_dms_offer_replied/$total_leads) * 100, 2 );
            $total_sold_unknown_p = number_format( ($total_sold_unknown/$total_leads) * 100, 2 );
            $total_sold_used_p = number_format( ($total_sold_used/$total_leads) * 100, 2 );
            $total_sold_new_p = number_format( ($total_sold_new/$total_leads) * 100, 2 );
            $total_wrong_number_p =   number_format( ($total_wrong_number/$total_leads) * 100, 2 );
        }


        // level 2 start


        $total2_leads = Lead::where('admin_email',$getAdmin->email)->whereBetween('updated_at',[$startdate,$enddate])->count('*');
        $total2_appointment_set = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Set')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointement_showed = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Showed')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_co_byuer = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Co-Buyer')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_contacted = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Contacted')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_no_tickle = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-NoTickle')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_fresh = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Fresh')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_service = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Service')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_employement = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Employement')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_reminder_set = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Reminder-Set')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_active_sale = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Active-Sale')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointment_cancel = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Cancel')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointment_missed = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Missed')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_appointment_state = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-State')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_block_harasment = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Blocked-Harassment')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_block_inappropirate = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Blocked-Inappropirate')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_dms_offer_replied = Lead::where('admin_email',$getAdmin->email)->where('lead_status','DMS Offer-Replied')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_not_interested = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Not Interested')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_sold_unknown = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Sold-Unknown')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_sold_used = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Sold-Used')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');
        $total2_sold_new = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Sold-New')->whereDate('leads.updated_at','>=',$startdate)->whereDate('leads.updated_at','<=',$enddate)->count('*');



        $total2_appointement_showed_p = 0;
        $total2_appointment_set_p = 0;
        $total2_appointment_cancel_p = 0;
        $total2_appointment_missed_p = 0;
        $total2_appointment_state_p = 0;
        $total2_active_co_byuer_p = 0;
        $total2_active_contacted_p = 0;
        $total2_active_no_tickle_p = 0;
        $total2_active_fresh_p = 0;
        $total2_active_service_p = 0;
        $total2_active_employement_p = 0;
        $total2_active_reminder_set_p = 0;
        $total2_active_sale_p = 0;
        $total2_block_harasment_p = 0;
        $total2_block_inappropirate_p = 0;
        $total2_dms_offer_replied_p = 0;
        $total2_not_interested_p = 0;
        $total2_sold_unknown_p = 0;
        $total2_sold_used_p = 0;
        $total2_sold_new_p = 0;



        if($total2_leads != 0)
        {
            $total2_appointement_showed_p = number_format( ($total2_appointement_showed/$total2_leads) * 100, 2 );
            $total2_appointment_set_p = number_format( ($total2_appointment_set/$total2_leads) * 100, 2 );
            $total2_appointment_cancel_p = number_format( ($total2_appointment_cancel/$total2_leads) * 100, 2 );
            $total2_appointment_missed_p = number_format( ($total2_appointment_missed/$total2_leads) * 100, 2 );
            $total2_appointment_state_p = number_format( ($total2_appointment_state/$total2_leads) * 100, 2 );
            $total2_active_co_byuer_p = number_format( ($total2_active_co_byuer/$total2_leads) * 100, 2 );
            $total2_active_contacted_p = number_format( ($total2_active_contacted/$total2_leads) * 100, 2 );
            $total2_active_no_tickle_p = number_format( ($total2_active_no_tickle/$total2_leads) * 100, 2 );
            $total2_active_fresh_p = number_format( ($total2_active_fresh/$total2_leads) * 100, 2 );
            $total2_active_service_p = number_format( ($total2_active_service/$total2_leads) * 100, 2 );
            $total2_active_employement_p = number_format( ($total2_active_employement/$total2_leads) * 100, 2 );
            $total2_active_reminder_set_p = number_format( ($total2_active_reminder_set/$total2_leads) * 100, 2 );
            $total2_active_sale_p = number_format( ($total2_active_sale/$total2_leads) * 100, 2 );
            $total2_block_harasment_p = number_format( ($total2_block_harasment/$total2_leads) * 100, 2 );
            $total2_block_inappropirate_p = number_format( ($total2_block_inappropirate/$total2_leads) * 100, 2 );
            $total2_dms_offer_replied_p = number_format( ($total2_dms_offer_replied/$total2_leads) * 100, 2 );
            $total2_not_interested_p = number_format( ($total2_not_interested/$total2_leads) * 100, 2 );
            $total2_sold_unknown_p = number_format( ($total2_sold_unknown/$total2_leads) * 100, 2 );
            $total2_sold_used_p = number_format( ($total2_sold_used/$total2_leads) * 100, 2 );
            $total2_sold_new_p = number_format( ($total2_sold_new/$total2_leads) * 100, 2 );

        }

        // level 2 end



        $week_providers = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as c, lead_provider')
            ->where("admin_email",$getAdmin->email)
            ->whereDate('created_at','>=',$startdate)
            ->whereDate('created_at','<=',$enddate)
            ->groupBy('lead_provider')
            ->having('c','>=','1')
            ->orderby('c','desc')
            ->get();
        $custom_sources = null;

        foreach($week_providers as $week_providers)
        { //$startdate $enddate
            $week_provider_leads = Lead::where('admin_email',$getAdmin->email)
                ->where('lead_provider',$week_providers->lead_provider)
                ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                ->whereDate('created_at','<=',date('Y-m-d'))->get();

            $week1 = $week_provider_leads;
            $week2 = $week_provider_leads;
            $week3 = $week_provider_leads;
            $week4 = $week_provider_leads;
            $week5 = $week_provider_leads;
            $week6 = $week_provider_leads;
            $week7 = $week_provider_leads;
            $week8 = $week_provider_leads;

            $custom_sources .= '<tr>
                                            <td><b>'.$week_providers->lead_provider.'</b></td>
                                            <td style="text-align:center">'.number_format($week1->count()).'</td>
                                            <td style="text-align:center">'.number_format($week2->where("lead_status","Active-Contacted")->count()).'</td>
                                            <td style="text-align:center">'.number_format($week3->where("lead_status","Appointment-Set")->count()).'</td>
                                            <td style="text-align:center">'.number_format($week4->where("lead_status","Appointment-Showed")->count()).'</td>
                                            <td style="text-align:center">'.number_format($week5->where("lead_status","Sold-Used")->count()).'</td>
                                            <td style="text-align:center">'.number_format($week6->where("lead_status","Sold-New")->count()).'</td>
                                            <td style="text-align:center">'.number_format($week7->where("lead_status","Wrong Number")->count()).'</td>
                                            <td style="text-align:center">'.number_format($week8->where("lead_status","Not Interested")->count()).'</td>
                                        </tr>';
        }

//        $data = array('leads_transfer' => $leads_transfer,'engagement_box' => $engagement_box,'engagement_box2' => $engagement_box2 , 'dealers_custom' => $dealers_custom, 'custom_ninja' => $custom_ninja,'custom_dealer' => $custom_dealer, 'custom_sources' => $custom_sources);

//        echo json_encode($data);
    }
    }

    public function chatLogs()
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
                if($user->usertype_id == 2)
                {
                    $admin = Companyinfo::where('user_id',$user->id)->first();

                    $chat_logs = Leadchat::where(function($query) use ($admin) {
                                                $query->where('from',$admin->phone_number)
                                                ->orWhere('to',$admin->phone_number);
                                            })->where('type','!=',null)->orderBy('id','desc')->paginate(10);

                    return $this->sendResponse([
                        'Chat_log' => $chat_logs,
                    ],'Chat_log');
                }
                else
                {
                    return $this->sendResponse([
                        'Chat_log' => 'something went erong',
                    ],'Chat_log');
                }
    }

    public function statusFilter(Request $request){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                $value = $request->value;
                $filterdate = $request->filterdate;

                $leadCount = null;

                if($user->usertype_id == 2){
                    $dealers = User::select('users.id','users.first_name','users.last_name')
                        ->where('parent_user_id',$user->id)
                        ->where('approval','approve')
                        ->get();

                    if($filterdate == 'today'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.created_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc');
                    }
                    elseif($filterdate == 'today2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.updated_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc');
                    }
                    elseif($filterdate == 'week'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc');
                    }
                    elseif($filterdate == 'week2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc');
                    }


                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$user->email)
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();
                    $leadCount = null;

                    $startdate= null;
                    $enddate=null;

                    return $this->sendResponse([
                        'leads' => $leads ,
                        'dealers' => $dealers,
                        'total_leads_provider' => $total_leads_provider,
                        'leadCount' => $leadCount,
                        'leadsTodayCount' => $leadsTodayCount,
                        'value' => $value,
                        'filterdate' => $filterdate,
                        'startdate' => $startdate,
                        'enddate' => $enddate

                    ],'leadlist');

//                    return view('backend.pages.text.reportboxcount',compact('leads','dealers','total_leads_provider','leadCount','leadsTodayCount','value','filterdate','startdate','enddate'));
                }

                elseif($user->usertype_id == 4){
                    $getUser = User::where('id',$user->id)->first();
                    $getAdmin = User::where('id',$getUser->parent_user_id)->first();

                    if($filterdate == 'today'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.created_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc');
                    }
                    elseif($filterdate == 'today2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.updated_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc');
                    }
                    elseif($filterdate == 'week'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc');
                    }
                    elseif($filterdate == 'week2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc');
                    }

                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$getAdmin->email)
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();
                    $leadCount = null;

                    $startdate= null;
                    $enddate=null;

                    return $this->sendResponse([
                        'leads' => $leads ,
                        'total_leads_provider' => $total_leads_provider,
                        'leadCount' => $leadCount,
                        'leadsTodayCount' => $leadsTodayCount,
                        'value' => $value,
                        'filterdate' => $filterdate,
                        'startdate' => $startdate,
                        'enddate' => $enddate

                    ],'leadlist');
                }

    }

    public function statusFilterdate(Request $request)
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $value = $request->value;
        $startdate  = $request->startdate;
        $enddate = $request->enddate;

                $leadCount = null;

                if($user->usertype_id == 2){

                    $dealers = User::select('users.id','users.first_name','users.last_name')
                        ->where('parent_user_id',$user->id)
                        ->where('approval','approve')
                        ->get();

                    $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('admin_email',$user->email)
                        ->where('archive_status',1)
                        ->where('lead_status',$value)
                        ->whereDate('leads.created_at','>=',$startdate)
                        ->whereDate('leads.created_at','<=',$enddate)
                        ->orderby('updated_at', 'desc');


                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$user->email)
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();
                    $leadCount = null;

                    $filterdate = null;
                    $startdate2 = null;
                    $enddate2 = null;

                    return $this->sendResponse([
                        'leads' => $leads ,
                        'dealers' => $dealers,
                        'total_leads_provider' => $total_leads_provider,
                        'leadCount' => $leadCount,
                        'leadsTodayCount' => $leadsTodayCount,
                        'value' => $value,
                        'filterdate' => $filterdate,
                        'startdate' => $startdate,
                        'enddate' => $enddate,
                        'startdate2' => $startdate2,
                        'enddate2' => $enddate2

                    ],'leadlist');

//                    return view('backend.pages.text.reportboxcount',compact('leads','dealers','total_leads_provider','leadCount','leadsTodayCount','value','startdate','enddate','filterdate','startdate2','enddate2'));
                }
                elseif($user->usertype_id == 4){

                    $users = User::where('id',$user->id)->first();
                    $getAdmin = User::where('id',$users->parent_user_id)->first();
                    $admin = Companyinfo::where('user_id',$users->parent_user_id)->first();

                    $dealers = User::select('users.*')
                        ->where('parent_user_id',$getAdmin->id)
                        ->where('approval','approve')
                        ->get();

                    $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('admin_email',$getAdmin->email)
                        ->where('archive_status',1)
                        ->where('lead_status',$value)
                        ->whereDate('leads.created_at','>=',$startdate)
                        ->whereDate('leads.created_at','<=',$enddate)
                        ->orderby('updated_at', 'desc');

                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$getAdmin->email)
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();
                    $leadCount = null;

                    $filterdate = null;
                    $startdate2 = null;
                    $enddate2 = null;

                    return $this->sendResponse([
                        'leads' => $leads ,
                        'dealers' => $dealers,
                        'total_leads_provider' => $total_leads_provider,
                        'leadCount' => $leadCount,
                        'leadsTodayCount' => $leadsTodayCount,
                        'value' => $value,
                        'filterdate' => $filterdate,
                        'startdate' => $startdate,
                        'enddate' => $enddate,
                        'startdate2' => $startdate2,
                        'enddate2' => $enddate2

                    ],'leadlist');

//                    return view('backend.pages.text.reportboxcount',compact('leads','dealers','total_leads_provider','leadCount','leadsTodayCount','value','startdate','enddate','filterdate','startdate2','enddate2'));
                }

    }

    public function statusFilterdate_level2(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $value = $request->value;
        $startdate2 = $request->startdate;
        $enddate2 =   $request->enddate;

                $leadCount = null;

                if($user->usertype_id == 2){

                    $dealers = User::select('users.id','users.first_name','users.last_name')
                        ->where('parent_user_id',$user->id)
                        ->where('approval','approve')
                        ->get();


                    $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('admin_email',$user->email)
                        ->where('archive_status',1)
                        ->where('lead_status',$value)
                        ->whereDate('leads.updated_at','>=',$startdate2)
                        ->whereDate('leads.updated_at','<=',$enddate2)
                        ->orderby('updated_at', 'desc');


                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$user->email)
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();
                    $leadCount = null;
                    $filterdate = null;
                    $startdate = null;
                    $enddate = null;


                    return $this->sendResponse([
                        'leads' => $leads ,
                        'dealers' => $dealers,
                        'total_leads_provider' => $total_leads_provider,
                        'leadCount' => $leadCount,
                        'leadsTodayCount' => $leadsTodayCount,
                        'value' => $value,
                        'filterdate' => $filterdate,
                        'startdate' => $startdate,
                        'enddate' => $enddate,
                        'startdate2' => $startdate2,
                        'enddate2' => $enddate2

                    ],'leadlist');

//                    return view('backend.pages.text.reportboxcount',compact('leads','dealers','total_leads_provider','leadCount','leadsTodayCount','value','startdate2','enddate2','filterdate','startdate','enddate'));
                }
                elseif($user->usertype_id == 4){

                    $users = User::where('id',$user->id)->first();
                    $getAdmin = User::where('id',$users->parent_user_id)->first();
                    $admin = Companyinfo::where('user_id',$users->parent_user_id)->first();

                    $dealers = User::select('users.id','users.first_name','users.last_name')
                        ->where('parent_user_id',$getAdmin->id)
                        ->where('approval','approve')
                        ->get();


                    $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('admin_email',$getAdmin->email)
                        ->where('archive_status',1)
                        ->where('lead_status',$value)
                        ->whereDate('leads.updated_at','>=',$startdate2)
                        ->whereDate('leads.updated_at','<=',$enddate2)
                        ->orderby('updated_at', 'desc');


                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$getAdmin->email)
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();
                    $leadCount = null;
                    $filterdate = null;
                    $startdate = null;
                    $enddate = null;

                    return $this->sendResponse([
                        'leads' => $leads ,
                        'dealers' => $dealers,
                        'total_leads_provider' => $total_leads_provider,
                        'leadCount' => $leadCount,
                        'leadsTodayCount' => $leadsTodayCount,
                        'value' => $value,
                        'filterdate' => $filterdate,
                        'startdate' => $startdate,
                        'enddate' => $enddate,
                        'startdate2' => $startdate2,
                        'enddate2' => $enddate2

                    ],'leadlist');

//                    return view('backend.pages.text.reportboxcount',compact('leads','dealers','total_leads_provider','leadCount','leadsTodayCount','value','startdate2','enddate2','filterdate','startdate','enddate'));
                }


    }

    public function leadReportPDF(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                $value = $request->value;
                $filterdate = $request->filterdate;

                $leadCount = null;


                if($user->usertype_id == 2){

                    if($filterdate == 'today'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.created_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc')->get();
                    }
                    elseif($filterdate == 'today2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.updated_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc')->get();
                    }
                    elseif($filterdate == 'week'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc')->get();
                    }
                    elseif($filterdate == 'week2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$user->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc')->get();
                    }


                    $leadsTodayCount = $leadList->count();


                    $leadCount = null;

                    return $this->sendResponse([
                        'leadList' => $leadList ,
                    ],'leadlist');

//                    return view('backend.pages.reports.kpileadexport',compact('leadList','total_leads_provider','leadCount','leadsTodayCount','value','filterdate'));


                }
                elseif($user->usertype_id == 4){
                    $getUser = User::where('id',$user->id)->first();
                    $getAdmin = User::where('id',$getUser->parent_user_id)->first();

                    if($filterdate == 'today'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.created_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc')->get();
                    }
                    elseif($filterdate == 'today2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('leads.updated_at',date("Y-m-d"))
                            ->orderby('updated_at', 'desc')->get();
                    }
                    elseif($filterdate == 'week'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc')->get();
                    }
                    elseif($filterdate == 'week2'){

                        $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                            ->where('admin_email',$getAdmin->email)
                            ->where('archive_status',1)
                            ->where('lead_status',$value)
                            ->whereDate('updated_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('updated_at','<=',date('Y-m-d'))
                            ->orderby('updated_at', 'desc')->get();
                    }


                    $leadsTodayCount = $leadList->count();


                    $leadCount = null;

                    return $this->sendResponse([
                        'leadList' => $leadList ,
                    ],'leadlist');

//                    return view('backend.pages.reports.kpileadexport',compact('leadList','total_leads_provider','leadCount','leadsTodayCount','value','filterdate'));

                }

    }

    public function customLeadReportdownload(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $value = $request->value;
        $startdate = $request->startdate;
        $enddate = $request->enddate;
        
                $leadCount = null;

                if($user->usertype_id == 2){

                    $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                        ->where('admin_email',$user->email)
                        ->where('archive_status',1)
                        ->where('lead_status',$value)
                        ->whereDate('leads.created_at','>=',$startdate)
                        ->whereDate('leads.created_at','<=',$enddate)
                        ->orderby('updated_at', 'desc')->get();

                    $leadsTodayCount = $leadList->count();

                    $leadCount = null;

                    $filterdate = null;


                    return $this->sendResponse([
                        'leadList' => $leadList ,
                    ],'leadlist');

//                    return view('backend.pages.reports.kpileadexport',compact('leadList','dealers','total_leads_provider','leadCount','leadsTodayCount','value','startdate','enddate','filterdate'));
                }
                elseif($user->usertype_id == 4){

                    $getUser = User::where('id',$user->id)->first();
                    $getAdmin = User::where('id',$getUser->parent_user_id)->first();

                    $leadList = Lead::select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.email','leads.lead_provider','leads.created_at','leads.updated_at','leads.contact as leadnumber')
                        ->where('admin_email',$getAdmin->email)
                        ->where('archive_status',1)
                        ->where('lead_status',$value)
                        ->whereDate('leads.created_at','>=',$startdate)
                        ->whereDate('leads.created_at','<=',$enddate)
                        ->orderby('updated_at', 'desc')->get();

                    $leadsTodayCount = $leadList->count();

                    $leadCount = null;

                    $filterdate = null;

                    return $this->sendResponse([
                        'leadList' => $leadList ,
                    ],'leadlist');

//                    return view('backend.pages.reports.kpileadexport',compact('leadList','dealers','total_leads_provider','leadCount','leadsTodayCount','value','startdate','enddate','filterdate'));
                }

    }

    public function chatFilters(Request $request)
    {

            $direction = $request->direction;
            $status = $request->status;
            $date_from = $request->date_from;
            $date_to = $request->date_to;
            $search_number = $request->search_number;
            $output = '';
            $lead = '';
            $limit = $request->page;

            if($request->date_from == $request->date_to)
            {
                $date_from = date('Y-m-d', strtotime($request->date_from));
                $date_to = date('Y-m-d', strtotime("+1 days",strtotime($request->date_to)));
            }
            else
            {
                $date_from = date('Y-m-d', strtotime($request->date_from));
                $date_to = date('Y-m-d', strtotime($request->date_to));
            }

            if($request->date_from != '' || $request->date_to != '')
            {
                $lead = Leadchat::whereDate('created_at','>=',$date_from)->where('created_at','<=',$date_to)->orderBy('id','desc');
            }
            else
            {
                $lead = Leadchat::orderBy('id','desc');
            }

            if($search_number != '')
            {
                $lead = Leadchat::where('from','LIKE','%'.$search_number.'%')->orwhere('to','LIKE','%'.$search_number.'%');
            }

            if($direction != '0')
            {
                $lead = Leadchat::where('type',$direction);
            }

            if($status == '0')
            {
                $lead = $lead;
            }
            elseif($status == 'Received')
            {
                $lead = $lead->where('type','received');
            }
            elseif($status == 'Delivered')
            {
                $lead = $lead->where('type','sent');
            }
            else
            {
                $lead = $lead->where('status','Undelivered');
            }

            $chat_logs = $lead->get();


        return $this->sendResponse([
            'Chat_log' => $chat_logs,
        ],'Chat_log');

//            return response()->json(['final' => $output, 'paginate' => $output2]);

    }
    
}