<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Mmsblast;
use App\Permissionallowed;
use App\Uploadblastlibrary;
use Illuminate\Support\Facades\Cache;
use App\Companyextranumber;
use App\Companyinfo;
use Validator;
use App\Blastpercentage;
use DB;
use App\Traits\PushNotificationTrait;

class MMSblastController extends BaseController{

    public function mmsblast(){
    

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        if($user->usertype_id == 2){

             $get_lead_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                        ->leftjoin('users as user_send','user_send.id','mms_blast.send_id')
                                        ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                        ->where('mms_blast.send_id',$user->id)
                                        ->OrWhere('user_send.parent_user_id',$user->id)
                                        ->orderby('id','desc')
                                        ->get();

            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            // $getagents = User::select('users.id','users.first_name','users.last_name')
            //     ->where('parent_user_id',$user->id)
            //     ->get();
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                                ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                ->where('parent_user_id',$user->id)
                                ->where('users.approval','approve')
                                ->where('users.is_deleted',0)
                                ->orderby('id','desc')
                                ->get();
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data);

            }

            $total_leads_provider = Lead::select('leads.lead_provider')
                                    ->where('leads.lead_provider','!=','')
                                    ->groupBy('lead_provider')
                                    ->selectRaw('count(*) as count, lead_provider')
                                    ->where('admin_email',$user->email)
                                    ->having('count','>=','1')
                                    ->orderby('leads.lead_provider','asc')
                                    ->get();


            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));

            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;

                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }

            return $this->sendResponse([
                'mms_blast_view' => $get_lead_blast,
                'total-lead' => $total_leads,
                'agents' => $agents,
                'total_lead_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,
                'start_date' => $startdate
                
            ],'mms_blast_view');
        }
        elseif ($user->usertype_id == 4){
            $get_admin_id = User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
            
            $get_lead_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
            ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
            ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
            ->where('mms_blast.send_id',$admin_name->id)
            ->OrWhere('mms_blast.assigned_id',$user->id)
            ->orderby('id','desc')
            ->get();

            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;

            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }

            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            $get_admin = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->first();

            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();
                
            $getdate = Lead::where('admin_email',$admin_name->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));
            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;

                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
            
            $total_leads_provider = Lead::select('leads.lead_provider')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->where('leads.lead_provider','!=','')
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
        }
       
        return $this->sendResponse([
            'mms_blast_view' => $get_lead_blast,
            'total-lead' => $total_leads,
            'agents' => $agents,
            'dedicated_number' => $dedicated_number,
            'total_lead_provider' => $total_leads_provider,
            'start_date' => $startdate
        ],'mms_blast_view');
    }

    public function mmsBlastImageFile(Request $request){


            $validator = Validator::make($request->all(), [
                'file' => 'required | mimes:jpeg,jpg,gif,png,mp4,webm | max:6000',
            ]);

            if ($validator->fails())
            {
                return response()->json([
                    'success' => false,
                    'type' => "nothing",
                    'link'   => "no"
                ],201);

                return $this->sendResponse([
                    'type' => "nothing",
                    'message' => "no"
                ],'mms_blast_image_upload');
            }
            else
            {
                $image = $request->file('file');
                $new_name = rand() . '.' . $image->getClientOriginalExtension();
                $imagepath = $image->move('./asset/chat-assets/images/mms', $new_name);
                $path = $new_name;
                $completePath = url('/').'/asset/chat-assets/images/mms/'.$path;

                $final_type = null;
                $headers = get_headers($completePath, 1);
                if (strpos($headers['Content-Type'], 'image/') !== false) {
                    $final_type = 'image';
                } else {
                    $final_type = 'video';
                }

                return response()->json([
                    'success' => true,
                    'type' => $final_type,
                    'link' => $completePath
                ],200);
                // return $this->sendResponse([
                //     'type' => $final_type,
                //     'message' => $completePath
                // ],'mms_blast_image_upload');
            }

    }

    public function mmsBlastPost(Request $request){


            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();



            $drafted = null;
            if($request->submit == 'draft')
            {
                $drafted = "no";
            }
            else
            {
                $drafted = "yes";
            }

            $date_from = date('Y-m-d', strtotime($request->schedule_time_from));
            $date_to = date('Y-m-d', strtotime($request->schedule_time_to));
            $time_from = ($request->order_time_from)? date('H:i:s', strtotime($request->order_time_from)):null;
            $time_to = ($request->order_time_to)? date('H:i:s', strtotime($request->order_time_to)):null;
            $mediaUrl = $request->mediaUrl;


            if($request->type == "All"){
                $type = 0 ;
            }
            else {
                $type = $request->type;
            }
            $sender_id  = null;
            $sender_id = $request->senderid;

        if($user->usertype_id == 2)
        {
            $is_admin = $user->id;
        }
        else
        {
            $is_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $is_admin = $is_admin->parent_user_id;
        }
        $data = [
            'user_id' => $is_admin,
            'file' => $mediaUrl,
            'type' => 'mms'
        ];

        Uploadblastlibrary::insert($data);

            if($request->assignedto != '' && $request->assignedto != 0)
            {
                $assign_agent_id = $request->assignedto;
            }
            else
            {
                $assign_agent_id = $user->id;
            } 

            $audienceValMax = 'no';
            if($request->audienceVal > 400)
            {
                $audienceValMax = $request->audienceVal;
            }

            $message_filter = date('m/d/Y', strtotime($request->schedule_time_from))." - ".date('m/d/Y', strtotime($request->schedule_time_to));

            $target_status = explode(',',$request->target_status);
            $target_status_seperator = implode(', ', $target_status);

            $provider = explode(',',$request->leadprovider);
            $leadprovider =  implode(', ', $provider);

            $number_length_home = strlen($request->send_from_number_val);
            if($number_length_home == 10){
                $request->send_from_number_val = '+1'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 11){
                $request->send_from_number_val = '+'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 12) {
                $request->send_from_number_val = trim($request->send_from_number_val);
            }

            $blast = [
                'campaign_name' => $request->campaign_name,
                'campaign_number' => $request->send_from_number_val,
                'send_limit' => $request->audienceVal,
                'send_at' => $request->sendat,
                'lead_provider' => $leadprovider,
                'message_filter' => $message_filter,
                'save_template'  => $request->save_as_template,
                'message_status' => 'Pending',
                'type' => $type,
                'target_status' => $target_status_seperator,
                'message_description' => $request->messagedescription. " Reply STOP to Opt-Out.",
                'mms_attachments' => $mediaUrl,
                'assigned_id' => $assign_agent_id,
                'send_id' => $sender_id,
                'date_from' => $date_from,
                'date_to' => $date_to,
                'blast_created_id'=>$user->id,
                'max_blast' => $audienceValMax,
                'is_activated' => $drafted
            ];

            $insert_lead_blast = Mmsblast::insertGetId($blast);
                
            if($user->usertype_id == 2)
            {
                $titleN      =  'New MMS Blast Created By '.$user->first_name;
                $titleAdmin  =  'New MMS Blast Created By You';
                $total_agent_ids = DB::table('users')->select(['id'])->where('parent_user_id', $user->id)->where("usertype_id", 4)->where("approval", "approve")->whereNotNull('device_token')->pluck("id");
                $user_ids = $total_agent_ids;
                
                PushNotificationTrait::PushNotificationFirebaseSend($user_ids, $titleN, $request->campaign_name,$insert_lead_blast,'mms_blast');
                PushNotificationTrait::PushNotificationFirebaseSend([$user->id], $titleAdmin, $request->campaign_name,$insert_lead_blast,'mms_blast');
                
            }elseif($user->usertype_id == 4){
                
                $titleN  =  'New MMS Blast Created By You';
                $titleAdmin  =  'New MMS Blast Created By '.$user->first_name;
                $total_agent_ids = DB::table('users')->select(['id'])->where('id', $user->id)->where("usertype_id", 4)->where("approval", "approve")->whereNotNull('device_token')->pluck("id");
                $user_ids = $total_agent_ids;
            
                PushNotificationTrait::PushNotificationFirebaseSend($user_ids, $titleN, $request->campaign_name,$insert_lead_blast,'mms_blast');
                PushNotificationTrait::PushNotificationFirebaseSend([$is_admin], $titleAdmin, $request->campaign_name,$insert_lead_blast,'mms_blast');
                
            }
            
            $this->blastPercentage($insert_lead_blast);

            if($insert_lead_blast){

                return response()->json([
                    'success' => true,
                    'message' => 'Blast added successfully',
                ],200);
            }
            else{
                return response()->json([
                    'success' => false,
                    'message' => 'Something went wrong',
                ],401);
            }
    }

    public function mmsBlastUpdate(Request $request)
    {

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

//            $validator = Validator::make($request->all(), [
//                'editmediaUrl' => 'required | mimes:jpeg,jpg,gif,png,mp4,webm | max:6000',
//            ]);
//
//            if ($validator->fails())
//            {
//                return $this->sendResponse([
//                    'type' => "nothing",
//                    'message' => "no"
//                ],'mms_blast_image_upload');
//            }
//            else
//            {
//                $image = $request->file('editmediaUrl');
//                $new_name = rand() . '.' . $image->getClientOriginalExtension();
//                $imagepath = $image->move('./asset/chat-assets/images/mms', $new_name);
//                $path = $new_name;
//                $completePath = url('/').'/asset/chat-assets/images/mms/'.$path;
//            }


            $drafted = null;

            if($request->submit == 'draft')
            {
                $drafted = "no";
            }
            else
            {
                $drafted = "yes";
            }

            $validate = $request->validate([
                'editsendat' => 'required',
                'editleadprovider' => 'required',
                'edittype' => 'required',
                'edittarget_status' => 'required',
                'schedule_time_from_edit' => 'required',
                'schedule_time_to_edit' => 'required',

            ]);
            if($request->edittype == "All"){
                $type = 0 ;
            }
            else {
                $type = $request->edittype;
            }
            $audienceValMax = 'no';
            if($request->editaudienceVal > 400)
            {
                $audienceValMax = $request->editaudienceVal;
            }

            $date_from = date('Y-m-d', strtotime($request->schedule_time_from_edit));
            $date_to = date('Y-m-d', strtotime($request->schedule_time_to_edit));
            $time_from = ($request->order_time_from_edit)? date('H:i:s', strtotime($request->order_time_from_edit)):null;
            $time_to = ($request->order_time_to_edit)? date('H:i:s', strtotime($request->order_time_to_edit)):null;
            $mediaUrl = $request->editmediaUrl;
        if($user->usertype_id == 2)
        {
            $is_admin = $user->id;
        }
        else
        {
            $is_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $is_admin = $is_admin->parent_user_id;
        }
        $data = [
            'user_id' => $is_admin,
            'file' => $mediaUrl,
            'type' => 'mms'
        ];
        Uploadblastlibrary::insert($data);

            $sender_id = $request->editsenderid;
            $message_filter = date('m/d/Y', strtotime($request->schedule_time_from_edit))." - ".date('m/d/Y', strtotime($request->schedule_time_to_edit));

            $assign_agent_id = $request->editassignedto;

            if($user->usertype_id == 2)
            {
                if($request->editassignedto != '' && $request->editassignedto != 0)
                {
                    $assign_agent_id = $request->editassignedto;

                }
                else
                {
                    $assign_agent_id = $user->id;
                }

                $sender_id = $user->id;
            }


            $target_status = explode(',',$request->edittarget_status);
            $target_status_seperator = implode(', ', $target_status);

            $provider = explode(',',$request->editleadprovider);
            $leadprovider =  implode(', ', $provider);

//            $request->send_from_number_val = str_replace('(','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace(')','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace('-','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace(' ','',$request->send_from_number_val);

            $number_length_home = strlen($request->send_from_number_val);
            if($number_length_home == 10){
                $request->send_from_number_val = '+1'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 11){
                $request->send_from_number_val = '+'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 12) {
                $request->send_from_number_val = trim($request->send_from_number_val);
            }

            $blast = [
                'campaign_name' => $request->campaign_name,
                'campaign_number' => $request->send_from_number_val,
                'send_limit' => $request->editaudienceVal,
                'send_at' => $request->editsendat,
                'lead_provider' => $leadprovider,
                'message_filter' => $message_filter,
                'message_status' => 'Pending',
                'save_template'  => $request->save_as_template,
                'type' => $type,
                'target_status' => $target_status_seperator,
                'message_description' => $request->editmessagedescription,
                'mms_attachments' => $mediaUrl,
                'assigned_id' => $assign_agent_id,
                'send_id' => $sender_id,
                'date_from' =>$date_from,
                'date_to' => $date_to,
                'blast_created_id'=>$user->id,
                'max_blast' => $audienceValMax,
                "is_activated" => $drafted
            ];


            $insert_lead_blast = Mmsblast::where('id',$request->editleadblastid)->update($blast);

            $this->blastPercentage($request->editleadblastid);

            if($insert_lead_blast){
                return response()->json([
                    'success' => true,
                    'message' => 'MMs blast Updated successfully',
                ],200);
               
            }
            else{
                 return response()->json([
                    'success' => false,
                    'message' => 'Something went wrong',
                ],401);
               
            }

    }


    public function blastPercentage($blast_id)
    {
        $admin_id = null;
        $get_lead_blast = Mmsblast::select('mms_blast.*','users.id as user_id','users.usertype_id as usertype_id')
            ->leftjoin('users','users.id','mms_blast.send_id')
            ->where('mms_blast.id',$blast_id)
            ->get();

        if($get_lead_blast->count() > 0)
        {
            foreach ($get_lead_blast as $leadblast) {
                $splitStatus = explode(', ', $leadblast->target_status);
                $splitDate = explode(' - ', $leadblast->message_filter);

                $startdate = date("Y-m-d", strtotime($splitDate[0]));
                $enddate = date("Y-m-d", strtotime($splitDate[1]));

                if($leadblast->usertype_id == 2){
                    $get_admin_email = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $leadblast->user_id;

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->where('lead_provider',$leadblast->lead_provider)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }
                    else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }
                }
                else{
                    $get_agent = User::where('id',$leadblast->user_id)->first();

                    $admin_id = $get_agent->parent_user_id;
                    $get_admin_email = User::where('id',$get_agent->parent_user_id)->first();

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->where('lead_provider',$leadblast->lead_provider)
             
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }
                }

                $leads_id = array();
                $count = 1;
                foreach($leads as $lead){

                    for($i = 0; $i < count($splitStatus); $i++){

                        $leads_id[] .= $lead->id;

                    }
                    $count++;

                }

                $check_blast_exist = Blastpercentage::where('blast_id',$blast_id)->where('blast_type','mms')->first(['blast_id']);
                $check_blast_mms_exist = DB::table('blast_leads')->where('blast_id',$blast_id)->where('blast_type','mms')->first(['blast_id']);
                if($check_blast_exist == null)
                {
                    Blastpercentage::insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'mms', 'leads_id' => implode(",",$leads_id)]);
                }
                else
                {
                    Blastpercentage::where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                }
                
                if($check_blast_mms_exist == null)
                {
                    DB::table('blast_leads')->insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'mms', 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }
                else
                {
                    DB::table('blast_leads')->where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }


            }
        }
    }

    public function mmsBlastDelete(Request $request){

                $check_lead_blast = Mmsblast::where('id',$request->leadblastid)
                    ->delete();

                Blastpercentage::where('blast_id',$request->leadblastid)->where('blast_type','mms')->delete();

                if($check_lead_blast){
                    return response()->json([
                        'success' => true,
                        'message' => 'MMS Blast Remove Successfully',
                    ],200);

                }
                else{

                    return response()->json([
                        'success' => false,
                        'message' => 'Something went wrong while deleting',
                    ],422);

                }

    }
    
    public function mmsAttachments(){
    

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        if($user->usertype_id == 2){
             $get_lead_blast = Mmsblast::select('mms_blast.mms_attachments')
                                        ->leftjoin('users as user_send','user_send.id','mms_blast.send_id')
                                        ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                        ->where('mms_blast.send_id',$user->id)
                                        ->OrWhere('user_send.parent_user_id',$user->id)
                                        ->orderby('mms_blast.id','desc')
                                        ->get();
        }elseif($user->usertype_id == 4){
            $admin  = User::where('id',$user->parent_user_id)->first();
            $admin_name = User::where('id',$admin->parent_user_id)->first();
            $get_lead_blast = Mmsblast::select('mms_blast.mms_attachments')
                                        ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                        ->where('mms_blast.send_id',$admin_name->id)
                                        ->OrWhere('mms_blast.assigned_id',$user->id)
                                        ->orderby('mms_blast.id','desc')
                                        ->get();
        }
        
        return $this->sendResponse([
                'MMS-attachments' => $get_lead_blast,
            ],'Attachmens');
    }
    
    public function savedTemplats(){
    

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        if($user->usertype_id == 2){

             $get_lead_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.save_template','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                        ->leftjoin('users as user_send','user_send.id','mms_blast.send_id')
                                        ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                        ->where('save_template','yes')
                                        ->where('mms_blast.send_id',$user->id)
                                        ->OrWhere('user_send.parent_user_id',$user->id)
                                        ->orderby('id','desc')
                                        ->get();

            $total_leads = Lead::where('admin_email',$user->email)
                                        ->where('lead_status','Active-Fresh')
                                        ->count('*');

            // $getagents = User::select('users.id','users.first_name','users.last_name')
            //     ->where('parent_user_id',$user->id)
            //     ->get();
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                                        ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                        ->where('parent_user_id',$user->id)
                                        ->where('users.approval','approve')
                                        ->where('users.is_deleted',0)
                                        ->orderby('id','desc')
                                        ->get();
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data);

            }

            $total_leads_provider = Lead::select('leads.lead_provider')
                                    ->where('leads.lead_provider','!=','')
                                    ->groupBy('lead_provider')
                                    ->selectRaw('count(*) as count, lead_provider')
                                    ->where('admin_email',$user->email)
                                    ->having('count','>=','1')
                                    ->orderby('leads.lead_provider','asc')
                                    ->get();


            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));

            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;

                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }

            return $this->sendResponse([
                        'mms_saved_templates' => $get_lead_blast,
                        'total-lead' => $total_leads,
                        'agents' => $agents,
                        'total_lead_provider' => $total_leads_provider,
                        'dedicated_number' => $dedicated_number,
                        'start_date' => $startdate
                        
                    ],'mms_saved_templates');
        }
        elseif ($user->usertype_id == 4){
            
            $get_admin_id = User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
            
            $get_all_agent_list = array($get_admin_id->parent_user_id);
    
            $get_all_agents = User::where('parent_user_id',$get_admin_id->parent_user_id)->get(['id']);
    
            foreach($get_all_agents as $get_all_agents)
            {
                $get_all_agent_list[] .= $get_all_agents->id;
            }
            $get_lead_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.save_template','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                        ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                        ->where('save_template','yes')
                                        ->whereIn('mms_blast.assigned_id',$get_all_agent_list)
                                        ->orderby('id','desc')
                                        ->get();

            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;

            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }
            
            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            
            $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

            $dedicated_number = $get_dedicated_number->phone_number;
            if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
            {
                $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
            }

            $total_leads = Lead::where($assigned_column,$assigned_agents)
                                    ->where('lead_status','Active-Fresh')
                                    ->count('*');

            $get_admin = User::select('id','first_name','last_name')
                                    ->where('id',$user->id)
                                    ->first();

            $agents = User::select('id','first_name','last_name')
                                    ->where('users.approval','approve')
                                    ->where('parent_user_id',$user->parent_user_id)
                                    ->get();

            $total_leads_provider = Lead::select('leads.lead_provider')
                                        ->groupBy('lead_provider')
                                        ->selectRaw('count(*) as count, lead_provider')
                                        ->where($assigned_column,$assigned_agents)
                                        ->where('leads.lead_provider','!=','')
                                        ->having('count','>=','1')
                                        ->orderby('leads.lead_provider','asc')
                                        ->get();
        }
       
         return $this->sendResponse([
                        'mms_saved_templates' => $get_lead_blast,
                        'total-lead' => $total_leads,
                        'agents' => $agents,
                        'total_lead_provider' => $total_leads_provider,
                        'dedicated_number' => $dedicated_number,
                     ],'mms_saved_templates');
    }
    
    public function mmsDraft(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        if($user->usertype_id == 2){

             $get_lead_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
            ->leftjoin('users as user_send','user_send.id','mms_blast.send_id')
            ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
            ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
            ->where('message_status','Pending')
            ->where('is_activated','no')
            ->where('mms_blast.send_id',$user->id)
            ->OrWhere('user_send.parent_user_id',$user->id)
            ->orderby('id','desc')
            ->get();

            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            // $getagents = User::select('users.id','users.first_name','users.last_name')
            //     ->where('parent_user_id',$user->id)
            //     ->get();
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
            ->leftjoin('usertypes','usertypes.id','users.usertype_id')
            ->where('parent_user_id',$user->id)
            ->where('users.approval','approve')
            ->where('users.is_deleted',0)
            ->orderby('id','desc')
            ->get();
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data);

            }

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where('admin_email',$user->email)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();


            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));

            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;

                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }

            return $this->sendResponse([
                'mms_blast_draft' => $get_lead_blast,
                'total-lead' => $total_leads,
                'agents' => $agents,
                'total_lead_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,
                'start_date' => $startdate
                
            ],'mms_blast_draft');
        }
        elseif ($user->usertype_id == 4){
            $get_admin_id = User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
            
            $get_lead_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
            ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
            ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
            ->where('message_status','Pending')
            ->where('is_activated','no')
            ->where('mms_blast.send_id',$admin_name->id)
            ->OrWhere('mms_blast.assigned_id',$user->id)
            ->orderby('id','desc')
            ->get();

            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;

            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }

            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            $get_admin = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->first();

            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->where('leads.lead_provider','!=','')
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
        }
       
         return $this->sendResponse([
         'mms_blast_draft' => $get_lead_blast
         ],'mms_blast_draft');
    }
}
