<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\LeadAppointment;
use App\Leadblast;
use App\Mmsblast;
use App\Permissionallowed;
use App\Blastpercentage;
use App\Companyinfo;
use App\Companyextranumber;
use App\Usertype;
use App\Departments;
use App\Permissiontype;
use App\Userimportlimit;
Use App\Userreportingdetail;
use App\Assigndepartment;
use App\Permissionnotification;
use Validator;
use DB;
use Illuminate\Support\Facades\Cache;



class UserController extends BaseController{

    public function usersView(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            if($user->usertype_id == 2){
                $user_data = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number','users.status','users.usertype_id','users.is_deleted','usertypes.name as usertype')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->where('parent_user_id',$user->id)
                    ->orderby('id','desc')
                    ->get();

                $check_data = $user_data->count();
                if($check_data > 0){
                    foreach($user_data as $rows){

                        $user_records[] = array(
                            "id" => $rows->id,
                            "first_name" => $rows->first_name,
                            "last_name" => $rows->last_name,
                            "email" => $rows->email,
                            "phone_number" => $rows->phone_number,
                            "status" => $rows->status,
                            "usertype_id" => $rows->usertype_id,
                            "usertype" => $rows->usertype,
                            "is_deleted" => $rows->is_deleted
                        );
                    }
                }
                else{
                    $user_records = [];
                }

                return $this->sendResponse([
                    'user_record' => $user_records,
                ],'user_record');

//                return view('backend.pages.account.users.users',compact('user_records'));
            }

    }

    public function addUserView(){

            $userroles = Usertype::select('usertypes.id','usertypes.name')->get();
            $groups = Departments::select('departments.id','departments.name')->get();
            $permissions = Permissiontype::select('permission_types.id','permission_types.name')->get();

            return $this->sendResponse([
                'User_roles' => $userroles,
                'departments' => $groups,
                'permission'=> $permissions,
            ],'Add_user_view');

    }

    public function addUser(Request $request){



            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

//           $userdatajson =  array(json_decode($request->userdata));


           
            $number_length_home = strlen($request->phone);
            if($number_length_home == 10){
                $request->phone = '+1'.trim($request->phone);
            }
            elseif ($number_length_home == 11){
                $request->phone = '+'.trim($request->phone);
            }
            elseif ($number_length_home == 12) {
                $request->phone = trim($request->phone);
            }
            $phone_number = $request->phone;

            $validator = Validator::make($request->all(), [
                'firstname' => 'string|required|min:3|max:40',
                'lastname' => 'string|required|min:3|max:40',
                'email' => 'required|email:rfc,dns|unique:users,email',
                "password" => 'string|required|min:8|max:40',
                'phone' => 'string|required|min:10|max:10',
                "roleid" => 'required',
                "timezone" =>'required',
                "statusid" => 'required',
            ]);

            if ($validator->fails()) {
                $success = [
                    'add_user' => $validator->messages()->all()[0],
                    'success' => 'false',
                ];
                return $this->sendResponse([
                    'data' => $success,
                ],'add_user');
            }

            $userdata = [];
            $account_status_approved = null;
            if($request->statusid == 1)
            {
                $account_status_approved = 'pending';
            }
            else
            {
                $account_status_approved = 'approve';
            }
            if($user->usertype_id == 2){
                $userdata = [
                    "first_name" => $request->firstname,
                    "last_name" => $request->lastname,
                    "email" => $request->email,
                    "password" => sha1($request->password),
                    "phone_number" => $phone_number,
                    "status" => $request->statusid,
                    "timezone"=>$request->timezone,
                    "approval" => $account_status_approved,
                    "is_deleted" => $request->statusid,
                    "parent_user_id" => $user->id,
                    "usertype_id" => $request->roleid,
                    "agent_type" => $request->agent_type,
                ];
            }
            $getuserid = User::insertGetId($userdata);

//            if($request->officialadminnumber != null){
//                $crm_phone = $request->officialadminnumber;
//                $crm_phone = str_replace('(','',$crm_phone);
//                $crm_phone = str_replace(')','',$crm_phone);
//                $crm_phone = str_replace('-','',$crm_phone);
//                $crm_phone = str_replace(' ','',$crm_phone);
//                Companyinfo::insert(['phone_number' => $crm_phone, 'user_id' => $getuserid]);
//            }

//            if($userdatajson[0] != null)
//            {
//                foreach ($userdatajson[0] as $row) {
//                    $department = [
//                        "department_id" => $row,
//                        "user_id" => $getuserid,
//                    ];
//
//                    $add_depart = Assigndepartment::insert($department);
//
//                }
//            }

//            $user_imports = [
//                'user_id' => $getuserid,
//                'limited_import'  => 0,
//                'bulk_limit' => 0,
//                'text_blast_limit' => 0,
//                'count' => 0,
//                'bulk_run' => 'no'
//            ];
//            Userimportlimit::insert($user_imports);

        $department = [
                "department_id" => 1,
                "user_id" => $getuserid,
            ];

            $add_depart = Assigndepartment::insert($department);

        if ($request->leadstatusid == null || $request->leadstatusid == ''){
            $leadstatusid = 0;
        }
        else{
            $leadstatusid = $request->leadstatusid;
        }
        if ($request->messagestatusid == null || $request->messagestatusid == ''){
            $messagestatusid = 0;
        }
        else{
            $messagestatusid = $request->messagestatusid;
        }
        if ($request->tagsstatusid == null || $request->tagsstatusid == ''){
            $tagsstatusid = 0;
        }
        else{
            $tagsstatusid = $request->tagsstatusid;
        }
        if ($request->dailystatusid == null || $request->dailystatusid == ''){
            $dailystatusid = 0;
        }
        else{
            $dailystatusid = $request->dailystatusid;
        }
        if ($request->monthlystatusid == null || $request->monthlystatusid == ''){
            $monthlystatusid = 0;
        }
        else{
            $monthlystatusid = $request->monthlystatusid;
        }


            $notification = [
                "lead" => $leadstatusid,
                "message" => $messagestatusid,
                "tags" => $tagsstatusid,
                "daily_reports" => $dailystatusid,
                "monthly_reports" => $monthlystatusid,
                "user_id" => $getuserid,
            ];

            $add_notification_permission = Permissionnotification::insert($notification);
       
            if($getuserid){
                
                return response()->json([
                        'success' => true,
                        'message' => 'User added successfully',
                    ],200);

            }
            else{
                return response()->json([
                        'success' => false,
                        'message' => 'Something went wrong',
                    ],201);
            }
    }

    public function editUserView(Request $request)
    {

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $id = $request->id;
        
            $userroles = Usertype::select('usertypes.id','usertypes.name')->get();
            $groups = Departments::select('departments.id','departments.name')->get();
            $permissions = Permissiontype::select('permission_types.id','permission_types.name')->get();

//            dd($permissions->toArray());

            $get_user = User::select('users.activity_status','users.id','users.payment_method','users.agent_type','users.first_name','users.last_name','users.email','users.phone_number','users.approval','users.timezone','users.is_deleted as status','users.is_master','users.master_admin_id','users.master_agent_id','users.usertype_id','users.industry','permission_notifications.lead as lead_status','permission_notifications.message as message_status','permission_notifications.tags as tags_status','permission_notifications.daily_reports as daily_status','permission_notifications.monthly_reports as monthly_status')
                ->leftjoin('permission_notifications','permission_notifications.user_id','users.id')
                ->where('users.id',$id)
                ->get();

            $get_department = Assigndepartment::select('department_id')
                ->where('user_id',$id)
                ->get();

            $company = Companyinfo::where('user_id',$id)
                ->first();

            $user_limits = Userimportlimit::where('user_id',$id)->first();

            $getAllMasterAdmins = User::where('is_master','yes')->where('usertype_id',2)->get();

            $getAllMasterAgents = User::where('is_master','yes')->where('usertype_id',4)->where('parent_user_id',$user->id)->get();

            $getninja = User::where('usertype_id',7)->get();

//            $assignedninga = DB::table('ninja_assign')->where('user_id',$id)->where('assign_status','yes')->get();

//            $number_type = DB::connection("mysql2")->table('auto_recharge')->where('user_id',$id)->first();

            $deal_status = Permissionallowed::where('user_id',$id)->first(['lead_deal_status','lead_structure']);

            return $this->sendResponse([
                    'groups' => $groups,
                    'permissions' => $permissions,
                    'get_user' => $get_user,
                    'get_department' => $get_department,
                    'getAllMasterAdmins' => $getAllMasterAdmins,

            ],'edit_user_view');

            }

    public function editUser(Request $request){

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
//            $userdatajson =  array(json_decode($request->userdata));


            $number_length_home = strlen($request->phone);
            if($number_length_home == 10){
                $request->phone = '+1'.trim($request->phone);
            }
            elseif ($number_length_home == 11){
                $request->phone = '+'.trim($request->phone);
            }
            elseif ($number_length_home == 12) {
                $request->phone = trim($request->phone);
            }
            $phone_number = $request->phone;

//            $userdata = [];

            if($user->usertype_id == 2)
            {
                $validator = Validator::make($request->all(), [
                    'firstname' => 'string|required|min:3|max:40',
                    'lastname' => 'string|required|min:3|max:40',
                    'email' => 'required|email:rfc,dns',
                    'phone' => 'string|required|min:12|max:12',

                ]);

                if ($validator->fails()) {
//                    toastr()->error($validator->messages()->all()[0]);
//                    return back()->withInput();
                    return $this->sendResponse([
                        'add_user' => $validator->messages()->all()[0],
                    ],'add_user');
                }
                $userdata = [
                    "first_name" => $request->firstname,
                    "last_name" => $request->lastname,
                    "email" => $request->email,
                    "phone_number" => $phone_number,
                    "is_deleted" => $request->statusid,
                    "is_master" => 'no',
                    "parent_user_id" => $user->id,
                    "usertype_id" => $request->roleid,
                    "agent_type" => $request->agent_type,

                ];

//                if(!empty($request->master_agent)){
//                    $userdata['master_agent_id'] = $request->master_agent;
//                }else{
//                    $userdata['master_agent_id'] = NULL;
//                }
            }

            $update_user = User::where('id',$request->userid)
                ->update($userdata);


//            $delete_department = Assigndepartment::where('user_id',$request->userid)
//                ->delete();
//            if(!empty($userdatajson[0])){
//                foreach ($userdatajson[0] as $row) {
//                    $department = [
//                        "department_id" => $row,
//                        "user_id" => $request->userid,
//                    ];
//
//                    $add_depart = Assigndepartment::insert($department);
//                }
//            }

       

        if ($request->leadstatusid == null || $request->leadstatusid == ''){
            $leadstatusid = 0;
        }
        else{
            $leadstatusid = $request->leadstatusid;
        }
        if ($request->messagestatusid == null || $request->messagestatusid == ''){
            $messagestatusid = 0;
        }
        else{
            $messagestatusid = $request->messagestatusid;
        }
        if ($request->tagsstatusid == null || $request->tagsstatusid == ''){
            $tagsstatusid = 0;
        }
        else{
            $tagsstatusid = $request->tagsstatusid;
        }
        if ($request->dailystatusid == null || $request->dailystatusid == ''){
            $dailystatusid = 0;
        }
        else{
            $dailystatusid = $request->dailystatusid;
        }
        if ($request->monthlystatusid == null || $request->monthlystatusid == ''){
            $monthlystatusid = 0;
        }
        else{
            $monthlystatusid = $request->monthlystatusid;
        }

            $notification = [
                "lead" => $leadstatusid,
                "message" => $messagestatusid,
                "tags" => $tagsstatusid,
                "daily_reports" => $dailystatusid,
                "monthly_reports" => $monthlystatusid,
            ];

            $update_notification_permission = Permissionnotification::where('user_id',$request->userid)
                ->update($notification);


            if($update_notification_permission){
                return response()->json([
                        'success' => true,
                        'message' => 'Update successfully',
                    ],200);

        }
            else{
                return response()->json([
                        'success' => false,
                        'message' => 'Something Went Wrong',
                    ],201);
                    
        }


    }

    public function reportUpdate(Request $request)
    {

          $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

          $update =   User::where('id',$user->id)->where('usertype_id',2)->update(['activity_status' => $request->daily_report]);

            if($update){
                return response()->json([
                        'success' => true,
                        'message' => 'Notification Update Successfully'
                    ],200);
                
            }
            else{
                return response()->json([
                        'success' => false,
                        'message' => 'Something Went Wrong'
                    ],201);
               
            }

    }

    public function reportAdditionalDetail(Request $request)
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $phone_number = null;
            $email = null;
            $status = '';

            if($request->report_email != '')
            {
                $validator_email = Validator::make($request->all(), [
                    "report_email" => 'email:rfc,dns',
                ]);

                if($validator_email->fails()){
                    $status = "Invalid Email Address";
                }
                else if($request->report_email)
                {
                    Userreportingdetail::insert(['user_id' => $user->id,'email' => $request->report_email]);
                    $status = "yes";
                }
                else{
                    $status = "Invalid Email Address";
                }

                return $this->sendResponse([
                    'phone' => null,
                    'email' => $request->report_email,
                    'staus' => $status
                ],'daily_report');


            }

            if($request->report_phone_number != '')
            {
                $validator_phone = Validator::make($request->all(), [
                    "report_phone_number" => 'min:12|max:17',
                ]);

                if ($validator_phone->fails()) {
                    $status = "Invalid Phone Number";
                }
                else if($request->report_email  || $request->report_phone_number)
                {
                    Userreportingdetail::insert(['user_id' => $user->id, 'phone_number' => $request->report_phone_number]);
                    $status = "yes";
                }
                else{
                    $status = "Invalid Phone Number";
                }

                return $this->sendResponse([
                    'phone' => $request->report_phone_number,
                    'email' => null,
                    'staus' => $status
                ],'daily_report');

            }
    }

}