<?php
namespace App\Http\Middleware;

use App\ApiKey;
use Closure;
use App\User;

class ApiMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $token = str_replace('Bearer ',"",$request->header('Authorization'));

//      $tokenValid = User::where('id',$request->user()->id)->where('api_token', $request->header('Authorization'))->first();
        $tokenValid = User::where('id',$request->user()->id)->where('api_token', $token)->first();

        if (!$tokenValid) {
            return response()->json('Unauthorized', 401);
        }

        return $next($request);
    }
}