<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Authy\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class ServiceOptions {
    /**
     * @param string $push Optional service level push factors configuration
     * @return CreateServiceOptions Options builder
     */
    public static function create(string $push = Values::NONE): CreateServiceOptions {
        return new CreateServiceOptions($push);
    }

    /**
     * @param string $friendlyName A human readable description of this resource.
     * @return UpdateServiceOptions Options builder
     */
    public static function update(string $friendlyName = Values::NONE): UpdateServiceOptions {
        return new UpdateServiceOptions($friendlyName);
    }
}

class CreateServiceOptions extends Options {
    /**
     * @param string $push Optional service level push factors configuration
     */
    public function __construct(string $push = Values::NONE) {
        $this->options['push'] = $push;
    }

    /**
     * The optional service level push factors configuration. If present it must be a json string with the following format: {"notify_service_sid": "ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"}
     *
     * @param string $push Optional service level push factors configuration
     * @return $this Fluent Builder
     */
    public function setPush(string $push): self {
        $this->options['push'] = $push;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Authy.V1.CreateServiceOptions ' . \implode(' ', $options) . ']';
    }
}

class UpdateServiceOptions extends Options {
    /**
     * @param string $friendlyName A human readable description of this resource.
     */
    public function __construct(string $friendlyName = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * A human readable description of this resource, up to 64 characters.
     *
     * @param string $friendlyName A human readable description of this resource.
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Authy.V1.UpdateServiceOptions ' . \implode(' ', $options) . ']';
    }
}