<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\LeadAppointment;
use App\Leadblast;
use App\Mmsblast;
use App\Emailblast;
use App\Voicemailblast;
use App\Permissionallowed;
use App\Blastpercentage;
use App\Companyinfo;
use App\Companyextranumber;
use DB;
use Validator;
use Illuminate\Support\Facades\Cache;
use App\Traits\PushNotificationTrait;


class SMSblastController extends BaseController{

    public function smsblast(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){// Admin Lead Blast
        
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.is_activated','lead_blast.blast_created_id','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                        ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                                        ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                                        ->where('lead_blast.send_id',$user->id)
                                        ->OrWhere('user_send.parent_user_id',$user->id)
                                        ->orderby('id','desc')
                                        ->get();
    
    
            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');
    
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                                ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                ->where('parent_user_id',$user->id)
                                ->where('users.approval','approve')
                                ->where('users.is_deleted',0)
                                ->orderby('id','desc')
                                ->get();
                
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);
    
            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];
    
                array_push($agents,$data);
    
            }
    
            $total_leads_provider = Lead::select('leads.lead_provider')
                                            ->where('leads.lead_provider','!=','')
                                            ->groupBy('lead_provider')
                                            ->selectRaw('count(*) as count, lead_provider')
                                            ->where('admin_email',$user->email)
                                            ->having('count','>=','1')
                                            ->orderby('leads.lead_provider','asc')
                                            ->get();
            
    
            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));
    
            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
    
                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
    
            return $this->sendResponse([
                'sms_blast_view' => $get_lead_blast,
                'total-text' => $total_leads,
                'agents' => $agents,
                'total-lead-provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,
                'start_date' => $startdate
    
            ],'sms_blast_view');
    
        }
        elseif($user->usertype_id == 4){// Agent Lead Blast
            $get_admin_id =User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
    
    
            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;
    
            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);
    
            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }
    
            $get_all_agent_list = array($get_admin_id->parent_user_id);
    
            $get_all_agents = User::where('parent_user_id',$get_admin_id->parent_user_id)->get(['id']);
    
            foreach($get_all_agents as $get_all_agents)
            {
                $get_all_agent_list[] .= $get_all_agents->id;
            }
    
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.is_activated','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.blast_created_id','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.send_at','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','lead_blast.time_from','lead_blast.time_to','user_send.first_name as sender_first_name','user_send.last_name as sender_last_name','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                ->whereIn('lead_blast.assigned_id',$get_all_agent_list)
                ->orderby('id','desc')
                ->get();
    
            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');
    
            $get_admin = User::where('id',$user->id)
                ->first();
    
            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();
    
            $total_leads_provider = Lead::select('leads.lead_provider')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as c, lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->where('leads.lead_provider','!=','')
                ->having('c','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            
            $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

            $dedicated_number = $get_dedicated_number->phone_number;
            if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
            {
                $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
            }
    
        }

        return $this->sendResponse([
            'sms_blast_view' => $get_lead_blast,
            'total-text' => $total_leads,
            'agents' => $agents,
            'dedicated_number' => $dedicated_number,
            'total-lead-provider' => $total_leads_provider
        ],'sms_blast_view');

    }
    
    public function incommingBlasts(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        $today = now()->format('m-d-Y h:i A');
        if($user->usertype_id == 2){// Admin Lead Blast
            
            $get_lead_blast =   Leadblast::select('lead_blast.id','lead_blast.is_activated','lead_blast.blast_created_id','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                                            ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                                            ->where('lead_blast.message_status','Pending')
                                            ->whereRaw("STR_TO_DATE(lead_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user){
                                                $query->where('lead_blast.send_id',$user->id)->OrWhere('user_send.parent_user_id',$user->id);  
                                            })
                                            ->orderBy('id','desc')
                                            ->get();
            
            $get_mms_blast  =   Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->leftjoin('users as user_send','user_send.id','mms_blast.send_id')
                                            ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                            ->where('mms_blast.message_status','Pending')
                                            ->whereRaw("STR_TO_DATE(mms_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user){
                                                $query->where('mms_blast.send_id',$user->id)->OrWhere('user_send.parent_user_id',$user->id);  
                                            })
                                            ->orderBy('id','desc')
                                            ->get();
            
            $get_rvm_blast  =   Voicemailblast::with('audio')->select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->leftjoin('users as user_send','user_send.id','voicemail_blast.send_id')
                                            ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
                                            ->where('voicemail_blast.message_status','Pending')
                                            ->whereRaw("STR_TO_DATE(voicemail_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user){
                                                $query->where('voicemail_blast.send_id',$user->id)->OrWhere('user_send.parent_user_id',$user->id);  
                                            })
                                            ->orderBy('id','desc')
                                            ->get();
                                            
            $get_email_blast = Emailblast::select('email_blast.template_id','email_blast.subject','email_blast.is_activated','email_blast.is_attachment','email_blast.attachments','email_blast.id','email_blast.email_blast_created_id','email_blast.campaign_name','email_blast.send_limit','email_blast.send_at','email_blast.lead_provider','email_blast.message_filter','email_blast.email_status as message_status','email_blast.type','email_blast.target_status','email_blast.message_description','email_blast.assigned_id','email_blast.created_at','email_blast.updated_at','email_blast.date_from','email_blast.date_to','email_blast.send_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->with('template')
                                            ->leftjoin('users as user_send','user_send.id','email_blast.send_id')
                                            ->leftjoin('users as user_assiged','user_assiged.id','email_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','email_blast.email_blast_created_id')
                                            ->where('email_blast.email_status','Pending')
                                            ->whereRaw("STR_TO_DATE(email_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user){
                                                $query->where('email_blast.send_id',$user->id)->OrWhere('user_send.parent_user_id',$user->id);  
                                            })
                                            ->orderby('id','desc')
                                            ->get();
                                            
            $get_lead_blast = $get_lead_blast->map(function ($item) {
                $item['blast_type'] = 'lead_blast';
                return $item;
            });
            
            $get_mms_blast = $get_mms_blast->map(function ($item) {
                $item['blast_type'] = 'mms_blast';
                return $item;
            });
            
            $get_rvm_blast = $get_rvm_blast->map(function ($item) {
                $item['blast_type'] = 'rvm_blast';
                return $item;
            });
            
            $get_email_blast = $get_email_blast->map(function ($item) {
                $item['blast_type'] = 'email_blast';
                return $item;
            });
            
            $get_blast   =  $get_lead_blast->concat($get_mms_blast)->concat($get_rvm_blast)->concat($get_email_blast)->all();    
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                                ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                ->where('parent_user_id',$user->id)
                                ->where('users.approval','approve')
                                ->where('users.is_deleted',0)
                                ->orderby('id','desc')
                                ->get();
                
            $agents = array();
            
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            
            array_push($agents,$outsidefor);
    
            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];
    
                array_push($agents,$data);
    
            }
    
            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where('admin_email',$user->email)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
            
            return $this->sendResponse([
                                'blasts' => $get_blast,
                                'agents' => $agents,
                                'dedicated_number' => $dedicated_number,
                                'total-lead-provider' => $total_leads_provider
                            ],'incomming_blasts');
    
        }
        elseif($user->usertype_id == 4){  // Agent Lead Blast
        
            $get_admin_id =User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
            
            
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.is_activated','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.blast_created_id','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.send_at','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','lead_blast.time_from','lead_blast.time_to','user_send.first_name as sender_first_name','user_send.last_name as sender_last_name','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                                            ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                                            ->where('lead_blast.message_status','Pending')
                                            ->whereRaw("STR_TO_DATE(lead_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user,$admin_name){
                                                $query->where('lead_blast.send_id',$admin_name->id)->orWhere('lead_blast.assigned_id',$user->id);
                                            })
                                            ->orderby('id','desc')
                                            ->get();
                
            $get_mms_blast = Mmsblast::select('mms_blast.id','mms_blast.is_activated','mms_blast.campaign_number','mms_blast.mms_attachments','mms_blast.blast_created_id','mms_blast.campaign_name','mms_blast.send_limit','mms_blast.send_at','mms_blast.lead_provider','mms_blast.message_filter','mms_blast.message_status','mms_blast.type','mms_blast.target_status','mms_blast.message_description','mms_blast.assigned_id','mms_blast.send_id','mms_blast.created_at','mms_blast.updated_at','mms_blast.date_from','mms_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->leftjoin('users as user_assiged','user_assiged.id','mms_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','mms_blast.blast_created_id')
                                            ->where('mms_blast.message_status','Pending')
                                            ->whereRaw("STR_TO_DATE(mms_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user,$admin_name){
                                                $query->where('mms_blast.send_id',$admin_name->id)->orWhere('mms_blast.assigned_id',$user->id);
                                            })
                                            ->orderby('id','desc')
                                            ->get();
            
            $get_rvm_blast = Voicemailblast::with('audio')->select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
                                            ->where('voicemail_blast.message_status','Pending')
                                            ->whereRaw("STR_TO_DATE(voicemail_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user,$admin_name){
                                                $query->where('voicemail_blast.send_id',$admin_name->id)->orWhere('voicemail_blast.assigned_id',$user->id);
                                            })
                                            ->orderby('id','desc')
                                            ->get();
            
             $get_email_blast = Emailblast::select('email_blast.template_id','email_blast.subject','email_blast.is_activated','email_blast.is_attachment','email_blast.attachments','email_blast.id','email_blast.email_blast_created_id','email_blast.campaign_name','email_blast.send_limit','email_blast.send_at','email_blast.lead_provider','email_blast.message_filter','email_blast.email_status','email_blast.type','email_blast.target_status','email_blast.message_description','email_blast.assigned_id','email_blast.created_at','email_blast.updated_at','email_blast.date_from','email_blast.date_to','email_blast.send_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->with('template')
                                            ->leftjoin('users as user_assiged','user_assiged.id','email_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','email_blast.email_blast_created_id')
                                            ->where('email_blast.email_status','Pending')
                                            ->whereRaw("STR_TO_DATE(email_blast.send_at, '%m-%d-%Y %h:%i %p') >= STR_TO_DATE('$today', '%m-%d-%Y %h:%i %p')")
                                            ->where(function($query) use ($user,$admin_name){
                                                $query->where('email_blast.send_id',$admin_name->id)->orWhere('email_blast.assigned_id',$user->id);
                                            })
                                            ->orderby('id','desc')
                                            ->get();
        }

        $get_lead_blast = $get_lead_blast->map(function ($item) {
            $item['blast_type'] = 'lead_blast';
            return $item;
        });
        
        $get_mms_blast = $get_mms_blast->map(function ($item) {
            $item['blast_type'] = 'mms_blast';
            return $item;
        });
        
        $get_rvm_blast = $get_rvm_blast->map(function ($item) {
            $item['blast_type'] = 'rvm_blast';
            return $item;
        });
        
        $get_email_blast = $get_email_blast->map(function ($item) {
            $item['blast_type'] = 'email_blast';
            return $item;
        });
        
        $get_blast   =  $get_lead_blast->concat($get_mms_blast)->concat($get_rvm_blast)->concat($get_email_blast)->all();    
        
        $assigned_column = "admin_email";
        $total_leads = $admin_name->email;

        $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

        if($check_permission != null)
        {
            if($check_permission->lead_structure == 'assigned')
            {
                $assigned_column = "assigned_user_id";
                $assigned_agents = $user->id;
            }
            else
            {
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }
        }
        else{
            $assigned_column = "admin_email";
            $assigned_agents =  $admin_name->email;
        }
        
        $agents = User::select('id','first_name','last_name')
                            ->where('id',$user->id)
                            ->get();
    
        $total_leads_provider = Lead::select('leads.lead_provider')
                                        ->groupBy('lead_provider')
                                        ->selectRaw('count(*) as c, lead_provider')
                                        ->where($assigned_column,$assigned_agents)
                                        ->where('leads.lead_provider','!=','')
                                        ->having('c','>=','1')
                                        ->orderby('leads.lead_provider','asc')
                                        ->get();
        
        $get_dedicated_number = null;
        $dedicated_number = null;
        
        if($user->usertype_id == 4)
        {
            $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

            $dedicated_number = $get_dedicated_number->phone_number;
            if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
            {
                $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
            }
        }
        
        return $this->sendResponse([
                            'blasts' => $get_blast,
                            'agents' => $agents,
                            'dedicated_number' => $dedicated_number,
                            'total-lead-provider' => $total_leads_provider
                        ],'incomming_blasts');

    }

    public function leadcount(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        // return $request;

        $data = $request->data;
        $data = explode(",",$data);
        
        $leadprovider = $request->leadprovider;
        $leadprovider = explode(",",$leadprovider);

        // $data = $request->data;
        $order_from = date("Y-m-d", strtotime($request->from));
        $order_to = date("Y-m-d", strtotime($request->to . "+1 day"));

//        return  $dynamicData = Lead::whereNotNull('contact')->where('admin_email',$user->email)->whereBetween('created_at',[$order_from,$order_to])->get();
        $dynamic_lead_count = 0;

        if($request->leadtype == "All"){
            $request->leadtype = 0;
        }

        if($user->usertype_id == 2)
        {
            // foreach($data as $val)
            // {

                // $check = Lead::whereNotNull('contact')->where('admin_email',$user->email)->whereBetween('created_at',[$order_from,$order_to])->limit(5)->get();
                // dd($check);
                $dynamicData = Lead::where('admin_email',$user->email)->whereBetween('created_at',[$order_from,$order_to]);
                
                if (isset($request->blast_type) && $request->blast_type == "email") {
                    $dynamicData = $dynamicData->whereNotNull('email');
                } else {
                    $dynamicData = $dynamicData->whereNotNull('contact');
                }
                
                if (!empty($leadprovider)) {
                    if (array_fill(0, count($leadprovider), '0') === array_values($leadprovider)) {
                        $dynamicData = $dynamicData;
                    } else {
                        $dynamicData = $dynamicData->whereIn("lead_provider", $leadprovider);
                    }
                }
                
                if ($request->assignedto != '' && $request->assignedto != '0') {
                    $dynamicData = $dynamicData->where("assigned_user_id", $request->assignedto);
                }
                
                if ($request->leadtype != '0') {
                    $dynamicData = $dynamicData->where("classification", $request->leadtype);
                }
                // return $request->data;
                if (!empty($data)) {
                    if (array_fill(0, count($data), '0') === array_values($data) && $data[0] == 0) {
                        $dynamicData = $dynamicData->whereIn('lead_status', ['Active-Contacted', 'Active-Fresh', 'Active-NoTickle', 'Active-Employement', 'Active-Service', 'Active-Reminder Set', 'Active-Sale', 'Appointment-Set', 'Appointment-Cancel', 'Appointment-Showed', 'Appointment-Missed', 'DMS Offer-Replied', 'Sold-Unknown', 'Sold-Used', 'Sold-New', 'In Follow Up', 'Sold']);
                    } else {
                        $dynamicData = $dynamicData->whereIn('lead_status', $data);
                    }
                }
                $dynamic_lead_count  =   $dynamicData->count('id');
                
//                return $dynamicData->where('lead_status',$val)->count('id');

//                return  $dynamicData->count();

            // }
        }
        elseif($user->usertype_id == 4)
        {
//            $dd = Lead::where('assigned_user_id',347)->whereBetween('created_at',[$order_from,$order_to])->count('id');

            // foreach($data as $val)
            // {
                $get_admin_id = User::where('id',$request->assignedto)->first();
                $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();

                $assigned_column = "admin_email";
                $total_leads = $admin_name->email;

                $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

                if($check_permission != null)
                {
                    if($check_permission->lead_structure == 'assigned')
                    {
                        $assigned_column = "assigned_user_id";
                        $assigned_agents = $user->id;
                    }
                    else
                    {
                        if($request->assignedto != '')
                        {
                            $assigned_column = "assigned_user_id";
                            $assigned_agents = $user->id;
                        }
                        else
                        {
                            $assigned_column = "admin_email";
                            $assigned_agents =  $admin_name->email;
                        }
                    }
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }

                

                $dynamicData = Lead::where($assigned_column,$assigned_agents)->whereBetween('created_at',[$order_from,$order_to]);
                
                if (isset($request->blast_type) && $request->blast_type == "email") {
                    $dynamicData = $dynamicData->whereNotNull('email');
                } else {
                    $dynamicData = $dynamicData->whereNotNull('contact');
                }
                
                if (!empty($leadprovider)) {
                    if (array_fill(0, count($leadprovider), '0') === array_values($leadprovider)) {
                        $dynamicData = $dynamicData;
                    } else {
                        $dynamicData = $dynamicData->whereIn("lead_provider", $leadprovider);
                    }
                }
                
                
                if($request->leadtype != '0' && $request->leadtype != "")
                {
                    $dynamicData = $dynamicData->where("classification",$request->leadtype);
                }

                // $dynamic_lead_count[] .= $dynamicData->where('lead_status',$val)->count('id');
                if (!empty($data)) {
                    if (array_fill(0, count($data), '0') === array_values($data) && $data[0] == 0) {
                        $dynamicData = $dynamicData->whereIn('lead_status', ['Active-Contacted', 'Active-Fresh', 'Active-NoTickle', 'Active-Employement', 'Active-Service', 'Active-Reminder Set', 'Active-Sale', 'Appointment-Set', 'Appointment-Cancel', 'Appointment-Showed', 'Appointment-Missed', 'DMS Offer-Replied', 'Sold-Unknown', 'Sold-Used', 'Sold-New', 'In Follow Up', 'Sold']);
                    } else {
                        $dynamicData = $dynamicData->whereIn('lead_status', $data);
                    }
                }
                $dynamic_lead_count  =   $dynamicData->count('id');
                
            // }
        }

        return $this->sendResponse([
                'total-leads' => $dynamic_lead_count,
        ],'total-lead-count-filter');

    }

    public function blastImageFile(Request $request){


            $this->validate($request, ['file' => 'mimes:jpeg,png,bmp,jpg,tiff |max:4096',]);

            $shortener = app('url.shortener');
            $image = $request->file('file');
            $new_name = rand() . '.' . $image->getClientOriginalExtension();
            $imagepath = $image->move('./asset/chat-assets/images', $new_name);
            $path = $new_name;
            $completePath = url('/').'/asset/chat-assets/images/'.$path;
            $shortUrl = $shortener->driver('is_gd')->shorten($completePath);

//            return response()->json([
//                'message'   => $shortUrl
//            ]);

            return $this->sendResponse([
                'short_url' => $shortUrl,
            ],'short_url');


    }

    public function leadBlastPost(Request $request){

            $rules = array(
                'sendat' => 'required',
                'leadprovider' => 'required',
                'type' => 'required',
                'target_status' => 'required',
                'messagedescription' => 'required',
                'schedule_time_from' => 'required',
                'schedule_time_to' => 'required',
                'audienceVal' => 'required',
                'senderid' => 'required'
            );
            

            $validator = Validator::make($request->all(), $rules);

            if ( $validator->fails() ) {

                $messages = $validator->errors()->all();

                // redirect our user back to the form with the errors from the validator
                return response()->json([
                    'success' => false,
                    'data'    => [],
                    'message'  => $messages[0],
                ],422);
            }

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
            $type = "";

            $drafted = null;

            if($request->submit == 'draft')
            {
                $drafted = "no";
            }
            else
            {
                $drafted = "yes";
            }
            
            if($request->submit != null)
            {
                $date_from = date('Y-m-d', strtotime($request->schedule_time_from));
                $date_to = date('Y-m-d', strtotime($request->schedule_time_to));

                if($request->type == "All"){
                    $type = 0 ;
                }
                else {
                    $type = $request->type;
                }

                $sender_id  = null;
                $sender_id = $request->senderid;
                $assign_agent_id = $request->assignedto;

                if($user->usertype_id == 2)
                {
                    if($request->assignedto != '' && $request->assignedto != 0)
                    {
                        $assign_agent_id = $request->assignedto;
                    }
                    else
                    {
                        $assign_agent_id = $user->id;
                    }
                }

                $audienceValMax = 'no';
                if($request->audienceVal > 400)
                {
                    $audienceValMax = $request->audienceVal;
                }

                $message_filter = date('m/d/Y', strtotime($request->schedule_time_from))." - ".date('m/d/Y', strtotime($request->schedule_time_to));

                $target_status = explode(',',$request->target_status);
                $target_status_seperator = implode(', ', $target_status);

                $provider = explode(',',$request->leadprovider);
                $leadprovider =  implode(', ', $provider);


                $number_length_home = strlen($request->send_from_number_val);
                
                if($number_length_home == 10){
                    $request->send_from_number_val = '+1'.trim($request->send_from_number_val);
                }
                elseif ($number_length_home == 11){
                    $request->send_from_number_val = '+'.trim($request->send_from_number_val);
                }
                elseif ($number_length_home == 12) {
                    $request->send_from_number_val = trim($request->send_from_number_val);
                }

                $blast = [
                    'campaign_name' => $request->campaign_name,
                    'campaign_number' => $request->send_from_number_val,
                    'send_limit' => $request->audienceVal,
                    'send_at' => $request->sendat,
                    'lead_provider' => $leadprovider,
                    'message_filter' => $message_filter,
                    'message_status' => 'Pending',
                    'save_template'  => $request->save_as_template,
                    'type' => $type,
                    'target_status' => $target_status_seperator,
                    'message_description' => $request->messagedescription. " Reply STOP to Opt-Out.",
                    'assigned_id' => $assign_agent_id,
                    'send_id' => $sender_id,
                    'date_from' => $date_from,
                    'date_to' => $date_to,
                    'blast_created_id'=>$user->id,
                    'max_blast' => $audienceValMax,
                    'is_activated' => $drafted
                ];

                
                $insert_lead_blast = Leadblast::insertGetId($blast);

                $this->blastPercentage($insert_lead_blast);
                
                if($user->usertype_id == 2)
                {
                    $titleN      =  'New SMS Blast Created By '.$user->first_name;
                    $titleAdmin  =  'New SMS Blast Created By You';
                    $total_agent_ids = DB::table('users')->select(['id'])->where('parent_user_id', $user->id)->where("usertype_id", 4)->where("approval", "approve")->whereNotNull('device_token')->pluck("id");
                    $user_ids = $total_agent_ids;
                    
                    PushNotificationTrait::PushNotificationFirebaseSend($user_ids, $titleN, $request->campaign_name,$insert_lead_blast,'sms_blast');
                    PushNotificationTrait::PushNotificationFirebaseSend([$user->id], $titleAdmin, $request->campaign_name,$insert_lead_blast,'sms_blast');
                    
                }elseif($user->usertype_id == 4){
                    
                    $titleN  =  'New SMS Blast Created By You';
                    $titleAdmin  =  'New SMS Blast Created By '.$user->first_name;
                    $total_agent_ids = DB::table('users')->select(['id'])->where('id', $user->id)->where("usertype_id", 4)->where("approval", "approve")->whereNotNull('device_token')->pluck("id");
                    $user_ids = $total_agent_ids;
                
                    PushNotificationTrait::PushNotificationFirebaseSend($user_ids, $titleN, $request->campaign_name,$insert_lead_blast,'sms_blast');
                    PushNotificationTrait::PushNotificationFirebaseSend([$sender_id], $titleAdmin, $request->campaign_name,$insert_lead_blast,'sms_blast');
                    
                }
                
                if($insert_lead_blast){
                    
                    return response()->json([
                        'success' => true,
                        'data' => [],
                        'message' => 'Blast added successfully',
                    ],200);

                }
                else{
                    return response()->json([
                        'success' => false,
                        'data' => [],
                        'message' => 'Something wents wrong',
                    ],422);
                }

            }

    }

    public function leadBlastUpdate(Request $request)
    {
        $validator =    Validator::make($request->all(),[
            'editleadblastid' => 'required',
            'editaudienceVal' => 'required',
            'editsendat' => 'required',
            'editleadprovider' => 'required',
            'edittype' => 'required',
            'editsenderid' => 'required',
            'edittarget_status' => 'required',
            'editmessagedescription' => 'required',
            'schedule_time_from_edit' => 'required',
            'schedule_time_to_edit' => 'required',
            'send_from_number_val' => 'required',
        ]); 
        
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' =>  $validator->messages()->all()[0],
            ],401);
        }
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $drafted = null;

            if($request->submit == 'draft')
            {
                $drafted = "no";
            }
            else
            {
                $drafted = "yes";
            }

            
            if($request->edittype == "All"){
                $leadtype = 0;
            }
            else{
                $leadtype = $request->edittype;
            }
            $audienceValMax = 'no';
            if($request->editaudienceVal > 400)
            {
                $audienceValMax = $request->editaudienceVal;
            }

            $date_from = date('Y-m-d', strtotime($request->schedule_time_from_edit));
            $date_to = date('Y-m-d', strtotime($request->schedule_time_to_edit));

            $sender_id  = null;
            $sender_id = $request->editsenderid;
            $message_filter = date('m/d/Y', strtotime($request->schedule_time_from_edit))." - ".date('m/d/Y', strtotime($request->schedule_time_to_edit));

            $assign_agent_id = $request->editassignedto;

            if($user->usertype_id == 2)
            {
                if($request->editassignedto != '' && $request->editassignedto != 0)
                {
                    $assign_agent_id = $request->editassignedto;
                }
                else
                {
                    $assign_agent_id = $user->id;
                }

                $request->editassignedto = $user->id;
            }

            $target_status = explode(',',$request->edittarget_status);
            $target_status_seperator = implode(', ', $target_status);

            $provider = explode(',',$request->editleadprovider);
            $leadprovider =  implode(', ', $provider);


//            $target_status_seperator = $request->edittarget_status;
//            $leadprovider = $request->editleadprovider;

//            $request->send_from_number_val = str_replace('(','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace(')','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace('-','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace(' ','',$request->send_from_number_val);

            $number_length_home = strlen($request->send_from_number_val);
            if($number_length_home == 10){
                $request->send_from_number_val = '+1'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 11){
                $request->send_from_number_val = '+'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 12) {
                $request->send_from_number_val = trim($request->send_from_number_val);
            }

            $blast = [
                'campaign_name' => $request->campaign_name,
                'campaign_number' => $request->send_from_number_val,
                'send_limit' => $request->editaudienceVal,
                'send_at' => $request->editsendat,
                'lead_provider' => $leadprovider,
                'message_filter' => $message_filter,
                'message_status' => 'Pending',
                'type' => $leadtype,
                'target_status' => $target_status_seperator,
                'message_description' => $request->editmessagedescription,
                'assigned_id' => $assign_agent_id,
                'send_id' => $sender_id,
                'date_from' =>$date_from,
                'date_to' => $date_to,
                'blast_created_id'=>$user->id,
                'max_blast' => $audienceValMax,
                "is_activated" => $drafted
            ];


            $insert_lead_blast = Leadblast::where('id',$request->editleadblastid)->update($blast);

            $this->blastPercentage($request->editleadblastid);

            if($insert_lead_blast){
                return response()->json([
                    'success' => true,
                    'message' => 'Blast campaign update successfully',
                ],200);

            }
            else{
                return response()->json([
                    'success' => false,
                    'message' => 'No changes made to update campaign!',
                ],401);
         
            }

    }

    public function blastPercentage($blast_id)
    {
        $admin_id = null;
        $get_lead_blast = Leadblast::select('lead_blast.*','users.id as user_id','users.usertype_id as usertype_id')
            ->leftjoin('users','users.id','lead_blast.assigned_id')
            ->where('lead_blast.id',$blast_id)
            ->get();

        if($get_lead_blast->count() > 0)
        {
            foreach ($get_lead_blast as $leadblast) {
                $splitStatus = explode(', ', $leadblast->target_status);
                $splitDate = explode(' - ', $leadblast->message_filter);
                $splitlead_provider = explode(', ', $leadblast->lead_provider);

                $startdate = date("Y-m-d", strtotime($splitDate[0]));
                $enddate = date("Y-m-d", strtotime($splitDate[1]));

                if($leadblast->usertype_id == 2){
                    $get_admin_email = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $leadblast->user_id;

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::whereIn('lead_provider',$splitlead_provider)
                            ->whereNotNull('contact')
                            ->where('admin_email',$get_admin_email->email)
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->whereIn('lead_status',$splitStatus)
                            ->get();
                    }
                    else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereNotNull('contact')
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->whereIn('lead_status',$splitStatus)
                            ->get();
                    }
                }
                else{
                    $get_agent = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $get_agent->parent_user_id;
                    $get_admin_email = DB::table('users')->where('id',$get_agent->parent_user_id)->first();

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::whereIn('lead_provider',$splitlead_provider)
                            ->whereNotNull('contact')
                            ->where('admin_email',$get_admin_email->email)
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->whereIn('lead_status',$splitStatus)
                            ->where('assigned_user_id',$leadblast->assigned_id)
                            ->get();
                    }else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereNotNull('contact')
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->whereIn('lead_status',$splitStatus)
                            ->where('assigned_user_id',$leadblast->assigned_id)
                            ->get();
                    }
                }

                $leads_id = array();
                $count = 1;
                foreach($leads as $lead)
                {
                    $leads_id[] .= $lead->id;
                }

                $check_blast_exist = Blastpercentage::where('blast_id',$blast_id)->where('blast_type','sms')->first(['blast_id']);
                $check_blast_lead_exist = DB::table('blast_leads')->where('blast_id',$blast_id)->where('blast_type','sms')->first(['blast_id']);
                if($check_blast_exist == null)
                {
                   Blastpercentage::insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'sms', 'leads_id' => implode(",",$leads_id)]);
                }
                else
                {
                    Blastpercentage::where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                }
                
                if($check_blast_lead_exist == null)
                {
                    DB::table('blast_leads')->insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'sms', 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }
                else
                {
                    DB::table('blast_leads')->where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }
            }
        }
    }

    public function leadBlastDelete(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                $check_lead_blast = Leadblast::where('id',$request->leadblastid)
                    ->delete();

                Blastpercentage::where('blast_id',$request->leadblastid)->where('blast_type','sms')->delete();

                if($check_lead_blast){

                    return response()->json([
                        'success' => true,
                        'message' => 'Deleted successfully',
                    ],200);
                }
                else {
                    return response()->json([
                        'success' => false,
                        'message' => 'Something went wrong while deleting',
                    ],500);

                }
    }

    public function activateCampaign(Request $request)
    {
        $type = $request->type;
        $id = $request->id;

        if($type == 'sms')
        {
            $lead_blast = Leadblast::where('id',$id)->update(["is_activated" => "yes"]);

            return response()->json([
                'success'  => true,
                'data' => [],
                'message' => 'Campaign activate successfully!'
            ]);

        }
        elseif($type == 'mms'){
            $lead_blast = Mmsblast::where('id',$id)->update(["is_activated" => "yes"]);

            return response()->json([
                'success'  => true,
                'data' => [],
                'message' => 'Campaign activate successfully!'
            ]);

        }
        elseif($type == 'rvm'){
            
            $lead_blast = Voicemailblast::where('id',$id)->update(["is_activated" => "yes"]);

            return response()->json([
                'success'  => true,
                'data' => [],
                'message' => 'Campaign activate successfully!'
            ]);
        }elseif($type == 'email'){
            $lead_blast = Emailblast::where('id',$id)->update(["is_activated" => "yes"]);

            return response()->json([
                'success'  => true,
                'data' => [],
                'message' => 'Campaign activate successfully!'
            ]);
        }
        else{
            return response()->json([
                'success'  => false,
                'data' => [],
                'message' => 'Something Went Wrong'
            ]);
        }
    }

    public function addShortUrl(Request $request)
    {
        $shortener = app('url.shortener');
        $shortUrl = $shortener->driver('is_gd')->shorten($request->short_url);

        return $this->sendResponse([
            'short_url' => $shortUrl,
        ],'short_url');

    }

    public function savedTemplats(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){// Admin Lead Blast
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.save_template','lead_blast.is_activated','lead_blast.blast_created_id','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                ->where('save_template','yes')
                ->where('lead_blast.send_id',$user->id)
                ->OrWhere('user_send.parent_user_id',$user->id)
                ->orderby('id','desc')
                ->get();
    
            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');
    
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                ->where('parent_user_id',$user->id)
                ->where('users.approval','approve')
                ->where('users.is_deleted',0)
                ->orderby('id','desc')
                ->get();
                
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);
    
            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];
    
                array_push($agents,$data);
    
            }
    
            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where('admin_email',$user->email)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
    
            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));
    
            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
    
                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
    
            return $this->sendResponse([
                'saved_sms_templates' => $get_lead_blast,
                'total-text' => $total_leads,
                'agents' => $agents,
                'total-lead-provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,
                'start_date' => $startdate
    
            ],'saved_sms_templates');
    
        }
        elseif($user->usertype_id == 4){// Agent Lead Blast
            $get_admin_id =User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
    
    
            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;
    
            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);
    
            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }
    
            $get_all_agent_list = array($get_admin_id->parent_user_id);
    
            $get_all_agents = User::where('parent_user_id',$get_admin_id->parent_user_id)->get(['id']);
    
            foreach($get_all_agents as $get_all_agents)
            {
                $get_all_agent_list[] .= $get_all_agents->id;
            }
    
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.save_template','lead_blast.is_activated','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.blast_created_id','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.send_at','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','lead_blast.time_from','lead_blast.time_to','user_send.first_name as sender_first_name','user_send.last_name as sender_last_name','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                ->where('save_template','yes')
                ->whereIn('lead_blast.assigned_id',$get_all_agent_list)
                ->orderby('id','desc')
                ->get();
    
            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');
    
            $get_admin = User::where('id',$user->id)
                ->first();
    
            $agents = User::select('id','first_name','last_name')
                            ->where('users.approval','approve')
                            ->where('parent_user_id',$user->parent_user_id)
                            ->get();

            $total_leads_provider = Lead::select('leads.lead_provider')
                                                ->groupBy('lead_provider')
                                                ->selectRaw('count(*) as count, lead_provider')
                                                ->where($assigned_column,$assigned_agents)
                                                ->where('leads.lead_provider','!=','')
                                                ->having('count','>=','1')
                                                ->orderby('leads.lead_provider','asc')
                                                ->get();
                                    
    
        }

        return $this->sendResponse([
            'saved_sms_templates' => $get_lead_blast,
            'total-text' => $total_leads,
            'agents' => $agents,
            'total-lead-provider' => $total_leads_provider
        ],'saved_sms_templates');
    }
    
    public function smsDraft(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){// Admin Lead Blast
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.save_template','lead_blast.is_activated','lead_blast.blast_created_id','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                ->where('message_status','Pending')
                ->where('is_activated','no')
                ->where('lead_blast.send_id',$user->id)
                ->OrWhere('user_send.parent_user_id',$user->id)
                ->orderby('id','desc')
                ->get();
    
            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');
    
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                ->where('parent_user_id',$user->id)
                ->where('users.approval','approve')
                ->where('users.is_deleted',0)
                ->orderby('id','desc')
                ->get();
                
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);
    
            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];
    
                array_push($agents,$data);
    
            }
    
            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where('admin_email',$user->email)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
    
            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));
    
            $other_numbers = Companyextranumber::where('user_id',$user->id)->get(['phone_number']);
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
    
                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            elseif($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
    
            return $this->sendResponse([
                'draft_sms_blasts' => $get_lead_blast,
                'total-text' => $total_leads,
                'agents' => $agents,
                'total-lead-provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,
                'start_date' => $startdate
    
            ],'draft_sms_blasts');
    
        }
        elseif($user->usertype_id == 4){// Agent Lead Blast
            $get_admin_id =User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();
    
    
            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;
    
            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);
    
            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }
    
            $get_all_agent_list = array($get_admin_id->parent_user_id);
    
            $get_all_agents = User::where('parent_user_id',$get_admin_id->parent_user_id)->get(['id']);
    
            foreach($get_all_agents as $get_all_agents)
            {
                $get_all_agent_list[] .= $get_all_agents->id;
            }
    
            $get_lead_blast = Leadblast::select('lead_blast.id','lead_blast.save_template','lead_blast.is_activated','lead_blast.campaign_name','lead_blast.campaign_number','lead_blast.blast_created_id','lead_blast.send_limit','lead_blast.send_at','lead_blast.lead_provider','lead_blast.message_filter','lead_blast.message_status','lead_blast.type','lead_blast.target_status','lead_blast.message_description','lead_blast.assigned_id','lead_blast.send_id','lead_blast.send_at','lead_blast.created_at','lead_blast.updated_at','lead_blast.date_from','lead_blast.date_to','lead_blast.time_from','lead_blast.time_to','user_send.first_name as sender_first_name','user_send.last_name as sender_last_name','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','lead_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','lead_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','lead_blast.blast_created_id')
                ->where('message_status','Pending')
                ->where('is_activated','no')
                ->whereIn('lead_blast.assigned_id',$get_all_agent_list)
                ->orderby('id','desc')
                ->get();
    
            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');
    
            $get_admin = User::where('id',$user->id)
                ->first();
    
            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();
    
            $total_leads_provider = Lead::select('leads.lead_provider')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as c, lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->where('leads.lead_provider','!=','')
                ->having('c','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
    
    
        }

        return $this->sendResponse([
            'draft_sms_blasts' => $get_lead_blast,
            'total-text' => $total_leads,
            'agents' => $agents,
            'total-lead-provider' => $total_leads_provider
        ],'draft_sms_blasts');
    }
    
}