<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\Leadchat;
use App\Leadlog;
use App\User;
use App\Companyinfo;
use App\Companyextranumber;
use App\Carmake;
use App\Carmodel;
use App\Contactemail;
use Validator;
use App\Leadinventoryinfo;
use App\Notification;
use Illuminate\Support\Facades\Cache;



class TeamController extends BaseController{
    
    public function teamActivityView(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                if($user->usertype_id == 2){

                    $admins = User::where('parent_user_id', $user->id)->get();


                    // Today Start
                    // Text Part Start 
                    $today_total_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->whereIn('type',['received','sent'])->whereDate('created_at', date('Y-m-d'))->count('*');
                    $today_total_receive = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('*');
                    $today_total_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('*');
                    $today_robo_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('*');


                    $today_total_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $today_total_mms_text_received = Leadchat::where('mms_attachments','!=',null)->where('admin_id',$user->id)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('id');
                    $today_total_mms_text_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_robo_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');

                    $today_total_vm = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',"=",null)->where('admin_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $today_total_vm_text_sent = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',"=",null)->where('admin_id',$user->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_robo_vm = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',"=",null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');
                    // Text Part End

                    // Phone Part Start
                    $adminCompany = Companyinfo::where('user_id',$user->id)->first();
                    $today_total_inbound = Leadlog::where('status','incoming')->where('to',$adminCompany->phone_number)->whereDate('created_at', date('Y-m-d'))->count('*');
                    $today_total_outbound = Leadlog::where('status','outbound')->where('from',$adminCompany->phone_number)->whereDate('created_at', date('Y-m-d'))->count('*');
                    // Phone Part End

                    $today_break_down = [];
                    $today_total_text_sent = 0;
                    $today_total_log_sent = 0;
                    $today_total_email_sent = 0;
                    $today_total_text_received = 0;
                    $today_total_log_received = 0;
                    $today_total_email_received = 0;
                    $today_total_mms_sent = 0;
                    $today_total_mms_received = 0;
                    $today_total_vm_sent = 0;
                    $today_total_vm_received = 0;


                    if(count($admins) > 0){
                        foreach ($admins as $row) {
                            $today_total_text_sent = 0;
                            $today_total_log_sent = 0;
                            $today_total_email_sent = 0;
                            $today_total_text_received = 0;
                            $today_total_log_received = 0;
                            $today_total_email_received = 0;
                            $today_total_mms_sent = 0;
                            $today_total_mms_received = 0;
                            $today_total_vm_sent = 0;
                            $today_total_vm_received = 0;

                            if($row->usertype_id == 4){
                                $today_admin_leads_count = Lead::where('assigned_user_id',$row->id)->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_admin_leads_appointment_set = Lead::where(['assigned_user_id' => $row->id,'lead_status' => 'Appointment-Set'])->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_admin_leads_appointment_showed = Lead::where(['assigned_user_id' => $row->id,'lead_status' => 'Appointment-Showed'])->whereDate('created_at', date('Y-m-d'))->count('*');

                                $today_lead_text_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('sender_id',$row->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_lead_mms_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('sender_id',$row->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_lead_log_sent = Leadlog::where('sender_id',$row->id)->where('status','outbound')->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_lead_email_sent = Contactemail::where('sender_id',$row->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('*');

                                $today_lead_vm_sent = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',"=",null)->where('sender_id',$row->id)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('*');

                                $today_lead_text_received = Leadchat::where('mms_attachments',null)->where('sender_id',$row->id)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_lead_mms_received = Leadchat::where('mms_attachments',"!=",null)->where('sender_id',$row->id)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_lead_log_received = Leadlog::where('sender_id',$row->id)->where('status','incoming')->whereDate('created_at', date('Y-m-d'))->count('*');
                                $today_lead_email_received = Contactemail::where('sender_id',$row->id)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('*');



                                $today_total_text_sent = $today_total_text_sent + $today_lead_text_sent;
                                $today_total_log_sent = $today_total_log_sent + $today_lead_log_sent;
                                $today_total_email_sent = $today_total_email_sent + $today_lead_email_sent;
                                $today_total_text_received = $today_total_text_received + $today_lead_text_received;
                                $today_total_log_received = $today_total_log_received + $today_lead_log_received;
                                $today_total_email_received = $today_total_email_received + $today_lead_email_received;
                                $today_total_mms_sent = $today_total_mms_sent + $today_lead_mms_sent;
                                $today_total_mms_received = $today_total_mms_received + $today_lead_mms_received;
                                $today_total_vm_sent = $today_total_vm_sent + $today_lead_vm_sent ;
                            }

                            $arrtoday = [
                                'admin_name' => $row->first_name.' '.$row->last_name,
                                'total_today_leads' => $today_admin_leads_count,
                                'total_today_text_sent' => $today_total_text_sent,
                                'total_today_mms_sent' => $today_total_mms_sent,
                                'total_today_log_sent' => $today_total_log_sent,
                                'total_today_email_sent' => $today_total_email_sent,
                                'total_today_text_received' => $today_total_text_received,
                                'total_today_mms_received' => $today_total_mms_received,
                                'total_today_log_received' => $today_total_log_received,
                                'total_today_email_received' => $today_total_email_received,
                                'appointment_set' => $today_admin_leads_appointment_set,
                                'appointment_showed' => $today_admin_leads_appointment_showed,

                            ];

                            array_push($today_break_down, $arrtoday);

                        }
                    }

                    // Today End

                    // Week Start
                    // Text Part Start 
                    $week_total_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->whereIn('type',['received','sent'])->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_total_receive = Leadchat::where('mms_attachments',null)->where('admin_id',$user->id)->where('type','received')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_total_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_robo_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');


                    $week_total_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_total_mms_text_received = Leadchat::where('mms_attachments','!=',null)->where('admin_id',$user->id)->where('type','received')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_total_mms_text_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_robo_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');

                    $week_total_vm = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_total_vm_text_sent = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_robo_vm = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    // Text Part End

                    // Phone Part Start
                    $adminCompany = Companyinfo::where('user_id',$user->id)->first();
                    $week_total_inbound = Leadlog::where('status','incoming')->where('to',$adminCompany->phone_number)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    $week_total_outbound = Leadlog::where('status','outbound')->where('from',$adminCompany->phone_number)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                    // Phone Part End

                    $week_break_down = [];
                    $week_total_text_sent = 0;
                    $week_total_log_sent = 0;
                    $week_total_email_sent = 0;
                    $week_total_text_received = 0;
                    $week_total_log_received = 0;
                    $week_total_email_received = 0;
                    $week_total_mms_sent = 0;
                    $week_total_mms_received = 0;
                    $week_total_vm_sent = 0;
                    $week_total_vm_received = 0;

                    if(count($admins) > 0){
                        foreach ($admins as $row) {
                            $week_total_text_sent = 0;
                            $week_total_log_sent = 0;
                            $week_total_email_sent = 0;
                            $week_total_text_received = 0;
                            $week_total_log_received = 0;
                            $week_total_email_received = 0;
                            $week_total_mms_sent = 0;
                            $week_total_mms_received = 0;
                            $week_total_vm_sent = 0;
                            $week_total_vm_received = 0;

                            if($row->usertype_id == 4){
                                $week_admin_leads_count = Lead::where('assigned_user_id',$row->id)->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_admin_leads_appointment_set = Lead::where(['assigned_user_id' => $row->id,'lead_status' => 'Appointment-Set'])->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_admin_leads_appointment_showed = Lead::where(['assigned_user_id' => $row->id,'lead_status' => 'Appointment-Showed'])->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');

                                $week_lead_text_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('sender_id',$row->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_lead_log_sent = Leadlog::where('sender_id',$row->id)->where('status','outbound')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_lead_email_sent = Contactemail::where('sender_id',$row->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');

                                $week_lead_text_received = Leadchat::where('mms_attachments',null)->where('sender_id',$row->id)->where('type','received')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_lead_log_received = Leadlog::where('sender_id',$row->id)->where('status','incoming')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_lead_email_received = Contactemail::where('sender_id',$row->id)->where('type','received')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');

                                $week_lead_mms_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('sender_id',$row->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');
                                $week_lead_mms_received = Leadchat::where('mms_attachments',"!=",null)->where('sender_id',$row->id)->where('type','received')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');

                                $week_lead_vm_sent = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('sender_id',$row->id)->where('type','sent')->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))->whereDate('created_at','<=',date('Y-m-d'))->count('*');

                                $week_total_text_sent = $week_total_text_sent + $week_lead_text_sent;
                                $week_total_log_sent = $week_total_log_sent + $week_lead_log_sent;
                                $week_total_email_sent = $week_total_email_sent + $week_lead_email_sent;
                                $week_total_text_received = $week_total_text_received + $week_lead_text_received;
                                $week_total_log_received = $week_total_log_received + $week_lead_log_received;
                                $week_total_email_received = $week_total_email_received + $week_lead_email_received;
                                $week_total_mms_sent = $week_total_mms_sent + $week_lead_mms_sent;
                                $week_total_mms_received = $week_total_mms_received + $week_lead_mms_received;
                                $week_total_vm_sent = $week_total_vm_sent + $week_lead_vm_sent;
                            }


                            $arrweek = [
                                'admin_name' => $row->first_name.' '.$row->last_name,
                                'total_week_leads' => $week_admin_leads_count,
                                'total_week_text_sent' => $week_total_text_sent,
                                'total_week_mms_sent' => $week_total_mms_sent,
                                'total_week_log_sent' => $week_total_log_sent,
                                'total_week_email_sent' => $week_total_email_sent,
                                'total_week_text_received' => $week_total_text_received,
                                'total_week_mms_received' => $week_total_mms_received,
                                'total_week_log_received' => $week_total_log_received,
                                'total_week_email_received' => $week_total_email_received,
                                'appointment_set' => $week_admin_leads_appointment_set,
                                'appointment_showed' => $week_admin_leads_appointment_showed,
                            ];

                            array_push($week_break_down, $arrweek);

                        }
                    }
                    // Week End





                    $data = ['today_total_text','today_total_receive','today_total_sent','today_total_inbound','today_total_outbound','week_total_text','week_total_receive','week_total_sent','week_total_inbound','week_total_outbound','today_break_down','week_break_down','week_robo_text','today_robo_text','today_total_mms','today_total_mms_text_received','today_total_mms_text_sent','week_total_mms','week_total_mms_text_sent','week_total_mms_text_received','total_robo_mms','week_robo_mms',
                        'today_total_vm','today_total_vm_text_sent','total_robo_vm','week_total_vm','week_total_vm_text_sent','week_robo_vm'];

                    return $this->sendResponse([
                        'leadList' => compact($data) ,
                    ],'leadlist');


                }
           
    }

        public function customteamActivity(Request $request){

                $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
                $startdate = date("Y-m-d", strtotime($request->date_from));
                $enddate = date("Y-m-d", strtotime($request->date_to));


                if($user->usertype_id == 2){

                    $admins = User::where('parent_user_id', $user->id)->get();




                    // Today Start
                    // Text Part Start
                    $custom_total_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->whereIn('type',['received','sent'])->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_total_receive = Leadchat::where('mms_attachments',null)->where('admin_id',$user->id)->where('type','received')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_total_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_robo_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');



                    $custom_total_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_total_mms_text_received = Leadchat::where('mms_attachments','!=',null)->where('admin_id',$user->id)->where('type','received')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_total_mms_text_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_robo_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');


                    $custom_total_vm = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_total_vm_text_sent = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','sent')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                    $custom_robo_vm = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');

                    // Text Part End

                    // Phone Part Start
                    $adminCompany = Companyinfo::where('user_id',$user->id)->first();
                    $custom_total_inbound = Leadlog::where('status','incoming')->where('to',$adminCompany->phone_number)->whereDate('lead_logs.created_at','>=',$startdate)->whereDate('lead_logs.created_at','<=',$enddate)->count('*');
                    $custom_total_outbound = Leadlog::where('status','outbound')->where('from',$adminCompany->phone_number)->whereDate('lead_logs.created_at','>=',$startdate)->whereDate('lead_logs.created_at','<=',$enddate)->count('*');
                    // Phone Part End

                    $custom_break_down = [];
                    $custom_total_text_sent = 0;
                    $custom_total_log_sent = 0;
                    $custom_total_email_sent = 0;
                    $custom_total_text_received = 0;
                    $custom_total_log_received = 0;
                    $custom_total_email_received = 0;
                    $custom_total_mms_sent = 0;
                    $custom_total_mms_received = 0;
                    $custom_total_vm_sent = 0;

                    if(count($admins) > 0){
                        foreach ($admins as $row) {
                            $custom_total_text_sent = 0;
                            $custom_total_log_sent = 0;
                            $custom_total_email_sent = 0;
                            $custom_total_text_received = 0;
                            $custom_total_log_received = 0;
                            $custom_total_email_received = 0;
                            $custom_total_mms_sent = 0;
                            $custom_total_mms_received = 0;
                            $custom_total_vm_sent = 0;

                            if($row->usertype_id == 4){
                                $custom_admin_leads_count = Lead::where('assigned_user_id',$row->id)->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
                                $custom_admin_leads_appointment_set = Lead::where(['assigned_user_id' => $row->id,'lead_status' => 'Appointment-Set'])->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');
                                $custom_admin_leads_appointment_showed = Lead::where(['assigned_user_id' => $row->id,'lead_status' => 'Appointment-Showed'])->whereDate('leads.created_at','>=',$startdate)->whereDate('leads.created_at','<=',$enddate)->count('*');

                                $custom_lead_text_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('sender_id',$row->id)->where('type','sent')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                                $custom_lead_log_sent = Leadlog::where('sender_id',$row->id)->where('status','outbound')->whereDate('lead_logs.created_at','>=',$startdate)->whereDate('lead_logs.created_at','<=',$enddate)->count('*');
                                $custom_lead_mms_sent = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('sender_id',$row->id)->where('type','sent')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                                $custom_lead_email_sent = Contactemail::where('sender_id',$row->id)->where('type','sent')->whereDate('contact_email.created_at','>=',$startdate)->whereDate('contact_email.created_at','<=',$enddate)->count('*');

                                $custom_lead_vm_sent = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('sender_id',$row->id)->where('type','sent')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');

                                $custom_lead_text_received = Leadchat::where('sender_id',$row->id)->where('type','received')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                                $custom_lead_log_received = Leadlog::where('sender_id',$row->id)->where('status','incoming')->whereDate('lead_logs.created_at','>=',$startdate)->whereDate('lead_logs.created_at','<=',$enddate)->count('*');
                                $custom_lead_mms_received = Leadchat::where('mms_attachments',"!=",null)->where('sender_id',$row->id)->where('type','received')->whereDate('lead_chat.created_at','>=',$startdate)->whereDate('lead_chat.created_at','<=',$enddate)->count('*');
                                $custom_lead_email_received = Contactemail::where('sender_id',$row->id)->where('type','received')->whereDate('contact_email.created_at','>=',$startdate)->whereDate('contact_email.created_at','<=',$enddate)->count('*');



                                $custom_total_text_sent = $custom_total_text_sent + $custom_lead_text_sent;
                                $custom_total_log_sent = $custom_total_log_sent + $custom_lead_log_sent;
                                $custom_total_email_sent = $custom_total_email_sent + $custom_lead_email_sent;
                                $custom_total_text_received = $custom_total_text_received + $custom_lead_text_received;
                                $custom_total_log_received = $custom_total_log_received + $custom_lead_log_received;
                                $custom_total_email_received = $custom_total_email_received + $custom_lead_email_received;
                                $custom_total_mms_sent = $custom_total_mms_sent + $custom_lead_mms_sent;
                                $custom_total_mms_received = $custom_total_mms_received + $custom_lead_mms_received;
                                $custom_total_vm_sent = $custom_total_vm_sent + $custom_lead_vm_sent;

                            }




                            $arrcustom = [
                                'admin_name' => $row->first_name.' '.$row->last_name,
                                'total_custom_leads' => $custom_admin_leads_count,
                                'total_custom_text_sent' => $custom_total_text_sent,
                                'total_custom_mms_sent' => $custom_total_mms_sent,
                                'total_custom_log_sent' => $custom_total_log_sent,
                                'total_custom_email_sent' => $custom_total_email_sent,
                                'total_custom_text_received' => $custom_total_text_received,
                                'total_custom_mms_received' => $custom_total_mms_received,
                                'total_custom_log_received' => $custom_total_log_received,
                                'total_custom_email_received' => $custom_total_email_received,
                                'appointment_set' => $custom_admin_leads_appointment_set,
                                'appointment_showed' => $custom_admin_leads_appointment_showed,

                            ];

                            array_push($custom_break_down, $arrcustom);

                        }
                    }

                    // Today End

                    $data = ['custom_total_text','custom_total_receive','custom_total_sent','custom_total_inbound','custom_total_outbound','custom_break_down','custom_robo_text','custom_robo_mms','custom_total_mms','custom_total_mms_text_received','custom_total_mms_text_sent','custom_total_vm','custom_total_vm_text_sent','custom_robo_vm'];



                    return $this->sendResponse([
                        'leadList' => compact($data) ,
                    ],'leadlist');

//                    return response()->json([
//                        'result' => view('backend.pages.reports.customteamactivity',compact($data))->render(),'status'=>'yes'
//                    ]);

                }

    }
    
}