<?php

namespace App\Http\Controllers\Api;
use Validator;
use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\LeadAppointment;
use App\Companyinfo;
use App\Leadchat;
use App\Voicemailblast;
use App\Permissionallowed;
use App\Blastpercentage;
use App\Uploadblastlibrary;
use Illuminate\Support\Facades\Cache;
use DB;
use App\Traits\PushNotificationTrait;

class VoicemailblastController extends BaseController{

    public function voicemailblast(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){

            $get_lead_blast = Voicemailblast::with('audio')->select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','voicemail_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
                ->where('voicemail_blast.send_id',$user->id)
                ->OrWhere('user_send.parent_user_id',$user->id)
                ->orderby('id','desc')
                ->get();

            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            // $getagents = User::select('users.id','users.first_name','users.last_name')
            //     ->where('parent_user_id',$user->id)
            //     ->get();
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
            ->leftjoin('usertypes','usertypes.id','users.usertype_id')
            ->where('parent_user_id',$user->id)
            ->where('users.approval','approve')
            ->where('users.is_deleted',0)
            ->orderby('id','desc')
            ->get();
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data);

            }

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->selectRaw('count(*) as count, lead_provider')
                ->groupBy('lead_provider')
                ->where('admin_email',$user->email)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
            // Dedicated number
            
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
    
                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            
            return $this->sendResponse([
                'voicemail_blast_view' => $get_lead_blast,
                'total_leads' => $total_leads,
                'agents' => $agents,
                'total_leads_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,

            ],'voicemail_blast_view');

        }
        elseif($user->usertype_id == 4){

            $get_admin_id = User::where('id',$user->id)->first(['parent_user_id']);
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first(['id','email']);

            $get_lead_blast = Voicemailblast::with('audio')->select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
                ->where('voicemail_blast.assigned_id',$user->id)
                ->orderby('id','desc')
                ->get();



            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;

            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = session()->get('id');
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }

            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            $get_admin = User::where('id',$user->id)
                ->first();

            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->groupBy('lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->where('leads.lead_provider','!=','')
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
            // Dedicated number
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
            
            return $this->sendResponse([
                'voicemail_blast_view' => $get_lead_blast,
                'total_leads' => $total_leads,
                'agents' => $agents,
                'total_leads_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,

            ],'voicemail_blast_view');

        }



    }

    public function voicemailPost(Request $request)
    {
        if ($request->file == null && $request->audioUrl == null){
            return response()->json([
                'success' => false,
                'message' => 'File not selected or uploaded',
            ],401);
        }
        $validator =    Validator::make($request->all(), [
            'sendat' => 'required',
            'leadprovider' => 'required',
            'type' => 'required',
            'target_status' => 'required',
            'schedule_time_from' => 'required',
            'schedule_time_to' => 'required',
            'senderid' => 'required',
            'assignedto' => 'required',
            'send_from_number_val' => 'required',
            'audienceVal' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' =>  $validator->messages()->all()[0],
            ],401);
          
        }
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        if ($request->file('file') != null){
            $image = $request->file('file');
            $new_name = rand() . '.' . 'wav';
            $imagePath = $image->move('./asset/voicemail/audio/', $new_name);
            $path = $new_name;
            $completePath = url('/') . '/asset/voicemail/audio/' . $path;
        }
        else{
            $completePath = $request->audioUrl;
        }

        $drafted = null;

        if($request->submit == 'draft')
        {
            $drafted = "no";
        }
        else
        {
            $drafted = "yes";
        }

        $date_from = date('Y-m-d', strtotime($request->schedule_time_from));
        $date_to = date('Y-m-d', strtotime($request->schedule_time_to));
        $time_from = ($request->order_time_from)? date('H:i:s', strtotime($request->order_time_from)):null;
        $time_to = ($request->order_time_to)? date('H:i:s', strtotime($request->order_time_to)):null;
        $mediaUrl = $completePath;

        if($request->type == "All"){
            $type = 0 ;
        }
        else {
            $type = $request->type;
        }
        $sender_id  = null;
        $sender_id = $request->senderid;
        $assign_agent_id = $request->assignedto;

        if($user->usertype_id == 2)
        {
            if($assign_agent_id != '' && $assign_agent_id != 0)
            {
                $assign_agent_id = $assign_agent_id;
            }
            else
            {
                $assign_agent_id = $user->id;
            }
            $sender_id = $user->id;
        }
        else
        {
            $is_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $sender_id = $is_admin->parent_user_id;
            $assign_agent_id = $user->id;
        }
        $data = [
            'user_id' => $sender_id,
            'file' => $completePath,
            'type' => 'rvm'
        ];
        Uploadblastlibrary::insert($data);
        $message_filter = date('m/d/Y', strtotime($request->schedule_time_from))." - ".date('m/d/Y', strtotime($request->schedule_time_to));

        $target_status = explode(',',$request->target_status);
        $target_status_seperator = implode(', ', $target_status);

        $provider = explode(',',$request->leadprovider);
        $leadprovider =  implode(', ', $provider);

        $number_length_home = strlen($request->send_from_number_val);
        if($number_length_home == 10){
            $request->send_from_number_val = '+1'.trim($request->send_from_number_val);
        }
        elseif ($number_length_home == 11){
            $request->send_from_number_val = '+'.trim($request->send_from_number_val);
        }
        elseif ($number_length_home == 12) {
            $request->send_from_number_val = trim($request->send_from_number_val);
        }

        $audienceValMax = 'no';
        if($request->audienceVal > 250)
        {
            $audienceValMax = $request->audienceVal;
        }

        $blast = [
            'campaign_name' => $request->campaign_name,
            'campaign_number' => $request->send_from_number_val,
            'send_limit' => $request->audienceVal,
            'send_at' => $request->sendat,
            'lead_provider' => $leadprovider,
            'message_filter' => $message_filter,
            'message_status' => 'Pending',
            'type' => $type,
            'target_status' => $target_status_seperator,
            'audio_link' => $mediaUrl,
            'assigned_id' => $assign_agent_id,
            'send_id' => $sender_id,
            'date_from' => $date_from,
            'date_to' => $date_to,
            'blast_created_id'=>$user->id,
            'max_blast' => $audienceValMax,
            'is_activated' => $drafted
        ];

        $insert_lead_blast = Voicemailblast::insertGetId($blast);
        
        if($user->usertype_id == 2)
        {
            $titleN      =  'New Ringless VM Blast Created By '.$user->first_name;
            $titleAdmin  =  'New Ringless VM Blast Created By You';
            $total_agent_ids = DB::table('users')->select(['id'])->where('parent_user_id', $user->id)->where("usertype_id", 4)->where("approval", "approve")->whereNotNull('device_token')->pluck("id");
            $user_ids = $total_agent_ids;
            
            PushNotificationTrait::PushNotificationFirebaseSend($user_ids, $titleN, $request->campaign_name,$insert_lead_blast,'rvm_blast');
            PushNotificationTrait::PushNotificationFirebaseSend([$user->id], $titleAdmin, $request->campaign_name,$insert_lead_blast,'rvm_blast');
            
        }elseif($user->usertype_id == 4){
            
            $titleN  =  'New Ringless VM Blast Created By You';
            $titleAdmin  =  'New Ringless VM Blast Created By '.$user->first_name;
            $total_agent_ids = DB::table('users')->select(['id'])->where('id', $user->id)->where("usertype_id", 4)->where("approval", "approve")->whereNotNull('device_token')->pluck("id");
            $user_ids = $total_agent_ids;
        
            PushNotificationTrait::PushNotificationFirebaseSend($user_ids, $titleN, $request->campaign_name,$insert_lead_blast,'rvm_blast');
            PushNotificationTrait::PushNotificationFirebaseSend([$sender_id], $titleAdmin, $request->campaign_name,$insert_lead_blast,'rvm_blast');
            
        }
        
        $this->blastPercentage($insert_lead_blast);

        if($insert_lead_blast){
            return response()->json([
                    'success' => true,
                    'message' => 'Blast added successfully',
                ]);
            return $this->sendResponse([
                'success' => 'true',

                'voicemail_blast_add' => 'Blast added successfully',
            ],'voicemail-blast-add');
        }
        else{
            return response()->json([
                    'success' => false,
                    'message' => 'Something went wrong',
                ]);
            return $this->sendError([
                'success' => 'false',

                'voicemail_blast_add' => 'Something went wrong',
            ],'voicemail-blast-add');
        }

    }

    public function voicemailUpdate(Request $request)
    {
        if ($request->file == null && $request->audioUrl == null){
            return response()->json([
                'success' => false,
                'message' => 'File not selected or uploaded',
            ],401);
           
        }
        
        $validator = Validator::make($request->all(), [
            "submit" => 'required',
            'editsendat' => 'required',
            'edittype' => 'required',
            'edittarget_status' => 'required',
            'schedule_time_from_edit' => 'required',
            'schedule_time_to_edit' => 'required',
            'editsenderid' => 'required',
            'editassignedto' => 'required',
            'send_from_number_val' => 'required',
            'editaudienceVal' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->messages()->all()[0],
            ],401);
            

        }
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();


            $drafted = null;

            if($request->submit == 'draft')
            {
                $drafted = "no";
            }
            else
            {
                $drafted = "yes";
            }
        if ($request->file('file') != null){
            $image = $request->file('file');
            $new_name = rand() . '.' . 'wav';
            $imagePath = $image->move('./asset/voicemail/audio/', $new_name);
            $path = $new_name;
            $completePath = url('/') . '/asset/voicemail/audio/' . $path;
            $mediaUrl = $completePath;

        }
        else{
            $completePath = $request->audioUrl;
            $mediaUrl = $completePath;
        }
        $date_from = date('Y-m-d', strtotime($request->schedule_time_from_edit));
        $date_to = date('Y-m-d', strtotime($request->schedule_time_to_edit));
        $time_from = ($request->order_time_from_edit)? date('H:i:s', strtotime($request->order_time_from_edit)):null;
        $time_to = ($request->order_time_to_edit)? date('H:i:s', strtotime($request->order_time_to_edit)):null;


            $message_filter = date('m/d/Y', strtotime($request->schedule_time_from_edit))." - ".date('m/d/Y', strtotime($request->schedule_time_to_edit));

            $sender_id = $request->editsenderid;
            $assign_agent_id = $request->editassignedto;

            if($request->edittype == "All"){
                $type = 0 ;
            }
            else {
                $type = $request->edittype;
            }

            if($user->usertype_id == 2)
            {
                if($request->editassignedto != '' && $request->editassignedto != 0)
                {
                    $assign_agent_id = $request->editassignedto;
                }
                else
                {
                    $assign_agent_id = $user->id;
                }

                $sender_id = $user->id;
            }
            else
            {
                $is_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $sender_id = $is_admin->parent_user_id;
                $assign_agent_id = $user->id;
            }
        $data = [
            'user_id' => $sender_id,
            'file' => $completePath,
            'type' => 'rvm'
        ];
        Uploadblastlibrary::insert($data);

            $target_status = explode(',',$request->edittarget_status);
            $target_status_seperator = implode(', ', $target_status);

            $provider = explode(',',$request->editleadprovider);
            $leadprovider =  implode(', ', $provider);

//            $target_status_seperator = $request->edittarget_status;
//            $leadprovider = $request->editleadprovider;

//            $request->send_from_number_val = str_replace('(','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace(')','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace('-','',$request->send_from_number_val);
//            $request->send_from_number_val = str_replace(' ','',$request->send_from_number_val);

            $number_length_home = strlen($request->send_from_number_val);
            if($number_length_home == 10){
                $request->send_from_number_val = '+1'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 11){
                $request->send_from_number_val = '+'.trim($request->send_from_number_val);
            }
            elseif ($number_length_home == 12) {
                $request->send_from_number_val = trim($request->send_from_number_val);
            }

            $audienceValMax = 'no';
            if($request->editaudienceVal > 250)
            {
                $audienceValMax = $request->editaudienceVal;
            }

            $blast = [
                'campaign_name' => $request->campaign_name,
                'campaign_number' => $request->send_from_number_val,
                'send_limit' => $request->editaudienceVal,
                'send_at' => $request->editsendat,
                'lead_provider' => $leadprovider,
                'message_filter' => $message_filter,
                'message_status' => 'Pending',
                'type' => $type,
                'target_status' => $target_status_seperator,
                'audio_link' => $mediaUrl,
                'assigned_id' => $assign_agent_id,
                'send_id' => $sender_id,
                'date_from' =>$date_from,
                'date_to' => $date_to,
                'blast_created_id'=>$user->id,
                'max_blast' => $audienceValMax,
                "is_activated" => $drafted,
            ];

            $insert_lead_blast = Voicemailblast::where('id',$request->editleadblastid)->update($blast);

            $this->blastPercentage($request->editleadblastid);

            if($insert_lead_blast){
                 return response()->json([
                    'success' => true,
                    'message' => 'Voicemail blast updated successfully',
                ],200);
               
            }
            else{
                return response()->json([
                    'success' => false,
                    'message' => 'Something went wrong',
                ],401);
            }

    }

    public function blastPercentage($blast_id)
    {
        $admin_id = null;
        $get_lead_blast = Voicemailblast::select('voicemail_blast.*','users.id as user_id','users.usertype_id as usertype_id')
            ->leftjoin('users','users.id','voicemail_blast.assigned_id')
            ->where('voicemail_blast.id',$blast_id)
            ->get();

        if($get_lead_blast->count() > 0)
        {
            foreach ($get_lead_blast as $leadblast)
            {
                $splitStatus = explode(', ', $leadblast->target_status);
                $splitDate = explode(' - ', $leadblast->message_filter);
                $splitlead_provider = explode(', ', $leadblast->lead_provider);

                $startdate = date("Y-m-d", strtotime($splitDate[0]));
                $enddate = date("Y-m-d", strtotime($splitDate[1]));

                if($leadblast->usertype_id == 2){
                    $get_admin_email = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $leadblast->user_id;

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::wherein('lead_provider',$splitlead_provider)
                            ->where('admin_email',$get_admin_email->email)
                            ->whereNotNull('contact')
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set','Invalid Cell Number'])
                            ->whereIn('lead_status',$splitStatus)
                            ->get();
                    }
                    else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereNotNull('contact')
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set','Invalid Cell Number'])
                            ->whereIn('lead_status',$splitStatus)
                            ->get();
                    }
                }
                else{
                    $get_agent = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $get_agent->parent_user_id;
                    $get_admin_email = DB::table('users')->where('id',$get_agent->parent_user_id)->first();

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::wherein('lead_provider',$splitlead_provider)
                            ->where('admin_email',$get_admin_email->email)
                            ->whereNotNull('contact')
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set','Invalid Cell Number'])
                            ->where('assigned_user_id',$leadblast->user_id)
                            ->whereIn('lead_status',$splitStatus)
                            ->where('assigned_user_id',$leadblast->assigned_id)
                            ->get();
                    }else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereNotNull('contact')
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set','Invalid Cell Number'])
                            ->where('assigned_user_id',$leadblast->user_id)
                            ->whereIn('lead_status',$splitStatus)
                            ->where('assigned_user_id',$leadblast->assigned_id)
                            ->get();
                    }
                }

                $leads_id = array();
                $count = 1;
                foreach($leads as $lead){
                    $leads_id[] .= $lead->id;
                }

                $check_blast_exist = Blastpercentage::where('blast_id',$blast_id)->where('blast_type','call')->first(['blast_id']);
                $check_blast_call_exist = DB::table('blast_leads')->where('blast_id',$blast_id)->where('blast_type','call')->first(['blast_id']);
                
                if($check_blast_exist == null)
                {
                    Blastpercentage::insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'call', 'leads_id' => implode(",",$leads_id)]);
                }
                else
                {
                    Blastpercentage::where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                }
                
                if($check_blast_call_exist == null)
                {
                    DB::table('blast_leads')->insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'call', 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }
                else
                {
                    DB::table('blast_leads')->where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }
            }
        }
    }

    public function voicemailDelete(Request $request){
                $check_lead_blast = Voicemailblast::where('id',$request->leadblastid)
                    ->delete();

                Blastpercentage::where('blast_id',$request->leadblastid)->where('blast_type','call')->delete();

                if($check_lead_blast){
                    
                    return response()->json([
                            'success' => true,
                            'message' => 'Ringless Voicemail Blast Remove Successfully',
                        ],200);
                    
                    return $this->sendResponse([
                        'success' => 'true',

                        'rvm_blast_remove' => 'Ringless Voicemail Blast Remove Successfully',
                    ],'rvm_blast_remove');
                }
                else{
                    return response()->json([
                            'success' => false,
                            'message' => 'Something went wrong while deleting',
                        ],401);
                    
                    return $this->sendError([
                        'success' => 'false',

                        'rvm_blast_remove' => 'Something went wrong while deleting',
                    ],'rvm_blast_remove');
                }

    }

    public function getRvmLibrary(Request $request)
    {

            $admin_email = $request->adminemail;
            $blast_type = $request->type;
            $output = "";
            $admin_id = null;
            $admin_info = "";

            if($admin_email > 0)
            {
                $admin_info = User::where('id',$admin_email)->first(['id','usertype_id','parent_user_id']);
            }
            else
            {
                $admin_info = User::where('email',$admin_email)->first(['id','usertype_id','parent_user_id']);
            }

            if($admin_info->usertype_id == 2)
            {
                $admin_id = $admin_info->id;
            }
            else
            {
                $admin_id = $admin_info->parent_user_id;
            }


            $upload_blast_library = Uploadblastlibrary::where('user_id',$admin_id)->where('type','rvm')->orderBy('id','desc')->get();

            return $this->sendResponse([
                'uploaded_list1' => $upload_blast_library,
            ],'uploaded_list');
            

    }
    
    public function uploadRvmLibrary(Request $request){
        
        $validator = Validator::make($request->all(), [
            'file' => 'required',
            'name' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->messages()->all()[0],
            ],401);
            

        }
        
        $user_id = auth()->user()->id;
        
        if($request->isMethod('post')){
            
            $file = $request->file('file');
            $check_extension = $file->getClientOriginalExtension();

            if ($check_extension == 'mp3' || $check_extension == 'wav') {
                $audioName = $request->name;
                $audioDescription = $request->description;

                $new_name = rand() . '.' . $file->getClientOriginalExtension();
                $imagepath = $file->move('./asset/voicemail/audio', $new_name);
                $path = $new_name;
                $completePath = url('/') . '/asset/voicemail/audio/' . $path;
                // $stored_audio = Uploadblastlibrary::insert([
                //     'user_id' => $user_id,
                //     "file" => $completePath,
                //     "type" => 'rvm',
                //     "name" =>$audioName,
                //     "description" =>$audioDescription,
                // ]);
                $stored_audio = new Uploadblastlibrary([
                    'user_id' => $user_id,
                    "file" => $completePath,
                    "type" => 'rvm',
                    "name" => $audioName,
                    "description" => $audioDescription,
                ]);
                
                $stored_audio->save();
                
                // Retrieve the complete model instance
                $stored_audio = $stored_audio->fresh();
                return response()->json([
                    'success' =>   true,
                    'message' =>   'File Uploaded Successfully!',
                    'data' => $stored_audio
                ]);
            }else{
                return response()->json([
                    'success' =>   false,
                    'message' =>   'Please upload MP3 or Wav extention file'
                ]);
            }
        }
    }
    
    public function rvmDraft(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){

            $get_lead_blast = Voicemailblast::with('audio')->select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_send','user_send.id','voicemail_blast.send_id')
                ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
                ->where('message_status','Pending')
                ->where('is_activated','no')
                ->where('voicemail_blast.send_id',$user->id)
                ->OrWhere('user_send.parent_user_id',$user->id)
                ->orderby('id','desc')
                ->get();

            $total_leads = Lead::where('admin_email',$user->email)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            // $getagents = User::select('users.id','users.first_name','users.last_name')
            //     ->where('parent_user_id',$user->id)
            //     ->get();
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
            ->leftjoin('usertypes','usertypes.id','users.usertype_id')
            ->where('parent_user_id',$user->id)
            ->where('users.approval','approve')
            ->where('users.is_deleted',0)
            ->orderby('id','desc')
            ->get();
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data);

            }

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->selectRaw('count(*) as count, lead_provider')
                ->groupBy('lead_provider')
                ->where('admin_email',$user->email)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
            // Dedicated number
            
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 2)
            {
                $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
    
                $country_code = '+1';
                $dedicated_number = ltrim($dedicated_number, $country_code);
            }
            
            return $this->sendResponse([
                'voicemail_blast_draft_view' => $get_lead_blast,
                'total_leads' => $total_leads,
                'agents' => $agents,
                'total_leads_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,

            ],'voicemail_blast_draft_view');

        }
        elseif($user->usertype_id == 4){

            $get_admin_id = User::where('id',$user->id)->first(['parent_user_id']);
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first(['id','email']);

            $get_lead_blast = Voicemailblast::with('audio')->select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
                ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
                ->where('message_status','Pending')
                ->where('is_activated','no')
                ->where('voicemail_blast.assigned_id',$user->id)
                ->orderby('id','desc')
                ->get();



            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;

            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = session()->get('id');
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }

            $total_leads = Lead::where($assigned_column,$assigned_agents)
                ->where('lead_status','Active-Fresh')
                ->count('*');

            $get_admin = User::where('id',$user->id)
                ->first();

            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->groupBy('lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->where('leads.lead_provider','!=','')
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            
            // Dedicated number
            $get_dedicated_number = null;
            $dedicated_number = null;
            if($user->usertype_id == 4)
            {
                $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
                $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);
    
                $dedicated_number = $get_dedicated_number->phone_number;
                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
                {
                    $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
                }
            }
            
            return $this->sendResponse([
                'voicemail_blast_draft_view' => $get_lead_blast,
                'total_leads' => $total_leads,
                'agents' => $agents,
                'total_leads_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,

            ],'voicemail_blast_draft_view');

        }



    }

}