<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    protected $table = 'leads';
    // protected $appends = ['sent_chatlogs_count','recevied_chatlogs_count','sent_rvmlogs_count','received_rvmlogs_count','sent_phonelogs_count','received_phonelogs_count','sent_emaillogs_count','received_emaillogs_count'];

    
    public function appointment()
    {
        return $this->hasMany('App\LeadAppointment');
    }
    
    public function firstAppointment()
    {
        return $this->hasOne('App\LeadAppointment')->orderBy('id','desc');
    }
    
    public function lead()
    {
        return $this->hasOne('App\lead','id','id');
    }
    
    public function chatlogs()
    {
        return $this->hasMany('App\Leadchat')->orderBy('id','desc');
    }
    
    public function getSentChatlogsCountAttribute()
    {
        return $this->chatlogs()->where(function($query){
            $query->where('type', 'sent')->orWhere->where('type', null);
        })->where('ringless_voicemail',null)->count();
    }
    
    public function getReceviedChatlogsCountAttribute()
    {
        return $this->chatlogs()->where('ringless_voicemail',null)->where('type', 'received')->count();
    }
    
    public function phonelogs()
    {
        return $this->hasMany('App\Leadlog')->orderBy('id','desc');
    }
    
    public function getSentPhonelogsCountAttribute()
    {
        return $this->phonelogs()->where('status', 'outbound')->count();
    }
    
    public function getReceivedPhonelogsCountAttribute()
    {
        return $this->phonelogs()->where('status', 'incoming')->count();
    }
    
    public function rvmlogs()
    {
        return $this->hasMany('App\Leadchat')->orderBy('id','desc');
    }
    
    public function getSentRvmlogsCountAttribute()
    {
        return $this->rvmlogs()->where(function($query){
            $query->where('type', 'sent')->orWhere->where('type', null);
        })->where('mms_attachments',null)->where('ringless_voicemail','!=',null)->count();
    }
    
    public function getReceivedRvmlogsCountAttribute()
    {
        return $this->rvmlogs()->where('mms_attachments',null)->where('ringless_voicemail','!=',null)->where('type', 'received')->count();
    }
    
    public function emailLogs()
    {
        return $this->hasMany('App\Contactemail','to','email');
    }
    
    public function getSentEmaillogsCountAttribute()
    {
        return $this->emailLogs()->where('type', 'sent')->where('sender_id',auth()->id())->count();
    }
    
    public function getReceivedEmaillogsCountAttribute()
    {
        return $this->emailLogs()->where('type', 'received')->where('sender_id',auth()->id())->count();
    }
    
    public function notes()
    {
        return $this->hasMany('App\Leadnote')->orderBy('id','desc');
    } 
    
    public function leadInventory()
    {
        return $this->hasOne('App\Leadinventoryinfo')->orderBy('id','desc');
    }     

}