<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateManualLeadTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('manual_lead', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title',200);
            $table->string('lead_provider',200);
            $table->string('admin_email',250);
            $table->string('assigned_date',200);
            $table->string('email',150)->unique();
            $table->string('contact',50);
            $table->string('status',50);
            $table->string('classification',200);
            $table->string('sender_first_name',200);
            $table->string('sender_last_name',200);
            $table->string('company',200);
            $table->text('address');
            $table->integer('assigned_user_id');
            $table->string('lead_status',200);
            $table->string('admin_permission',250);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('manual_lead');
    }
}
