<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Illuminate\Http\Request;
use DB;

class LeadBulkCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'lead:bulk';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $curr_date = date("H:i:s");
        $fix_date = '10:01:00';
        $end_date = '18:05:00';
        
        if($curr_date > $fix_date && $curr_date < $end_date)
        {
            $bulk_limit = DB::table('user_import_limits')->where('bulk_run','yes')->get();
            
            if($bulk_limit->count() > 0)
            {
                $sid    = 'AC15298329064d30e708bdc83adb95dc54';
                $token  = '5b99af1b1a553786d497d3072c1e29ac'; 
                $client = new Client( $sid, $token );
                
                foreach($bulk_limit as $bulk_limit)
                {
                    $get_admin = DB::table('users')->where('id',$bulk_limit->user_id)->first();
                    $user_email = $get_admin->email;
                    $user_id = $get_admin->id;
                    
                    $get_company = DB::table('company_info')->where('user_id',$user_id)->first();
                    $user_contact = $get_company->phone_number;
                    
                    $leadsDataRobo = DB::table('lead_bulk')->where('admin_email',$user_email)->where('bulk_status','no')->where('contact','!=',null)->take($bulk_limit->bulk_limit)->get();
                
                    if($leadsDataRobo->count() > 0)
                    {
        	            foreach($leadsDataRobo as $lead)
        	            {
        	                DB::table('lead_bulk')->where('id',$lead->id)->update(['bulk_status'=>'yes']);
        	                
        	                $check_email = null;
        	                $check_phone = null;
        	                $send_message = null;
        	                
        	                if(empty($lead->email))
                            {
                                $check_email = null;
                            }else
                            {
                                $check_email = DB::table('leads')->where('email',$lead->email)->where('admin_email',$user_email)->first();
                            }
                            
                            if(empty($lead->contact))
                            {
                                $check_phone = null;
                            }else
                            {
                                $check_phone = DB::table('leads')->where('contact',$lead->contact)->where('admin_email',$user_email)->first();
                            }
                            
                            if($check_phone == null)
                            {
                                if($check_email == null)
                                {
                                    $phone_no = null;
                                    
                                    if($lead->contact == null)
                                    {
                                        $phone_no = null;
                                    }else
                                    {
                                        $phone = str_replace(array("+","-","(",")"," ","_"), "",$lead->contact);
                                        
                                        $number_length = strlen($phone);
                                        if($number_length == 10){
                                            $phone_no = '+1'.trim($phone);
                                        }
                                        elseif ($number_length == 11){
                                            $phone_no = '+'.trim($phone);
                                        }
                                        elseif ($number_length == 12) {
                                            $phone_no = '+'.trim($phone);
                                        }
                                    }
                                    
                                    $first_name = "Unknown";
                                    $last_name = "Unknown";
                                    
                                    if(!empty($lead->sender_first_name))
                                    {
                                        $first_name = $lead->sender_first_name;
                                    }
                                    
                                    if(!empty($lead->sender_last_name))
                                    {
                                        $last_name = $lead->sender_last_name;
                                    }
                                    
                	                $leads = [
                                      'title' => null, 
                                      'lead_provider' => $lead->lead_provider,
                                      'admin_email' => $user_email,
                                      'assigned_date' => date("d-m-Y"),
                                      'email' => $lead->email,
                                      'contact' => $phone_no,
                                      'status' => "unassigned",
                                      'classification' => "Sales",
                                      'sender_first_name' => $first_name,
                                      'sender_last_name' => $lead->sender_last_name,
                                      'company' => null,
                                      'address' => $lead->address,
                                      'city' => $lead->city,
                                      'state' => $lead->state,
                                      'zip' => $lead->zip,
                                      'assigned_user_id' => null,
                                      'lead_status' => "Active-Fresh",
                                    ];
                                    
                			        $response = DB::table('leads')->insertGetId($leads);
                			        
                			        
                			        $robotext = DB::table('manaul_robo_text')->where('sender_id',$user_id)->where('type','bulk')->where('status','active')->first();
                			        $message_body = null;
                			        
                			        if($first_name == 'Unknown')
                			        {
                			            $message_body = "Hey,".$robotext->text;
                			        }
                			        else
                			        {
                			            $message_body = "Hey ".$first_name.",".$robotext->text;
                			        }
                			        
                			        if($phone_no != null)
                			        {
                    			        try{
                                            $send_message = $client->messages->create(
                                                $phone_no,
                                                array(
                                                    'from' => $user_contact,
                                                    'body' => $message_body,
                                                )
                                            );
                                        } catch(\Twilio\Exceptions\RestException $e){
                                            DB::table('leads')->where('id',$response)->update(['lead_status' => 'Wrong Number']);
                                            $send_message = null;
                                        }
                			        }
                			        else
                			        {
                			            DB::table('leads')->where('id',$response)->update(['lead_status' => 'Invalid Cell Number']);
                                        $send_message = null;
                			        }
                                }
                            }
                            
                            if($send_message != null)
                            {
                                $get_max_value = DB::table('lead_chat')->max('chat_id');
                                
                                $count = $get_max_value + 1;
        
                                $send = [
                                'admin_id' => $user_id,
                                'lead_id' => $response,
                                'from' => $user_contact,
                                'to' => $phone_no,
                                'message' => $message_body,
                                'internal' => 0,
                                'chat_id' => $count,
                                'seen' => 'bulk'
                                ];
                                
                                $message_insert = DB::table('lead_chat')->insert($send);
                            }
                            
        	                DB::table('user_import_limits')->where('id',$bulk_limit->id)->update(['bulk_run'=>'no']);
        	            }
        	            
        	        }
                }
            }
    	}
    }
}
