<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\LeadAppointment;
use App\Leadblast;
use Permissionallowed;
use App\Blastpercentage;
use App\Companyinfo;
use App\Companyextranumber;
use App\Feedback;
use App\Feedbachchat;
use Illuminate\Support\Facades\Cache;



class FeedbackController extends BaseController
{
    public function getFeedbacks(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            if($user->usertype_id == 2){

                $get_feedback = Feedback::select('feedback.*','users.first_name','users.last_name','users.usertype_id','usertypes.name')
                    ->leftjoin('users','users.id','feedback.user_id')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->where('feedback.user_id',$user->id)
                    ->orwhere('feedback.admin_id',$user->id)
                    ->orderBy('feedback.id','desc')
                    ->get();

            }elseif($user->usertype_id == 4){
                $get_feedback = Feedback::select('feedback.*','users.first_name','users.last_name','users.usertype_id','usertypes.name')
                    ->leftjoin('users','users.id','feedback.user_id')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->where('feedback.user_id',$user->id)
                    ->orwhere('feedback.agent_id',$user->id)
                    ->orderBy('feedback.id','desc')
                    ->get();
            }else{
                $get_feedback = Feedback::select('feedback.*','users.first_name','users.last_name','users.usertype_id','usertypes.name')
                    ->leftjoin('users','users.id','feedback.user_id')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->where('feedback.created_by',$user->id)
                    ->orderBy('feedback.id','desc')
                    ->get();
            }
        return $this->sendResponse([
            'feedback_view' => $get_feedback,
        ],'feedback_view');

    }

    public function getrandom()
    {
        $fourdigitrandom = mt_rand(1000, 9999);

        $check_if_exist = Feedback::where('ticket', $fourdigitrandom)->first('ticket');

        if ($check_if_exist == null)
        {
            return $fourdigitrandom;
        }
        else{
            $this->getrandom();
        }
    }

    public function feedbackPost(Request $request)
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();


            $fourdigitrandom = $this->getrandom();


             if ($user->usertype_id == 4) {

                $agent_id = $user->id;
                $getAdmin = User::where('id', $user->id)->first(['parent_user_id']);

                $admin_id = $getAdmin->parent_user_id;
                $user_id = $user->id;
            }
        if ($user->usertype_id == 2) {

                $agent_id = null;
                $admin_id = $user->id;
                $user_id = $user->id;
            }
            $data = [
                'admin_id' => $admin_id,
                'agent_id' => $agent_id,
                'subject' => $request->subject,
                'message' => $request->message,
                'ticket' => $fourdigitrandom,
                'status' => 'Pending',
                'user_id' => $user_id,
                'created_by' => $user->id,
            ];
            //dd($data);
            $insert = Feedback::insert($data);
            $get_feedback_id = Feedback::where('ticket', $fourdigitrandom)
                ->first('id');
            $get_feedback = Feedback::select('feedback.*', 'users.*')
                ->from('feedback')
                ->leftjoin('users', 'users.id', 'feedback.user_id')
                ->leftjoin('usertypes', 'usertypes.id', 'users.usertype_id')
                ->where('feedback.id', $get_feedback_id->id)
                ->orderBy('feedback.id', 'desc')
                ->first();
            $send = [
                'feedback_id' => $get_feedback_id->id,
                'from' => $get_feedback->email,
                'to' => 'tech@text10x.ai',
                'message' => $request->message,
                'type' => 'received',
                'sender_name' => $user->first_name
            ];
            //dd($send);
            $insert_feedback_chat = Feedbachchat::insert($send);
            if ($insert && $insert_feedback_chat) {

                return $this->sendResponse([
                    'feedback_submit' => 'Feedback Submited Succeessfully',
                ],'feedback_submit');
            } else {

                return $this->sendResponse([
                    'feedback_submit' => 'Something went rong' ,
                ],'feedback_submit');
            }
    }

    public function feedbackImageFiles(Request $request){

//            dd($request->files);

            $countfiles = count($_FILES['files']['name']);
            $files_arr = array();
            $shortener = app('url.shortener');
            $upload_location = "./asset/chat-assets/images/";
            for($index = 0;$index < $countfiles;$index++){
                if(isset($_FILES['files']['name'][$index]) && $_FILES['files']['name'][$index] != ''){
                    // File name
                    $filename = $_FILES['files']['name'][$index];
                    // Get extension
                    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                    // Valid image extension
                    $valid_ext = array("png","jpeg","jpg");
                    $new_name = rand() . '.' .$ext;

                    // Check extension
                    if(in_array($ext, $valid_ext)){
                        $path = $upload_location.$new_name;
                        $completePath = url('/').'/asset/chat-assets/images/'.$new_name;
                        $shortUrl = $shortener->driver('is_gd')->shorten($completePath);
                        if(move_uploaded_file($_FILES['files']['tmp_name'][$index],$path)){
                            $files_arr[] = $shortUrl;
                        }
                    }
                }
            }
            return response()->json([
                'message'   => $files_arr,
            ]);

    }

    // pop up of feedback to appear

    public function showFeedbackChatPopup(){

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $get_2nd_name = User::where('id',$user->id)
                ->value('last_name');
            $full_name = $user->first_name." ".$get_2nd_name;

            if ($user->usertype_id == 2){

                $get_id = Feedback::where('user_id',$user->id)
                    ->orwhere('admin_id',$user->id)
                    ->pluck('id');

                $get_count = Feedbachchat::wherein('feedback_id',$get_id)
                    ->where('seen','no')->where('sender_name','!=',$full_name)->where('sender_name','!=',$user->first_name)
                    ->count('*');
            }
            else if($user->usertype_id == 4)
            {
                $get_id = Feedback::where('agent_id',$user->id)
                    ->pluck('id');
                $get_count = Feedbachchat::wherein('feedback_id',$get_id)
                    ->where('seen','no')->where('sender_name','!=',$full_name)->where('sender_name','!=',$user->first_name)
                    ->count('*');
            }
            if($get_count != 0)
            {
                return response()->json([
                    'count'   => $get_count,
                ]);
            }
            else
            {
                return response()->json([
                    'count'   => 'no',
                ]);
            }


    }

    // when click on the opo up go to the feedack page

    public function getAllFeedbackMessage(){
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $get_2nd_name = User::where('id',$user->id)
                ->value('last_name');
            $full_name = $user->first_name." ".$get_2nd_name;

            if($user->usertype_id == 2){
                $get_id = Feedback::where('user_id',$user->id)
                    ->orwhere('admin_id',$user->id)
                    ->pluck('id');
                $get_chat = Feedbachchat::distinct('feedback_id')
                    ->wherein('feedback_id',$get_id)
                    ->where('seen','no')->where('sender_name','!=',$full_name)->where('sender_name','!=',$user->first_name)
                    ->pluck('feedback_id');
                $get_feedback = Feedback::select('feedback.*','users.first_name','users.last_name','users.usertype_id','usertypes.name')
                    ->leftjoin('users','users.id','feedback.user_id')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->wherein('feedback.id',$get_chat)
                    ->orderBy('feedback.id','desc')
                    ->get();
                return $this->sendResponse([
                    'feedback_messages' => $get_feedback ,
                ],'feedback_messages');
            }
            elseif($user->usertype_id == 4){
                $get_id = DB::table('feedback')
                    ->where('user_id',$user->id)
                    ->orwhere('feedback.agent_id',$user->id)
                    ->pluck('id');
                $get_chat = DB::table('feedback_chat')
                    ->distinct('feedback_id')
                    ->wherein('feedback_id',$get_id)
                    ->where('seen','no')->where('sender_name','!=',$full_name)->where('sender_name','!=',$user->first_name)
                    ->pluck('feedback_id');
                $get_feedback = DB::table('feedback')
                    ->select('feedback.*','users.first_name','users.last_name','users.usertype_id','usertypes.name')
                    ->leftjoin('users','users.id','feedback.user_id')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->wherein('feedback.id',$get_chat)
                    ->orderBy('feedback.id','desc')
                    ->get();
                return $this->sendResponse([
                    'feedback_messages' => $get_feedback ,
                ],'feedback_messages');
            }
            else{
                $get_id = DB::table('feedback')
                    ->where('created_by',$user->id)
                    ->pluck('id');
                $get_chat = DB::table('feedback_chat')
                    ->distinct('feedback_id')
                    ->wherein('feedback_id',$get_id)
                    ->where('seen','no')
                    ->pluck('feedback_id');
                $get_feedback = DB::table('feedback')
                    ->select('feedback.*','users.first_name','users.last_name','users.usertype_id','usertypes.name')
                    ->leftjoin('users','users.id','feedback.user_id')
                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                    ->wherein('feedback.id',$get_chat)
                    ->orderBy('feedback.id','desc')
                    ->get();
                return $this->sendResponse([
                    'feedback_messages' => $get_feedback ,
                ],'feedback_messages');
            }

    }

    //when go to the feedback page then clickin on the feedbak to go to chat page

    public function getFeedbackscustom(Request $request)
    {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $id = $request->id;

        session()->put('feedbackchat',$request->path());



                $get_2nd_name = User::where('id',$user->id)
                    ->value('last_name');
                $full_name = $user->first_name." ".$get_2nd_name;

            $updatechat = Feedbachchat::where('sender_name','!=',$full_name)->where('sender_name','!=',$user->first_name)
                ->update(['seen' => 'yes']);

            $get_feedback = Feedback::select('feedback.*', 'users.first_name', 'users.last_name', 'users.usertype_id', 'usertypes.name')
                ->leftjoin('users', 'users.id', 'feedback.user_id')
                ->leftjoin('usertypes', 'usertypes.id', 'users.usertype_id')
                ->where('feedback.id', $id)
                ->orderBy('feedback.id', 'desc')
                ->first();

        return $this->sendResponse([
            'feedback_chat' => $get_feedback ,
        ],'feedback_chat');

    }

    public function messageSendfeedback(Request $request){

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                $get_feedback_status = Feedback::where('id',$request->leadnumber)
                    ->first(['status']);
                if ($get_feedback_status->status=="Completed"){
                    $status = 'Completed';

                    return $this->sendResponse([
                        'lead_all_messages' => $status ,
                    ],'lead_all_messages');
                }
                else{
                    $get_feedback_id = Feedback::where('id',$request->leadnumber)
                        ->first(['id']);
                    $get_feedback_from = Feedbachchat::select('feedback_chat.from')
                        ->where('feedback_chat.feedback_id',$get_feedback_id->id)
                        ->first('from');
                    $check_admin = Companyinfo::select('company_info.*','users.email as admin','users.id as private_id')
                        ->leftjoin('users','company_info.user_id','users.id')
                        ->where('users.id',1)
                        ->first();

                    $ldate = date('Y-m-d H:i:s');

                    $sender_name = User::where('id',$user->id)->first(['first_name','last_name']);

                    if($check_admin != null)
                    {
                        $send = [
                            'feedback_id' => $get_feedback_id->id,
                            'from' => $get_feedback_from->from,
                            'to' => $check_admin->suite,
                            'message' => $request->leadmessage,
                            'created_at' => $ldate,
                            'type' => 'received',
                            'sender_name' => $sender_name->first_name." ".$sender_name->last_name,
                        ];

                        $message_insert = Feedbachchat::insert($send);

                        if($message_insert){
                            $get_feedback = Feedbachchat::select('feedback_chat.*')
                                ->from('feedback')
                                ->leftjoin('users','users.id','feedback.user_id')
                                ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                ->leftjoin('feedback_chat','feedback.id','feedback_chat.feedback_id')
                                ->where('feedback_chat.feedback_id',$get_feedback_id->id)
                                ->orderBy('feedback.id','desc')
                                ->get();

                                $id='no';

                            return $this->sendResponse([
                                'lead_all_messages' => $get_feedback ,
                                'super' => $id
                            ],'lead_all_messages');

                        }

                    }
                }



    }

    
}