<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Studio\V2;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class FlowValidateOptions {
    /**
     * @param string $commitMessage The commit_message
     * @return UpdateFlowValidateOptions Options builder
     */
    public static function update(string $commitMessage = Values::NONE): UpdateFlowValidateOptions {
        return new UpdateFlowValidateOptions($commitMessage);
    }
}

class UpdateFlowValidateOptions extends Options {
    /**
     * @param string $commitMessage The commit_message
     */
    public function __construct(string $commitMessage = Values::NONE) {
        $this->options['commitMessage'] = $commitMessage;
    }

    /**
     * The commit_message
     *
     * @param string $commitMessage The commit_message
     * @return $this Fluent Builder
     */
    public function setCommitMessage(string $commitMessage): self {
        $this->options['commitMessage'] = $commitMessage;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Studio.V2.UpdateFlowValidateOptions ' . \implode(' ', $options) . ']';
    }
}