<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Leadchat;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//email fetch route


Route::get("/access/denied", function(){
    return View::make("403");
})->name('access_denied');

// Route::get('/','Auth\AccountController@loginredirect')->name('loginredirect');


// 	Route::get('/','Auth\AccountController@loginView')->name('login');
// 	Route::post('/login-account','Auth\AccountController@login')->name('login-account');
// 	Route::get('/logout','Auth\AccountController@logout')->name('logout');
// 	Route::get('/signup','Auth\AccountController@signup')->name('signup');
// 	Route::post('/validate-signup','Auth\AccountController@validate_signup')->name('validate_signup');



Route::get('/stream',function(){
    $id = 1;
    $leads = Leadchat::latest()
                ->first();
    if($leads){
        return response()->stream(function () use ($leads) {
            while (true) {
                $leads = Leadchat::where('stream_check',0)->latest()
                ->first();
                if ($leads) {
                    echo '{data: ' . $leads . ' }' . "\n\n";
                }
    
                ob_flush();
                flush();
    
                // Break the loop if the client aborted the connection (closed the page)
                if (connection_aborted()) {
                    break;
                }
                usleep(5000000); // 50ms
                
            }
        }, 200, [
            'Cache-Control' => 'no-cache',
            'Content-Type' => 'text/event-stream',
        ]);
    }else{
         return response()->json([
                'success' => false,
                'data' => null,
            ],404);
    }
});