<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Carbon\Carbon;
use DB;

class MaxBlastCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'max:blast';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $date = date("H:i");
        $sendSmstime = "10:55";
        $sendSmstimeAfter = "17:05";
        
        
        if($date > $sendSmstime && $date < $sendSmstimeAfter)
        {
            $sid    = 'AC15298329064d30e708bdc83adb95dc54';
            $token  = '5b99af1b1a553786d497d3072c1e29ac'; 
            $client = new Client( $sid, $token );
            
            // sms bulk blast
            $get_lead_blast = DB::table('lead_blast')
                            ->select('lead_blast.*','users.id as user_id','users.usertype_id as usertype_id')
                            ->leftjoin('users','users.id','lead_blast.send_id')
                            ->where('message_status','Pending')
                            ->where('max_blast','!=','no')
                            ->where('is_activated','yes')
                            ->get();
                          
            if($get_lead_blast->count() > 0)
            {
                foreach ($get_lead_blast as $leadblast) {
                    $splitStatus = explode(', ', $leadblast->target_status);
                    $splitDate = explode(' - ', $leadblast->message_filter);
             
                    $startdate = date("Y-m-d ".$leadblast->time_from, strtotime($splitDate[0]));
                    $enddate = date("Y-m-d ".$leadblast->time_to, strtotime($splitDate[1]));
                  
                    if($leadblast->usertype_id == 2){
                        $get_admin_email = DB::table('users')->where('id',$leadblast->user_id)->first();
                        $admin_id = $leadblast->user_id;
                    
                        if($leadblast->lead_provider != "0"){
                          $leads = DB::table('leads')
                                      ->where('lead_provider',$leadblast->lead_provider)
                                      ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                      ->where('admin_email',$get_admin_email->email)
                                      ->whereBetween('created_at',[$startdate,$enddate])
                                      ->skip(0)->take(240)
                                      ->get();
                        }
                        else{
                          $leads = DB::table('leads')
                                    ->where('admin_email',$get_admin_email->email)
                                    ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                    ->whereBetween('created_at',[$startdate,$enddate])
                                    ->skip(0)->take(240)
                                    ->get();
                        }
                    }
                    else{
                        $get_agent = DB::table('users')->where('id',$leadblast->user_id)->first();
                        $admin_id = $get_agent->parent_user_id;
                        $get_admin_email = DB::table('users')->where('id',$get_agent->parent_user_id)->first();
                        
                        if($leadblast->lead_provider != "0"){
                          $leads = DB::table('leads')
                                      ->where('lead_provider',$leadblast->lead_provider)
                                      ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                      ->where('admin_email',$get_admin_email->email)
                                      ->whereBetween('created_at',[$startdate,$enddate])
                                      ->skip(0)->take(240)
                                      ->get();
                        }else{
                          $leads = DB::table('leads')
                                      ->where('admin_email',$get_admin_email->email)
                                      ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                      ->whereBetween('created_at',[$startdate,$enddate])
                                      ->skip(0)->take(240)
                                      ->get();
                        }
                    }
                  
                    $count = 1;
                    foreach($leads as $lead)
                    {
                        for($i = 0; $i < count($splitStatus); $i++)
                        {
                            if($lead->lead_status == $splitStatus[$i]){
                        
                                if($leadblast->max_blast < 1){
                                    $get_admin_contact = DB::table('company_info')
                                                    ->select('company_info.*','users.email as admin')
                                                    ->leftjoin('users','company_info.user_id','users.id')
                                                    ->where('users.email',$lead->admin_email)
                                                    ->first();
                
                                    if ($get_admin_contact != null) {
                                        
                                        $final_date_filter = date("m/d/Y", strtotime($leadblast->date_from))." - ".$splitDate[1];
                                        DB::table('lead_blast')->where('id',$leadblast->id)->update(["message_filter" => $final_date_filter, "max_bulk" => $leadblast->send_limit, "message_status" => 'Sent']);
                                        
                                        return "true";
                                    }
                                }
                                else
                                {
                                    $final_date_filter = date("m/d/Y", strtotime($lead->created_at))." - ".$splitDate[1];
                                    $time_from_filter = date("H:i:s", strtotime($lead->created_at));
                                    
                                    DB::table('lead_blast')->where('id',$leadblast->id)->update(["message_filter" => $final_date_filter,"time_from" => $time_from_filter,"max_blast" => $leadblast->max_blast - $count]);
                                    
                                    $get_admin_contact = DB::table('company_info')
                                                    ->select('company_info.*','users.email as admin')
                                                    ->leftjoin('users','company_info.user_id','users.id')
                                                    ->where('users.email',$lead->admin_email)
                                                    ->first();
                                                    
                                    try{
                                        if($lead->contact != null)
                                        {
                                            $send_message = $client->messages->create(
                                              $lead->contact,
                                              array(
                                                'from' => $get_admin_contact->phone_number,
                                                'body' => $leadblast->message_description
                                              )
                                            );
                                        
                                            $check_number = DB::table('lead_chat')
                                            					->where('admin_id',$admin_id)
                                            					->where('from',$lead->contact)
                                            					->orwhere('to',$lead->contact)
                                            					->first();
                                            					
                                        	if($check_number != null){
                                    	    	$response = [
                                    	    	    'admin_id' => $admin_id,
                                                    'lead_id' => $lead->id,
                                    	    		'from' => $get_admin_contact->phone_number,
                                    	    		'to' => $lead->contact,
                                    	    		'message' => $leadblast->message_description,
                                        			'chat_id' =>$check_number->chat_id,
                                    	    	];
                                    	    	$insert = DB::table('lead_chat')->insert($response);
                                    	    	
                                                if($insert){
                                                    $data = [
                                                        'updated_at' => date('Y-m-d H:i:s'),
                                                    ];
                                                    DB::table('leads')
                                                            ->where('contact',$lead->contact)
                                                            ->update($data);
                                                }
                                    	    }
                                    	    else{
                                    	    	$get_max_value = DB::table('lead_chat')->max('chat_id');
                                    	    	
                                                $count = $get_max_value + 1;
                                    
                                                $send = [
                                    	    	    'admin_id' => $admin_id,
                                                    'lead_id' => $lead->id,
                                            		'from' => $get_admin_contact->phone_number,
                                        	    	'to' => $lead->contact,
                                        	    	'message' => $leadblast->message_description,
                                            		'chat_id' =>$count,
                                        		];
                                        		$message_insert = DB::table('lead_chat')
                                        						->insert($send);
                                        	}
                                        }
                                        else
                                        {
                                            DB::table('leads')->where('id',$lead->id)->update(['lead_status' => 'Invalid Cell Number']);
                                        }
                                    }catch (\Twilio\Exceptions\RestException $e) {
                                        DB::table('leads')->where('id',$lead->id)->update(['lead_status' => 'Wrong Number']);
                                    }
                                }
                            }
                        }
                        $count++;
                    }
                }
            }
            
            
            // MMS bulk blast
            $get_mms_blast = DB::table('mms_blast')
                        ->select('mms_blast.*','users.id as user_id','users.usertype_id as usertype_id')
                        ->leftjoin('users','users.id','mms_blast.send_id')
                        ->where('mms_blast.message_status','Pending')
                        ->where('mms_blast.mms_attachments','!=',null)
                        ->where('max_blast','!=','no')
                        ->where('is_activated','yes')
                        ->get();
                          
            if($get_mms_blast->count() > 0)
            {
                foreach ($get_mms_blast as $leadblast) {
                  $splitStatus = explode(', ', $leadblast->target_status);
                  $splitDate = explode(' - ', $leadblast->message_filter);
             
                  $startdate = date("Y-m-d ".$leadblast->time_from, strtotime($splitDate[0]));
                  $enddate = date("Y-m-d ".$leadblast->time_to, strtotime($splitDate[1]));
                  
                  if($leadblast->usertype_id == 2){
                    $get_admin_email = DB::table('users')->where('id',$leadblast->user_id)->first();
                    $admin_id = $leadblast->user_id;
                    
                    if($leadblast->lead_provider != "0"){
                      $leads = DB::table('leads')
                                  ->where('lead_provider',$leadblast->lead_provider)
                                  ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                  ->where('admin_email',$get_admin_email->email)
                                  ->whereBetween('created_at',[$startdate,$enddate])
                                  ->skip(0)->take(150)
                                  ->get();
                    }
                    else{
                      $leads = DB::table('leads')
                                ->where('admin_email',$get_admin_email->email)
                                ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                ->whereBetween('created_at',[$startdate,$enddate])
                                ->skip(0)->take(150)
                                ->get();
                    }
                  }
                  else{
                    $get_agent = DB::table('users')->where('id',$leadblast->user_id)->first();
                    $admin_id = $get_agent->parent_user_id;
                    $get_admin_email = DB::table('users')->where('id',$get_agent->parent_user_id)->first();
                    
                    if($leadblast->lead_provider != "0"){
                      $leads = DB::table('leads')
                                  ->where('lead_provider',$leadblast->lead_provider)
                                  ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])    
                                  ->where('admin_email',$get_admin_email->email)
                                  ->whereBetween('created_at',[$startdate,$enddate])
                                  ->skip(0)->take(150)
                                  ->get();
                    }else{
                      $leads = DB::table('leads')
                                  ->where('admin_email',$get_admin_email->email)
                                  ->whereNotIn('lead_status',['Not Interested','Wrong Number','Sold-New','Sold-Used','Sold-Unknown','Blocked-Harassment','Blocked-Inappropirate','Appointment-Set'])
                                  ->whereBetween('created_at',[$startdate,$enddate])
                                  ->skip(0)->take(150)
                                  ->get();
                    }
                  }
                  
                  $count = 1;
                  foreach($leads as $lead)
                  {
                    for($i = 0; $i < count($splitStatus); $i++)
                    {
                        if($lead->lead_status == $splitStatus[$i]){
                    
                            if($leadblast->max_blast < 1){
                                $get_admin_contact = DB::table('company_info')
                                                ->select('company_info.*','users.email as admin')
                                                ->leftjoin('users','company_info.user_id','users.id')
                                                ->where('users.email',$lead->admin_email)
                                                ->first();
            
                                if ($get_admin_contact != null) {
                                    
                                    $final_date_filter = date("m/d/Y", strtotime($leadblast->date_from))." - ".$splitDate[1];
                                    DB::table('mms_blast')->where('id',$leadblast->id)->update(["message_filter" => $final_date_filter, "max_bulk" => $leadblast->send_limit, "message_status" => 'Sent']);
                                    
                                    return "true";
                                }
                            }
                            else
                            {
                                $final_date_filter = date("m/d/Y", strtotime($lead->created_at))." - ".$splitDate[1];
                                $time_from_filter = date("H:i:s", strtotime($lead->created_at));
                                
                                DB::table('mms_blast')->where('id',$leadblast->id)->update(["message_filter" => $final_date_filter,"time_from" => $time_from_filter,"max_blast" => $leadblast->max_blast - $count]);
                                
                                $get_admin_contact = DB::table('company_info')
                                                ->select('company_info.*','users.email as admin')
                                                ->leftjoin('users','company_info.user_id','users.id')
                                                ->where('users.email',$lead->admin_email)
                                                ->first();
                                                
                                try{
                                    $msg_body = null;
                                    if(empty($leadblast->message_description))
                                    {
                                        $msg_body = "MMS Message!";
                                    }else
                                    {
                                        $msg_body = $leadblast->message_description;
                                    }
                                    
                                    if($lead->contact != null)
                                    {
                                        $send_message = $client->messages->create(
                                          $lead->contact,
                                          array(
                                            "body" => $msg_body,
                                            "from" => $get_admin_contact->phone_number,
                                            "mediaUrl" => [$leadblast->mms_attachments]
                                          )
                                        );
                                    
                                        $check_number = DB::table('lead_chat')
                                        					->where('admin_id',$admin_id)
                                        					->where('from',$lead->contact)
                                        					->orwhere('to',$lead->contact)
                                        					->first();
                                        					
                                    	if($check_number != null){
                                	    	$response = [
                                	    	    'admin_id' => $admin_id,
                                                'lead_id' => $lead->id,
                                	    		'from' => $get_admin_contact->phone_number,
                                	    		'to' => $lead->contact,
                                	    		'message' => $msg_body,
                        		                'mms_attachments' => $leadblast->mms_attachments,
                                    			'chat_id' =>$check_number->chat_id,
                                	    	];
                                	    	$insert = DB::table('lead_chat')->insert($response);
                                	    	
                                            if($insert){
                                                $data = [
                                                    'updated_at' => date('Y-m-d H:i:s'),
                                                ];
                                                DB::table('leads')->where('contact',$lead->contact)->update($data);
                                            }
                                	    }
                                	    else{
                                	    	$get_max_value = DB::table('lead_chat')->max('chat_id');
                                	    	
                                            $count = $get_max_value + 1;
                                
                                            $send = [
                                	    	    'admin_id' => $admin_id,
                                                'lead_id' => $lead->id,
                                        		'from' => $get_admin_contact->phone_number,
                                    	    	'to' => $lead->contact,
                                    	    	'message' => $msg_body,
                        		                'mms_attachments' => $leadblast->mms_attachments,
                                        		'chat_id' =>$count,
                                    		];
                                    		
                                    		$message_insert = DB::table('lead_chat')->insert($send);
                                    		
                                    		$data = [
                                                'updated_at' => date('Y-m-d H:i:s'),
                                            ];
                                            DB::table('leads')->where('contact',$lead->contact)->update($data);
                                                
                                    	}
                                    }
                                    else
                                    {
                                        DB::table('leads')->where('id',$lead->id)->update(['lead_status' => 'Invalid Cell Number']);
                                    }
                                }catch (\Twilio\Exceptions\RestException $e) {
                                    DB::table('leads')->where('id',$lead->id)->update(['lead_status' => 'Wrong Number']);
                                }
                            }
                        }
                    
                    }
                    $count++;
                    
                  }
                }
            }
        }
    }
}
