<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class PhoneCallOptions {
    /**
     * @param string $reason The business reason for this phone call
     * @param string $applicationSid Refers to the Voice API Initiate Call parameter
     * @param string $callerId Refers to the Voice API Initiate Call parameter
     * @param string $fallbackMethod Refers to the Voice API Initiate Call parameter
     * @param string $fallbackUrl Refers to the Voice API Initiate Call parameter
     * @param string $machineDetection Refers to the Voice API Initiate Call
     *                                 parameter
     * @param int $machineDetectionSilenceTimeout Refers to the Voice API Initiate
     *                                            Call parameter
     * @param int $machineDetectionSpeechEndThreshold Refers to the Voice API
     *                                                Initiate Call parameter
     * @param int $machineDetectionSpeechThreshold Refers to the Voice API Initiate
     *                                             Call parameter
     * @param int $machineDetectionTimeout Refers to the Voice API Initiate Call
     *                                     parameter
     * @param string $method Refers to the Voice API Initiate Call parameter
     * @param bool $record Refers to the Voice API Initiate Call parameter
     * @param string $recordingChannels Refers to the Voice API Initiate Call
     *                                  parameter
     * @param string $recordingStatusCallback Refers to the Voice API Initiate Call
     *                                        parameter
     * @param string[] $recordingStatusCallbackEvent Refers to the Voice API
     *                                               Initiate Call parameter
     * @param string $recordingStatusCallbackMethod Refers to the Voice API
     *                                              Initiate Call parameter
     * @param string $sendDigits Refers to the Voice API Initiate Call parameter
     * @param string $sipAuthPassword Refers to the Voice API Initiate Call
     *                                parameter
     * @param string $sipAuthUsername Refers to the Voice API Initiate Call
     *                                parameter
     * @param string $statusCallback Refers to the Voice API Initiate Call parameter
     * @param string[] $statusCallbackEvent Refers to the Voice API Initiate Call
     *                                      parameter
     * @param string $statusCallbackMethod Refers to the Voice API Initiate Call
     *                                     parameter
     * @param int $timeout Refers to the Voice API Initiate Call parameter
     * @param string $trim Refers to the Voice API Initiate Call parameter
     * @param string $url Refers to the Voice API Initiate Call parameter
     * @return CreatePhoneCallOptions Options builder
     */
    public static function create(string $reason = Values::NONE, string $applicationSid = Values::NONE, string $callerId = Values::NONE, string $fallbackMethod = Values::NONE, string $fallbackUrl = Values::NONE, string $machineDetection = Values::NONE, int $machineDetectionSilenceTimeout = Values::NONE, int $machineDetectionSpeechEndThreshold = Values::NONE, int $machineDetectionSpeechThreshold = Values::NONE, int $machineDetectionTimeout = Values::NONE, string $method = Values::NONE, bool $record = Values::NONE, string $recordingChannels = Values::NONE, string $recordingStatusCallback = Values::NONE, string[] $recordingStatusCallbackEvent = Values::NONE, string $recordingStatusCallbackMethod = Values::NONE, string $sendDigits = Values::NONE, string $sipAuthPassword = Values::NONE, string $sipAuthUsername = Values::NONE, string $statusCallback = Values::NONE, string[] $statusCallbackEvent = Values::NONE, string $statusCallbackMethod = Values::NONE, int $timeout = Values::NONE, string $trim = Values::NONE, string $url = Values::NONE): CreatePhoneCallOptions {
        return new CreatePhoneCallOptions($reason, $applicationSid, $callerId, $fallbackMethod, $fallbackUrl, $machineDetection, $machineDetectionSilenceTimeout, $machineDetectionSpeechEndThreshold, $machineDetectionSpeechThreshold, $machineDetectionTimeout, $method, $record, $recordingChannels, $recordingStatusCallback, $recordingStatusCallbackEvent, $recordingStatusCallbackMethod, $sendDigits, $sipAuthPassword, $sipAuthUsername, $statusCallback, $statusCallbackEvent, $statusCallbackMethod, $timeout, $trim, $url);
    }
}

class CreatePhoneCallOptions extends Options {
    /**
     * @param string $reason The business reason for this phone call
     * @param string $applicationSid Refers to the Voice API Initiate Call parameter
     * @param string $callerId Refers to the Voice API Initiate Call parameter
     * @param string $fallbackMethod Refers to the Voice API Initiate Call parameter
     * @param string $fallbackUrl Refers to the Voice API Initiate Call parameter
     * @param string $machineDetection Refers to the Voice API Initiate Call
     *                                 parameter
     * @param int $machineDetectionSilenceTimeout Refers to the Voice API Initiate
     *                                            Call parameter
     * @param int $machineDetectionSpeechEndThreshold Refers to the Voice API
     *                                                Initiate Call parameter
     * @param int $machineDetectionSpeechThreshold Refers to the Voice API Initiate
     *                                             Call parameter
     * @param int $machineDetectionTimeout Refers to the Voice API Initiate Call
     *                                     parameter
     * @param string $method Refers to the Voice API Initiate Call parameter
     * @param bool $record Refers to the Voice API Initiate Call parameter
     * @param string $recordingChannels Refers to the Voice API Initiate Call
     *                                  parameter
     * @param string $recordingStatusCallback Refers to the Voice API Initiate Call
     *                                        parameter
     * @param string[] $recordingStatusCallbackEvent Refers to the Voice API
     *                                               Initiate Call parameter
     * @param string $recordingStatusCallbackMethod Refers to the Voice API
     *                                              Initiate Call parameter
     * @param string $sendDigits Refers to the Voice API Initiate Call parameter
     * @param string $sipAuthPassword Refers to the Voice API Initiate Call
     *                                parameter
     * @param string $sipAuthUsername Refers to the Voice API Initiate Call
     *                                parameter
     * @param string $statusCallback Refers to the Voice API Initiate Call parameter
     * @param string[] $statusCallbackEvent Refers to the Voice API Initiate Call
     *                                      parameter
     * @param string $statusCallbackMethod Refers to the Voice API Initiate Call
     *                                     parameter
     * @param int $timeout Refers to the Voice API Initiate Call parameter
     * @param string $trim Refers to the Voice API Initiate Call parameter
     * @param string $url Refers to the Voice API Initiate Call parameter
     */
    public function __construct(string $reason = Values::NONE, string $applicationSid = Values::NONE, string $callerId = Values::NONE, string $fallbackMethod = Values::NONE, string $fallbackUrl = Values::NONE, string $machineDetection = Values::NONE, int $machineDetectionSilenceTimeout = Values::NONE, int $machineDetectionSpeechEndThreshold = Values::NONE, int $machineDetectionSpeechThreshold = Values::NONE, int $machineDetectionTimeout = Values::NONE, string $method = Values::NONE, bool $record = Values::NONE, string $recordingChannels = Values::NONE, string $recordingStatusCallback = Values::NONE, string[] $recordingStatusCallbackEvent = Values::NONE, string $recordingStatusCallbackMethod = Values::NONE, string $sendDigits = Values::NONE, string $sipAuthPassword = Values::NONE, string $sipAuthUsername = Values::NONE, string $statusCallback = Values::NONE, string[] $statusCallbackEvent = Values::NONE, string $statusCallbackMethod = Values::NONE, int $timeout = Values::NONE, string $trim = Values::NONE, string $url = Values::NONE) {
        $this->options['reason'] = $reason;
        $this->options['applicationSid'] = $applicationSid;
        $this->options['callerId'] = $callerId;
        $this->options['fallbackMethod'] = $fallbackMethod;
        $this->options['fallbackUrl'] = $fallbackUrl;
        $this->options['machineDetection'] = $machineDetection;
        $this->options['machineDetectionSilenceTimeout'] = $machineDetectionSilenceTimeout;
        $this->options['machineDetectionSpeechEndThreshold'] = $machineDetectionSpeechEndThreshold;
        $this->options['machineDetectionSpeechThreshold'] = $machineDetectionSpeechThreshold;
        $this->options['machineDetectionTimeout'] = $machineDetectionTimeout;
        $this->options['method'] = $method;
        $this->options['record'] = $record;
        $this->options['recordingChannels'] = $recordingChannels;
        $this->options['recordingStatusCallback'] = $recordingStatusCallback;
        $this->options['recordingStatusCallbackEvent'] = $recordingStatusCallbackEvent;
        $this->options['recordingStatusCallbackMethod'] = $recordingStatusCallbackMethod;
        $this->options['sendDigits'] = $sendDigits;
        $this->options['sipAuthPassword'] = $sipAuthPassword;
        $this->options['sipAuthUsername'] = $sipAuthUsername;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['statusCallbackEvent'] = $statusCallbackEvent;
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        $this->options['timeout'] = $timeout;
        $this->options['trim'] = $trim;
        $this->options['url'] = $url;
    }

    /**
     * The business reason for this phone call that will appear in the terminating device's screen. Max 50 characters.
     *
     * @param string $reason The business reason for this phone call
     * @return $this Fluent Builder
     */
    public function setReason(string $reason): self {
        $this->options['reason'] = $reason;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $applicationSid Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setApplicationSid(string $applicationSid): self {
        $this->options['applicationSid'] = $applicationSid;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $callerId Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setCallerId(string $callerId): self {
        $this->options['callerId'] = $callerId;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $fallbackMethod Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setFallbackMethod(string $fallbackMethod): self {
        $this->options['fallbackMethod'] = $fallbackMethod;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $fallbackUrl Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setFallbackUrl(string $fallbackUrl): self {
        $this->options['fallbackUrl'] = $fallbackUrl;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $machineDetection Refers to the Voice API Initiate Call
     *                                 parameter
     * @return $this Fluent Builder
     */
    public function setMachineDetection(string $machineDetection): self {
        $this->options['machineDetection'] = $machineDetection;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param int $machineDetectionSilenceTimeout Refers to the Voice API Initiate
     *                                            Call parameter
     * @return $this Fluent Builder
     */
    public function setMachineDetectionSilenceTimeout(int $machineDetectionSilenceTimeout): self {
        $this->options['machineDetectionSilenceTimeout'] = $machineDetectionSilenceTimeout;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param int $machineDetectionSpeechEndThreshold Refers to the Voice API
     *                                                Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setMachineDetectionSpeechEndThreshold(int $machineDetectionSpeechEndThreshold): self {
        $this->options['machineDetectionSpeechEndThreshold'] = $machineDetectionSpeechEndThreshold;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param int $machineDetectionSpeechThreshold Refers to the Voice API Initiate
     *                                             Call parameter
     * @return $this Fluent Builder
     */
    public function setMachineDetectionSpeechThreshold(int $machineDetectionSpeechThreshold): self {
        $this->options['machineDetectionSpeechThreshold'] = $machineDetectionSpeechThreshold;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param int $machineDetectionTimeout Refers to the Voice API Initiate Call
     *                                     parameter
     * @return $this Fluent Builder
     */
    public function setMachineDetectionTimeout(int $machineDetectionTimeout): self {
        $this->options['machineDetectionTimeout'] = $machineDetectionTimeout;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $method Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setMethod(string $method): self {
        $this->options['method'] = $method;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param bool $record Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setRecord(bool $record): self {
        $this->options['record'] = $record;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $recordingChannels Refers to the Voice API Initiate Call
     *                                  parameter
     * @return $this Fluent Builder
     */
    public function setRecordingChannels(string $recordingChannels): self {
        $this->options['recordingChannels'] = $recordingChannels;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $recordingStatusCallback Refers to the Voice API Initiate Call
     *                                        parameter
     * @return $this Fluent Builder
     */
    public function setRecordingStatusCallback(string $recordingStatusCallback): self {
        $this->options['recordingStatusCallback'] = $recordingStatusCallback;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string[] $recordingStatusCallbackEvent Refers to the Voice API
     *                                               Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setRecordingStatusCallbackEvent(string[] $recordingStatusCallbackEvent): self {
        $this->options['recordingStatusCallbackEvent'] = $recordingStatusCallbackEvent;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $recordingStatusCallbackMethod Refers to the Voice API
     *                                              Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setRecordingStatusCallbackMethod(string $recordingStatusCallbackMethod): self {
        $this->options['recordingStatusCallbackMethod'] = $recordingStatusCallbackMethod;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $sendDigits Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setSendDigits(string $sendDigits): self {
        $this->options['sendDigits'] = $sendDigits;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $sipAuthPassword Refers to the Voice API Initiate Call
     *                                parameter
     * @return $this Fluent Builder
     */
    public function setSipAuthPassword(string $sipAuthPassword): self {
        $this->options['sipAuthPassword'] = $sipAuthPassword;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $sipAuthUsername Refers to the Voice API Initiate Call
     *                                parameter
     * @return $this Fluent Builder
     */
    public function setSipAuthUsername(string $sipAuthUsername): self {
        $this->options['sipAuthUsername'] = $sipAuthUsername;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $statusCallback Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setStatusCallback(string $statusCallback): self {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string[] $statusCallbackEvent Refers to the Voice API Initiate Call
     *                                      parameter
     * @return $this Fluent Builder
     */
    public function setStatusCallbackEvent(string[] $statusCallbackEvent): self {
        $this->options['statusCallbackEvent'] = $statusCallbackEvent;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $statusCallbackMethod Refers to the Voice API Initiate Call
     *                                     parameter
     * @return $this Fluent Builder
     */
    public function setStatusCallbackMethod(string $statusCallbackMethod): self {
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param int $timeout Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setTimeout(int $timeout): self {
        $this->options['timeout'] = $timeout;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $trim Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setTrim(string $trim): self {
        $this->options['trim'] = $trim;
        return $this;
    }

    /**
     * Refers to the parameter with the same name when [initiating a call via Voice API](https://www.twilio.com/docs/voice/api/call#create-a-call-resource)
     *
     * @param string $url Refers to the Voice API Initiate Call parameter
     * @return $this Fluent Builder
     */
    public function setUrl(string $url): self {
        $this->options['url'] = $url;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.TrustedComms.CreatePhoneCallOptions ' . \implode(' ', $options) . ']';
    }
}